/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerSettingsFactory;
import com.intellij.compiler.impl.rmiCompiler.RmicConfiguration;
import com.intellij.compiler.options.AnnotationProcessorsConfigurable;
import com.intellij.compiler.options.CompilerUIConfigurable;
import com.intellij.compiler.options.JavaCompilersTab;
import com.intellij.compiler.options.RmicConfigurable;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfigurable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatusManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class CompilerConfigurable
implements SearchableConfigurable.Parent {
    private final Project myProject;
    private static final Icon ICON = IconLoader.getIcon((String)"/general/configurableCompiler.png");
    private final CompilerUIConfigurable myCompilerUIConfigurable;
    private Configurable[] myKids;

    public static CompilerConfigurable getInstance(Project project) {
        return (CompilerConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, CompilerConfigurable.class);
    }

    public CompilerConfigurable(Project project) {
        this.myProject = project;
        this.myCompilerUIConfigurable = new CompilerUIConfigurable(this.myProject);
    }

    public String getDisplayName() {
        return CompilerBundle.message((String)"compiler.configurable.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getHelpTopic() {
        return "project.propCompiler";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myCompilerUIConfigurable.createComponent();
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isModified() {
        return this.myCompilerUIConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myCompilerUIConfigurable.apply();
    }

    public void reset() {
        this.myCompilerUIConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myCompilerUIConfigurable.disposeUIResources();
    }

    public Configurable[] getConfigurables() {
        if (this.myKids == null) {
            ArrayList<Object> kids = new ArrayList<Object>();
            CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true);
            ExcludedEntriesConfigurable excludes = new ExcludedEntriesConfigurable(this.myProject, descriptor, compilerConfiguration.getExcludedEntriesConfiguration()){

                public void apply() {
                    super.apply();
                    FileStatusManager.getInstance((Project)CompilerConfigurable.this.myProject).fileStatusesChanged();
                }
            };
            kids.add(CompilerConfigurable.createExcludesWrapper(excludes));
            ArrayList<Object> additional = new ArrayList<Object>();
            CompilerSettingsFactory[] factories = (CompilerSettingsFactory[])Extensions.getExtensions((ExtensionPointName)CompilerSettingsFactory.EP_NAME, (AreaInstance)this.myProject);
            if (factories.length > 0) {
                for (CompilerSettingsFactory factory : factories) {
                    additional.add(factory.create(this.myProject));
                }
                Collections.sort(additional, new Comparator<Configurable>(){

                    @Override
                    public int compare(Configurable o1, Configurable o2) {
                        return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
                    }
                });
            }
            additional.add(0, new RmicConfigurable(RmicConfiguration.getSettings(this.myProject)));
            additional.add(0, new AnnotationProcessorsConfigurable(this.myProject));
            additional.add(0, new JavaCompilersTab(this.myProject, compilerConfiguration.getRegisteredJavaCompilers(), compilerConfiguration.getDefaultCompiler()));
            kids.addAll(additional);
            this.myKids = kids.toArray(new Configurable[kids.size()]);
        }
        return this.myKids;
    }

    private static Configurable createExcludesWrapper(final ExcludedEntriesConfigurable excludes) {
        return new SearchableConfigurable(){

            @Nls
            public String getDisplayName() {
                return "Excludes";
            }

            public Icon getIcon() {
                return null;
            }

            public String getHelpTopic() {
                return "reference.projectsettings.compiler.excludes";
            }

            public JComponent createComponent() {
                return excludes.createComponent();
            }

            public void apply() {
                excludes.apply();
            }

            public boolean isModified() {
                return excludes.isModified();
            }

            public void reset() {
                excludes.reset();
            }

            public void disposeUIResources() {
                excludes.disposeUIResources();
            }

            public String getId() {
                return this.getHelpTopic();
            }

            public Runnable enableSearch(String option) {
                return null;
            }
        };
    }
}

