/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class CachedPersistentHashMap<Key, Value>
extends PersistentHashMap<Key, Value> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.CachedPersistentHashMap");
    protected final SLRUMap<Key, Value> myCache;

    public CachedPersistentHashMap(File file, KeyDescriptor<Key> keyDescriptor, DataExternalizer<Value> valDescriptor, int cacheSize) throws IOException {
        super(file, keyDescriptor, valDescriptor);
        this.myCache = new SLRUMap<Key, Value>(cacheSize * 2, cacheSize){

            protected void onDropFromCache(Key key, Value value) {
                if (CachedPersistentHashMap.this.isValueDirty(value)) {
                    try {
                        CachedPersistentHashMap.super.put(key, value);
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        };
    }

    protected boolean isValueDirty(Value value) {
        return false;
    }

    public synchronized void put(Key key, Value value) throws IOException {
        this.myCache.remove(key);
        super.put(key, value);
    }

    public synchronized void appendData(Key key, PersistentHashMap.ValueDataAppender appender) throws IOException {
        this.myCache.remove(key);
        super.appendData(key, appender);
    }

    @Nullable
    public synchronized Value get(Key key) throws IOException {
        Object value = this.myCache.get(key);
        if (value == null && (value = super.get(key)) != null) {
            this.myCache.put(key, value);
        }
        return (Value)value;
    }

    public synchronized boolean containsMapping(Key key) throws IOException {
        Object value = this.myCache.get(key);
        return value != null || super.containsMapping(key);
    }

    public synchronized void remove(Key key) throws IOException {
        this.myCache.remove(key);
        super.remove(key);
    }

    public synchronized void force() {
        this.clearCache();
        super.force();
    }

    public synchronized void close() throws IOException {
        this.clearCache();
        super.close();
    }

    public void clearCache() {
        this.myCache.clear();
    }
}

