/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerException;
import com.intellij.compiler.impl.CompileContextExProxy;
import com.intellij.compiler.impl.javaCompiler.BackendCompilerWrapper;
import com.intellij.compiler.impl.javaCompiler.javac.JavacCompiler;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Chunk;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnnotationProcessingCompiler
implements TranslatingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.JavaCompiler");
    private final Project myProject;
    private CompilerConfiguration myConfig;

    public AnnotationProcessingCompiler(Project project) {
        this.myProject = project;
        this.myConfig = CompilerConfiguration.getInstance((Project)project);
    }

    @NotNull
    public String getDescription() {
        String string = CompilerBundle.message((String)"annotation.processing.compiler.description", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/AnnotationProcessingCompiler.getDescription must not return null");
        }
        return string;
    }

    public boolean isCompilableFile(VirtualFile file, CompileContext context) {
        if (!this.myConfig.isAnnotationProcessorsEnabled()) {
            return false;
        }
        return file.getFileType() == StdFileTypes.JAVA && !this.isExcludedFromAnnotationProcessing(file, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void compile(CompileContext context, Chunk<Module> moduleChunk, VirtualFile[] files, TranslatingCompiler.OutputSink sink) {
        block11: {
            if (!this.myConfig.isAnnotationProcessorsEnabled()) {
                return;
            }
            final LocalFileSystem lfs = LocalFileSystem.getInstance();
            CompileContextExProxy _context = new CompileContextExProxy((CompileContextEx)context){

                @Override
                public VirtualFile getModuleOutputDirectory(Module module) {
                    String path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module);
                    return path != null ? lfs.findFileByPath(path) : null;
                }
            };
            JavacCompiler javacCompiler = this.getBackEndCompiler();
            boolean processorMode = javacCompiler.setAnnotationProcessorMode(true);
            BackendCompilerWrapper wrapper = new BackendCompilerWrapper(moduleChunk, this.myProject, Arrays.asList(files), _context, javacCompiler, sink);
            try {
                wrapper.compile();
                javacCompiler.setAnnotationProcessorMode(processorMode);
            }
            catch (CompilerException e) {
                _context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                javacCompiler.setAnnotationProcessorMode(processorMode);
                HashSet dirsToRefresh = new HashSet();
                ApplicationManager.getApplication().runReadAction(new Runnable(moduleChunk, _context, dirsToRefresh){
                    final /* synthetic */ Chunk val$moduleChunk;
                    final /* synthetic */ CompileContextEx val$_context;
                    final /* synthetic */ Set val$dirsToRefresh;
                    {
                        this.val$moduleChunk = chunk;
                        this.val$_context = compileContextEx;
                        this.val$dirsToRefresh = set;
                    }

                    @Override
                    public void run() {
                        for (Module module : this.val$moduleChunk.getNodes()) {
                            VirtualFile out = this.val$_context.getModuleOutputDirectory(module);
                            if (out == null) continue;
                            this.val$dirsToRefresh.add(out);
                        }
                    }
                });
                for (VirtualFile root : dirsToRefresh) {
                    root.refresh(false, true);
                }
            }
            HashSet dirsToRefresh = new HashSet();
            ApplicationManager.getApplication().runReadAction(new /* invalid duplicate definition of identical inner class */);
            for (VirtualFile root : dirsToRefresh) {
                root.refresh(false, true);
            }
            break block11;
            break block11;
            catch (CacheCorruptedException e2) {
                LOG.info((Throwable)e2);
                _context.requestRebuildNextTime(e2.getMessage());
                javacCompiler.setAnnotationProcessorMode(processorMode);
                dirsToRefresh = new HashSet();
                ApplicationManager.getApplication().runReadAction(new /* invalid duplicate definition of identical inner class */);
                for (VirtualFile root : dirsToRefresh) {
                    root.refresh(false, true);
                }
                {
                    catch (Throwable throwable) {
                        javacCompiler.setAnnotationProcessorMode(processorMode);
                        HashSet dirsToRefresh2 = new HashSet();
                        ApplicationManager.getApplication().runReadAction(new /* invalid duplicate definition of identical inner class */);
                        for (VirtualFile root : dirsToRefresh2) {
                            root.refresh(false, true);
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    private boolean isExcludedFromAnnotationProcessing(VirtualFile file, CompileContext context) {
        Module module = context.getModuleByFile(file);
        if (module != null) {
            VirtualFile generationDir;
            if (!this.myConfig.isAnnotationProcessingEnabled(module)) {
                return true;
            }
            String path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module);
            VirtualFile virtualFile = generationDir = path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
            if (generationDir != null && VfsUtil.isAncestor((VirtualFile)generationDir, (VirtualFile)file, (boolean)false)) {
                return true;
            }
        }
        return this.myConfig.isExcludedFromCompilation(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateConfiguration(CompileScope scope) {
        JavacCompiler compiler = this.getBackEndCompiler();
        boolean previousValue = compiler.setAnnotationProcessorMode(true);
        try {
            boolean bl = compiler.checkCompiler(scope);
            return bl;
        }
        finally {
            compiler.setAnnotationProcessorMode(previousValue);
        }
    }

    private JavacCompiler getBackEndCompiler() {
        CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        return configuration.getJavacCompiler();
    }
}

