/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.AnnotationNameValuePair;
import com.intellij.compiler.classParsing.AnnotationPrimitiveConstantValue;
import com.intellij.compiler.classParsing.ClassInfoConstantValue;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.ConstantValueArray;
import com.intellij.compiler.classParsing.DoubleConstantValue;
import com.intellij.compiler.classParsing.EnumConstantValue;
import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.classParsing.FloatConstantValue;
import com.intellij.compiler.classParsing.IntegerConstantValue;
import com.intellij.compiler.classParsing.LongConstantValue;
import com.intellij.compiler.classParsing.MemberInfo;
import com.intellij.compiler.classParsing.MemberReferenceInfo;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.classParsing.ReferenceInfo;
import com.intellij.compiler.classParsing.StringConstantValue;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.BytePointer;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.cls.ClsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileReader {
    private final File myFile;
    private byte[] myData;
    private int[] myConstantPoolOffsets;
    private String myQualifiedName;
    private String myGenericSignature;
    private List<ReferenceInfo> myReferences;
    private List<FieldInfo> myFields;
    private List<MethodInfo> myMethods;
    private String mySourceFileName;
    private String mySuperClassName;
    private String[] mySuperInterfaces;
    private final SymbolTable mySymbolTable;
    private AnnotationConstantValue[] myRuntimeVisibleAnnotations;
    private AnnotationConstantValue[] myRuntimeInvisibleAnnotations;
    @NonNls
    private static final String CONSTRUCTOR_NAME = "<init>";

    public ClassFileReader(@NotNull File file, SymbolTable symbolTable, @Nullable byte[] fileContent) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/classParsing/ClassFileReader.<init> must not be null");
        }
        this.myConstantPoolOffsets = null;
        this.mySymbolTable = symbolTable;
        this.myFile = file;
        this.myData = fileContent;
    }

    public String getPath() {
        return this.myFile.getAbsolutePath();
    }

    public Collection<ReferenceInfo> getReferences() throws ClsFormatException {
        this.parseConstantPool();
        return this.myReferences;
    }

    public MethodInfo[] getMethods() throws ClsFormatException {
        if (this.myMethods == null) {
            this.parseMembers();
        }
        return this.myMethods.toArray(new MethodInfo[this.myMethods.size()]);
    }

    public FieldInfo[] getFields() throws ClsFormatException {
        if (this.myFields == null) {
            this.parseMembers();
        }
        return this.myFields.toArray(new FieldInfo[this.myFields.size()]);
    }

    private void parseMembers() throws ClsFormatException {
        String name;
        this.initConstantPool();
        this.myMethods = new ArrayList<MethodInfo>();
        this.myFields = new ArrayList<FieldInfo>();
        BytePointer ptr = new BytePointer(this.getData(), this.getConstantPoolEnd());
        ptr.offset += 2;
        ptr.offset += 2;
        ptr.offset += 2;
        int count = ClsUtil.readU2((BytePointer)ptr);
        ptr.offset += 2 * count;
        count = ClsUtil.readU2((BytePointer)ptr);
        while (count-- > 0) {
            FieldInfo field = (FieldInfo)this.readMemberStructure(ptr, true);
            name = this.getSymbol(field.getName());
            if (name.indexOf(36) >= 0 || name.indexOf(60) >= 0) continue;
            this.myFields.add(field);
        }
        count = ClsUtil.readU2((BytePointer)ptr);
        while (count-- > 0) {
            MethodInfo method = (MethodInfo)this.readMemberStructure(ptr, false);
            name = this.getSymbol(method.getName());
            if (name.indexOf(36) < 0 && name.indexOf(60) < 0) {
                this.myMethods.add(method);
                continue;
            }
            if (!CONSTRUCTOR_NAME.equals(name)) continue;
            this.myMethods.add(method);
        }
        ClsAttributeTable attributeTable = this.readAttributes(ptr);
        this.mySourceFileName = attributeTable.sourceFile;
        this.myGenericSignature = attributeTable.genericSignature;
        this.myRuntimeVisibleAnnotations = attributeTable.runtimeVisibleAnnotations;
        this.myRuntimeInvisibleAnnotations = attributeTable.runtimeInvisibleAnnotations;
    }

    private String getSymbol(int id) throws ClsFormatException {
        try {
            return this.mySymbolTable.getSymbol(id);
        }
        catch (CacheCorruptedException e) {
            throw new ClsFormatException(e.getLocalizedMessage());
        }
    }

    private MemberInfo readMemberStructure(BytePointer ptr, boolean isField) throws ClsFormatException {
        int flags = ClsUtil.readU2((BytePointer)ptr);
        int nameIndex = ClsUtil.readU2((BytePointer)ptr);
        int descriptorIndex = ClsUtil.readU2((BytePointer)ptr);
        BytePointer p = new BytePointer(this.getData(), this.getOffsetInConstantPool(nameIndex));
        String name = ClsUtil.readUtf8Info((BytePointer)p);
        p.offset = this.getOffsetInConstantPool(descriptorIndex);
        String descriptor = ClsUtil.readUtf8Info((BytePointer)p);
        if (isField) {
            ClsAttributeTable attributeTable = this.readAttributes(ptr);
            return new FieldInfo(this.getSymbolId(name), this.getSymbolId(descriptor), attributeTable.genericSignature != null ? this.getSymbolId(attributeTable.genericSignature) : -1, flags, attributeTable.constantValue, attributeTable.runtimeVisibleAnnotations, attributeTable.runtimeInvisibleAnnotations);
        }
        ClsAttributeTable attributeTable = this.readAttributes(ptr);
        int[] intExceptions = null;
        if (attributeTable.exceptions != null) {
            intExceptions = ArrayUtil.newIntArray((int)attributeTable.exceptions.length);
            for (int idx = 0; idx < intExceptions.length; ++idx) {
                intExceptions[idx] = this.getSymbolId(attributeTable.exceptions[idx]);
            }
        }
        return new MethodInfo(this.getSymbolId(name), this.getSymbolId(descriptor), attributeTable.genericSignature != null ? this.getSymbolId(attributeTable.genericSignature) : -1, flags, intExceptions, CONSTRUCTOR_NAME.equals(name), attributeTable.runtimeVisibleAnnotations, attributeTable.runtimeInvisibleAnnotations, attributeTable.runtimeVisibleParameterAnnotations, attributeTable.runtimeInvisibleParameterAnnotations, attributeTable.annotationDefault);
    }

    private int getSymbolId(String symbol) throws ClsFormatException {
        try {
            return this.mySymbolTable.getId(symbol);
        }
        catch (CacheCorruptedException e) {
            throw new ClsFormatException(e.getLocalizedMessage());
        }
    }

    public String getQualifiedName() throws ClsFormatException {
        if (this.myQualifiedName == null) {
            BytePointer ptr = new BytePointer(this.getData(), this.getConstantPoolEnd() + 2);
            ptr.offset = this.getOffsetInConstantPool(ClsUtil.readU2((BytePointer)ptr));
            int tag = ClsUtil.readU1((BytePointer)ptr);
            if (tag != 7) {
                throw new ClsFormatException();
            }
            ptr.offset = this.getOffsetInConstantPool(ClsUtil.readU2((BytePointer)ptr));
            this.myQualifiedName = ClsUtil.readUtf8Info((BytePointer)ptr, (int)47, (int)46);
        }
        return this.myQualifiedName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSuperClass() throws ClsFormatException {
        if (this.mySuperClassName != null) return this.mySuperClassName;
        BytePointer ptr = new BytePointer(this.getData(), this.getConstantPoolEnd() + 4);
        int index = ClsUtil.readU2((BytePointer)ptr);
        if (index == 0) {
            if (!"java.lang.Object".equals(this.getQualifiedName())) throw new ClsFormatException();
            this.mySuperClassName = "";
            return this.mySuperClassName;
        } else {
            ptr.offset = this.getOffsetInConstantPool(index);
            this.mySuperClassName = this.readClassInfo(ptr);
            if (!this.isInterface() || "java.lang.Object".equals(this.mySuperClassName)) return this.mySuperClassName;
            throw new ClsFormatException();
        }
    }

    public String[] getSuperInterfaces() throws ClsFormatException {
        if (this.mySuperInterfaces == null) {
            BytePointer ptr = new BytePointer(this.getData(), this.getConstantPoolEnd() + 6);
            int count = ClsUtil.readU2((BytePointer)ptr);
            this.mySuperInterfaces = ArrayUtil.newStringArray((int)count);
            BytePointer auxPtr = new BytePointer(ptr.bytes, 0);
            for (int idx = 0; idx < this.mySuperInterfaces.length; ++idx) {
                auxPtr.offset = this.getOffsetInConstantPool(ClsUtil.readU2((BytePointer)ptr));
                this.mySuperInterfaces[idx] = this.readClassInfo(auxPtr);
            }
        }
        return this.mySuperInterfaces;
    }

    public String getSourceFileName() throws ClsFormatException {
        if (this.mySourceFileName == null) {
            this.parseMembers();
            if (this.mySourceFileName == null) {
                this.mySourceFileName = "";
            }
        }
        return this.mySourceFileName;
    }

    public String getGenericSignature() throws ClsFormatException {
        if (this.myGenericSignature == null) {
            this.parseMembers();
            if (this.myGenericSignature == null) {
                this.myGenericSignature = "";
            }
        }
        return this.myGenericSignature.length() == 0 ? null : this.myGenericSignature;
    }

    public AnnotationConstantValue[] getRuntimeVisibleAnnotations() throws ClsFormatException {
        if (this.myRuntimeVisibleAnnotations == null) {
            this.parseMembers();
            if (this.myRuntimeVisibleAnnotations == null) {
                this.myRuntimeVisibleAnnotations = AnnotationConstantValue.EMPTY_ARRAY;
            }
        }
        return this.myRuntimeVisibleAnnotations;
    }

    public AnnotationConstantValue[] getRuntimeInvisibleAnnotations() throws ClsFormatException {
        if (this.myRuntimeInvisibleAnnotations == null) {
            this.parseMembers();
            if (this.myRuntimeInvisibleAnnotations == null) {
                this.myRuntimeInvisibleAnnotations = AnnotationConstantValue.EMPTY_ARRAY;
            }
        }
        return this.myRuntimeInvisibleAnnotations;
    }

    private boolean isInterface() {
        return (this.getAccessFlags() & 0x200) != 0;
    }

    private void parseConstantPool() throws ClsFormatException {
        if (this.myReferences != null) {
            return;
        }
        this.myReferences = new ArrayList<ReferenceInfo>();
        this.initConstantPool();
        BytePointer ptr = new BytePointer(this.getData(), 0);
        ConstantPoolIterator iterator = new ConstantPoolIterator(ptr);
        while (iterator.hasMoreEntries()) {
            int tag = ClsUtil.readU1((BytePointer)ptr);
            if (tag == 9 || tag == 10 || tag == 11) {
                MemberReferenceInfo refInfo = this.readRefStructure(tag, ptr);
                if (refInfo != null) {
                    this.myReferences.add(refInfo);
                }
            } else if (tag == 7) {
                --ptr.offset;
                String className = this.readClassInfo(ptr);
                this.myReferences.add(new ReferenceInfo(this.getSymbolId(className)));
            }
            iterator.next();
        }
    }

    private MemberReferenceInfo readRefStructure(int tag, BytePointer ptr) throws ClsFormatException {
        int classInfoIndex = ClsUtil.readU2((BytePointer)ptr);
        int nameTypeInfoIndex = ClsUtil.readU2((BytePointer)ptr);
        ptr.offset = this.getOffsetInConstantPool(classInfoIndex);
        if (7 != ClsUtil.readU1((BytePointer)ptr)) {
            throw new ClsFormatException();
        }
        ptr.offset = this.getOffsetInConstantPool(ClsUtil.readU2((BytePointer)ptr));
        String className = ClsUtil.readUtf8Info((BytePointer)ptr, (int)47, (int)46);
        ptr.offset = this.getOffsetInConstantPool(nameTypeInfoIndex);
        if (12 != ClsUtil.readU1((BytePointer)ptr)) {
            throw new ClsFormatException();
        }
        int memberNameIndex = ClsUtil.readU2((BytePointer)ptr);
        int descriptorIndex = ClsUtil.readU2((BytePointer)ptr);
        ptr.offset = this.getOffsetInConstantPool(memberNameIndex);
        String memberName = ClsUtil.readUtf8Info((BytePointer)ptr);
        if (!(memberName.indexOf(36) < 0 && memberName.indexOf(60) < 0 || CONSTRUCTOR_NAME.equals(memberName))) {
            return null;
        }
        ptr.offset = this.getOffsetInConstantPool(descriptorIndex);
        String descriptor = ClsUtil.readUtf8Info((BytePointer)ptr);
        MemberInfo info = 9 == tag ? new FieldInfo(this.getSymbolId(memberName), this.getSymbolId(descriptor)) : new MethodInfo(this.getSymbolId(memberName), this.getSymbolId(descriptor), CONSTRUCTOR_NAME.equals(memberName));
        return new MemberReferenceInfo(this.getSymbolId(className), info);
    }

    public int getAccessFlags() {
        try {
            int offset = this.getConstantPoolEnd();
            byte[] data = this.getData();
            if (offset + 2 > data.length) {
                throw new ClsFormatException();
            }
            int b1 = data[offset++] & 0xFF;
            int b2 = data[offset++] & 0xFF;
            return (b1 << 8) + b2;
        }
        catch (ClsFormatException e) {
            return 0;
        }
    }

    private byte[] getData() {
        if (this.myData == null) {
            try {
                this.myData = FileUtil.loadFileBytes((File)this.myFile);
            }
            catch (IOException e) {
                this.myData = ArrayUtil.EMPTY_BYTE_ARRAY;
            }
        }
        return this.myData;
    }

    private int getOffsetInConstantPool(int index) throws ClsFormatException {
        this.initConstantPool();
        if (index < 1 || index >= this.myConstantPoolOffsets.length) {
            throw new ClsFormatException();
        }
        return this.myConstantPoolOffsets[index - 1];
    }

    private int getConstantPoolEnd() throws ClsFormatException {
        this.initConstantPool();
        return this.myConstantPoolOffsets[this.myConstantPoolOffsets.length - 1];
    }

    private void initConstantPool() throws ClsFormatException {
        if (this.myConstantPoolOffsets == null) {
            BytePointer ptr = new BytePointer(this.getData(), 0);
            ConstantPoolIterator iterator = new ConstantPoolIterator(ptr);
            this.myConstantPoolOffsets = new int[iterator.getEntryCount()];
            this.myConstantPoolOffsets[0] = iterator.getCurrentOffset();
            int index = 1;
            while (iterator.hasMoreEntries()) {
                int tag = ClsUtil.readU1((BytePointer)ptr);
                if (tag == 5 || tag == 6) {
                    this.myConstantPoolOffsets[index++] = ptr.offset + 8;
                }
                iterator.next();
                this.myConstantPoolOffsets[index++] = iterator.getCurrentOffset();
            }
        }
    }

    private String readClassInfo(BytePointer ptr) throws ClsFormatException {
        int tag = ClsUtil.readU1((BytePointer)ptr);
        if (tag != 7) {
            throw new ClsFormatException(CompilerBundle.message((String)"class.parsing.error.wrong.record.tag.expected.another", (Object[])new Object[]{tag, 7}));
        }
        int index = ClsUtil.readU2((BytePointer)ptr);
        return ClsUtil.readUtf8Info((BytePointer)new BytePointer(ptr.bytes, this.getOffsetInConstantPool(index)), (int)47, (int)46);
    }

    private ClsAttributeTable readAttributes(BytePointer ptr) throws ClsFormatException {
        int count = ClsUtil.readU2((BytePointer)ptr);
        ClsAttributeTable attributes = new ClsAttributeTable();
        while (count-- > 0) {
            String attrName = this.readAttributeName(ptr);
            if ("Exceptions".equals(attrName)) {
                attributes.exceptions = this.readExceptions(ptr);
            } else if ("Signature".equals(attrName)) {
                attributes.genericSignature = this.readSignatureAttribute(ptr);
            } else if ("SourceFile".equals(attrName)) {
                attributes.sourceFile = this.readSourceFileAttribute(ptr);
            } else if ("ConstantValue".equals(attrName)) {
                attributes.constantValue = this.readFieldConstantValue(ptr);
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                attributes.runtimeVisibleAnnotations = this.readAnnotations(ptr);
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                attributes.runtimeInvisibleAnnotations = this.readAnnotations(ptr);
            } else if ("RuntimeVisibleParameterAnnotations".equals(attrName)) {
                attributes.runtimeVisibleParameterAnnotations = this.readParameterAnnotations(ptr);
            } else if ("RuntimeInvisibleParameterAnnotations".equals(attrName)) {
                attributes.runtimeInvisibleParameterAnnotations = this.readParameterAnnotations(ptr);
            } else if ("AnnotationDefault".equals(attrName)) {
                attributes.annotationDefault = this.readAnnotationMemberValue(new BytePointer(ptr.bytes, ptr.offset + 6));
            }
            ClassFileReader.gotoNextAttribute(ptr);
        }
        return attributes;
    }

    private String readAttributeName(BytePointer p) throws ClsFormatException {
        BytePointer ptr = new BytePointer(p.bytes, p.offset);
        int nameIndex = ClsUtil.readU2((BytePointer)ptr);
        ptr.offset = this.getOffsetInConstantPool(nameIndex);
        return ClsUtil.readUtf8Info((BytePointer)ptr);
    }

    private static void gotoNextAttribute(BytePointer ptr) throws ClsFormatException {
        ptr.offset += 2;
        int length = ClsUtil.readU4((BytePointer)ptr);
        ptr.offset += length;
    }

    private String readSignatureAttribute(BytePointer p) throws ClsFormatException {
        BytePointer ptr = new BytePointer(p.bytes, p.offset + 2);
        if (ClsUtil.readU4((BytePointer)ptr) != 2) {
            return null;
        }
        ptr.offset = this.getOffsetInConstantPool(ClsUtil.readU2((BytePointer)ptr));
        return ClsUtil.readUtf8Info((BytePointer)ptr);
    }

    private String[] readExceptions(BytePointer p) throws ClsFormatException {
        BytePointer ptr = new BytePointer(p.bytes, p.offset + 6);
        int count = ClsUtil.readU2((BytePointer)ptr);
        ArrayList<String> array = new ArrayList<String>(count);
        while (count-- > 0) {
            int idx = ClsUtil.readU2((BytePointer)ptr);
            if (idx == 0) continue;
            String exceptionClass = this.readClassInfo(new BytePointer(ptr.bytes, this.getOffsetInConstantPool(idx)));
            array.add(exceptionClass);
        }
        return ArrayUtil.toStringArray(array);
    }

    private String readSourceFileAttribute(BytePointer p) throws ClsFormatException {
        BytePointer ptr = new BytePointer(p.bytes, p.offset + 2);
        if (ClsUtil.readU4((BytePointer)ptr) != 2) {
            return null;
        }
        ptr.offset = this.getOffsetInConstantPool(ClsUtil.readU2((BytePointer)ptr));
        String path = ClsUtil.readUtf8Info((BytePointer)ptr);
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex >= 0) {
            path = path.substring(slashIndex + 1, path.length());
        }
        return path;
    }

    private ConstantValue readFieldConstantValue(BytePointer p) throws ClsFormatException {
        BytePointer ptr = new BytePointer(p.bytes, p.offset + 2);
        if (ClsUtil.readU4((BytePointer)ptr) != 2) {
            throw new ClsFormatException();
        }
        int valueIndex = ClsUtil.readU2((BytePointer)ptr);
        ptr.offset = this.getOffsetInConstantPool(valueIndex);
        return this.readConstant(ptr);
    }

    private ConstantValue readConstant(BytePointer ptr) throws ClsFormatException {
        int tag = ClsUtil.readU1((BytePointer)ptr);
        switch (tag) {
            case 3: {
                int value = ClsUtil.readU4((BytePointer)ptr);
                return new IntegerConstantValue(value);
            }
            case 4: {
                float floatValue = ClsUtil.readFloat((BytePointer)ptr);
                return new FloatConstantValue(floatValue);
            }
            case 5: {
                int high = ClsUtil.readU4((BytePointer)ptr);
                int low = ClsUtil.readU4((BytePointer)ptr);
                long v = (long)high << 32 | (long)low & 0xFFFFFFFFL;
                return new LongConstantValue(v);
            }
            case 6: {
                double doubleValue = ClsUtil.readDouble((BytePointer)ptr);
                return new DoubleConstantValue(doubleValue);
            }
            case 8: {
                int stringIndex = ClsUtil.readU2((BytePointer)ptr);
                ptr.offset = this.getOffsetInConstantPool(stringIndex);
                return new StringConstantValue(ClsUtil.readUtf8Info((BytePointer)ptr));
            }
        }
        throw new ClsFormatException();
    }

    private AnnotationConstantValue[] readAnnotations(BytePointer p) throws ClsFormatException {
        BytePointer ptr = new BytePointer(p.bytes, p.offset + 6);
        return this.readAnnotationsArray(ptr);
    }

    private AnnotationConstantValue[][] readParameterAnnotations(BytePointer p) throws ClsFormatException {
        BytePointer ptr = new BytePointer(p.bytes, p.offset + 6);
        int numberOfParams = ClsUtil.readU1((BytePointer)ptr);
        if (numberOfParams == 0) {
            return null;
        }
        AnnotationConstantValue[][] annotations = new AnnotationConstantValue[numberOfParams][];
        for (int parameterIndex = 0; parameterIndex < numberOfParams; ++parameterIndex) {
            annotations[parameterIndex] = this.readAnnotationsArray(ptr);
        }
        return annotations;
    }

    private AnnotationConstantValue[] readAnnotationsArray(BytePointer ptr) throws ClsFormatException {
        int numberOfAnnotations = ClsUtil.readU2((BytePointer)ptr);
        if (numberOfAnnotations == 0) {
            return AnnotationConstantValue.EMPTY_ARRAY;
        }
        AnnotationConstantValue[] annotations = new AnnotationConstantValue[numberOfAnnotations];
        for (int attributeIndex = 0; attributeIndex < numberOfAnnotations; ++attributeIndex) {
            annotations[attributeIndex] = this.readAnnotation(ptr);
        }
        return annotations;
    }

    private AnnotationConstantValue readAnnotation(BytePointer ptr) throws ClsFormatException {
        int classInfoIndex = ClsUtil.readU2((BytePointer)ptr);
        String qName = this.readAnnotationClassName(new BytePointer(ptr.bytes, this.getOffsetInConstantPool(classInfoIndex)));
        ArrayList<AnnotationNameValuePair> memberValues = new ArrayList<AnnotationNameValuePair>();
        int numberOfPairs = ClsUtil.readU2((BytePointer)ptr);
        for (int idx = 0; idx < numberOfPairs; ++idx) {
            int memberNameIndex = ClsUtil.readU2((BytePointer)ptr);
            String memberName = ClsUtil.readUtf8Info((byte[])ptr.bytes, (int)this.getOffsetInConstantPool(memberNameIndex));
            ConstantValue memberValue = this.readAnnotationMemberValue(ptr);
            memberValues.add(new AnnotationNameValuePair(this.getSymbolId(memberName), memberValue));
        }
        return new AnnotationConstantValue(this.getSymbolId(qName), memberValues.toArray(new AnnotationNameValuePair[memberValues.size()]));
    }

    private String readAnnotationClassName(BytePointer ptr) throws ClsFormatException {
        int tag = ClsUtil.readU1((BytePointer)ptr);
        if (tag == 1) {
            return ClsUtil.getTypeText((byte[])ptr.bytes, (int)(ptr.offset + 2));
        }
        if (tag == 7) {
            --ptr.offset;
            return this.readClassInfo(ptr);
        }
        throw new ClsFormatException(CompilerBundle.message((String)"class.parsing.error.wrong.record.tag.expected.another", (Object[])new Object[]{tag, "CONSTANT_Utf8(1) / CONSTANT_Class(7)"}));
    }

    private ConstantValue readAnnotationMemberValue(BytePointer ptr) throws ClsFormatException {
        char tag = (char)ClsUtil.readU1((BytePointer)ptr);
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                int valueIndex = ClsUtil.readU2((BytePointer)ptr);
                return new AnnotationPrimitiveConstantValue(tag, this.readConstant(new BytePointer(ptr.bytes, this.getOffsetInConstantPool(valueIndex))));
            }
            case 's': {
                int valueIndex = ClsUtil.readU2((BytePointer)ptr);
                return new StringConstantValue(ClsUtil.readUtf8Info((byte[])ptr.bytes, (int)this.getOffsetInConstantPool(valueIndex)));
            }
            case 'e': {
                int typeNameIndex = ClsUtil.readU2((BytePointer)ptr);
                int constantNameIndex = ClsUtil.readU2((BytePointer)ptr);
                String typeName = ClsUtil.readUtf8Info((byte[])ptr.bytes, (int)this.getOffsetInConstantPool(typeNameIndex));
                String constantName = ClsUtil.readUtf8Info((byte[])ptr.bytes, (int)this.getOffsetInConstantPool(constantNameIndex));
                return new EnumConstantValue(this.getSymbolId(typeName), this.getSymbolId(constantName));
            }
            case 'c': {
                int classInfoIndex = ClsUtil.readU2((BytePointer)ptr);
                BytePointer p = new BytePointer(ptr.bytes, this.getOffsetInConstantPool(classInfoIndex));
                int recordTag = ClsUtil.readU1((BytePointer)p);
                if (recordTag != 1) {
                    throw new ClsFormatException(CompilerBundle.message((String)"class.parsing.error.wrong.record.tag.expected.another", (Object[])new Object[]{recordTag, 1}));
                }
                p.offset += 2;
                String className = ClsUtil.getTypeText((byte[])p.bytes, (int)p.offset);
                return new ClassInfoConstantValue(this.getSymbolId(className));
            }
            case '@': {
                return this.readAnnotation(ptr);
            }
            case '[': {
                int numberOfValues = ClsUtil.readU2((BytePointer)ptr);
                ConstantValue[] values = new ConstantValue[numberOfValues];
                for (int idx = 0; idx < numberOfValues; ++idx) {
                    values[idx] = this.readAnnotationMemberValue(ptr);
                }
                return new ConstantValueArray(values);
            }
        }
        throw new ClsFormatException(CompilerBundle.message((String)"class.parsing.error.wrong.tag.annotation.member.value", (Object[])new Object[]{Character.valueOf(tag)}));
    }

    private static class ConstantPoolIterator {
        private final BytePointer myPtr;
        private final int myEntryCount;
        private int myCurrentEntryIndex;
        private int myCurrentOffset;

        public ConstantPoolIterator(BytePointer ptr) throws ClsFormatException {
            this.myPtr = ptr;
            this.myPtr.offset = 0;
            int magic = ClsUtil.readU4((BytePointer)this.myPtr);
            if (magic != -889275714) {
                throw new ClsFormatException();
            }
            this.myPtr.offset += 2;
            this.myPtr.offset += 2;
            this.myEntryCount = ClsUtil.readU2((BytePointer)this.myPtr);
            if (this.myEntryCount < 1) {
                throw new ClsFormatException();
            }
            this.myCurrentEntryIndex = 1;
            this.myCurrentOffset = this.myPtr.offset;
        }

        public int getEntryCount() {
            return this.myEntryCount;
        }

        public int getCurrentOffset() {
            return this.myCurrentOffset;
        }

        public boolean hasMoreEntries() {
            return this.myCurrentEntryIndex < this.myEntryCount;
        }

        public void next() throws ClsFormatException {
            this.myPtr.offset = this.myCurrentOffset;
            int tag = ClsUtil.readU1((BytePointer)this.myPtr);
            switch (tag) {
                default: {
                    throw new ClsFormatException();
                }
                case 7: 
                case 8: {
                    this.myPtr.offset += 2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.myPtr.offset += 4;
                    break;
                }
                case 5: 
                case 6: {
                    this.myPtr.offset += 8;
                    ++this.myCurrentEntryIndex;
                    break;
                }
                case 1: {
                    int length = ClsUtil.readU2((BytePointer)this.myPtr);
                    this.myPtr.offset += length;
                }
            }
            ++this.myCurrentEntryIndex;
            this.myCurrentOffset = this.myPtr.offset;
        }
    }

    private static class ClsAttributeTable {
        public String[] exceptions;
        public String genericSignature;
        public String sourceFile;
        public ConstantValue constantValue;
        public AnnotationConstantValue[] runtimeVisibleAnnotations;
        public AnnotationConstantValue[] runtimeInvisibleAnnotations;
        public AnnotationConstantValue[][] runtimeVisibleParameterAnnotations;
        public AnnotationConstantValue[][] runtimeInvisibleParameterAnnotations;
        public ConstantValue annotationDefault;

        private ClsAttributeTable() {
        }
    }
}

