/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationOptionsImpl;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.LibraryDefinitionsGeneratorFactory;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PathElement;
import com.intellij.compiler.ant.taskdefs.PathRef;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ModuleChunkClasspath
extends Path {
    public ModuleChunkClasspath(final ModuleChunk chunk, final GenerationOptions genOptions, final boolean generateRuntimeClasspath, final boolean generateTestClasspath) {
        super(ModuleChunkClasspath.generateClasspathName(chunk, generateRuntimeClasspath, generateTestClasspath));
        final OrderedSet pathItems = new OrderedSet(TObjectHashingStrategy.CANONICAL);
        final String moduleChunkBasedirProperty = BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)chunk);
        Module[] modules = chunk.getModules();
        final HashSet processedChunks = new HashSet();
        final HashSet processedModules = new HashSet();
        for (Module module : modules) {
            new Object(){

                /*
                 * Enabled aggressive block sorting
                 */
                public void processModule(Module module, int dependencyLevel, boolean isModuleExported) {
                    if (processedModules.contains(module)) {
                        return;
                    }
                    if (!(dependencyLevel <= 1 || isModuleExported || genOptions.inlineRuntimeClasspath && generateRuntimeClasspath)) {
                        return;
                    }
                    processedModules.add(module);
                    ProjectEx project = (ProjectEx)chunk.getProject();
                    File baseDir = BuildProperties.getProjectBaseDir((Project)project);
                    OrderEntry[] arr$ = ModuleRootManager.getInstance((Module)module).getOrderEntries();
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        block30: {
                            OrderEntry orderEntry;
                            block32: {
                                boolean isExported;
                                block33: {
                                    block31: {
                                        if (i$ >= len$) {
                                            return;
                                        }
                                        orderEntry = arr$[i$];
                                        if (!orderEntry.isValid()) break block30;
                                        if (!(orderEntry instanceof ExportableOrderEntry)) break block31;
                                        ExportableOrderEntry e = (ExportableOrderEntry)orderEntry;
                                        switch (e.getScope()) {
                                            case COMPILE: {
                                                break;
                                            }
                                            case PROVIDED: {
                                                if (!generateRuntimeClasspath || generateTestClasspath) break;
                                                break block30;
                                            }
                                            case RUNTIME: {
                                                if (generateRuntimeClasspath) break;
                                                break block30;
                                            }
                                            case TEST: {
                                                if (!generateTestClasspath) break block30;
                                            }
                                        }
                                    }
                                    if (generateRuntimeClasspath) break block32;
                                    if (!(orderEntry instanceof ModuleSourceOrderEntry)) break block33;
                                    if (generateTestClasspath || dependencyLevel != 0 && !chunk.contains(module)) break block32;
                                    break block30;
                                }
                                boolean bl = isExported = orderEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)orderEntry).isExported();
                                if (dependencyLevel > 0 && !isExported && !(orderEntry instanceof ModuleOrderEntry)) break block30;
                            }
                            if (orderEntry instanceof JdkOrderEntry) {
                                if (genOptions.forceTargetJdk && !generateRuntimeClasspath) {
                                    pathItems.add((Object)new PathRefItem(BuildProperties.propertyRef((String)BuildProperties.getModuleChunkJdkClasspathProperty((String)chunk.getName()))));
                                }
                            } else if (orderEntry instanceof ModuleOrderEntry) {
                                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                                Module dependentModule = moduleOrderEntry.getModule();
                                if (!chunk.contains(dependentModule)) {
                                    if (generateRuntimeClasspath && !genOptions.inlineRuntimeClasspath) {
                                        ModuleChunk depChunk = genOptions.getChunkByModule(dependentModule);
                                        if (!processedChunks.contains(depChunk)) {
                                            processedChunks.add(depChunk);
                                            String property = generateTestClasspath ? BuildProperties.getTestRuntimeClasspathProperty((String)depChunk.getName()) : BuildProperties.getRuntimeClasspathProperty((String)depChunk.getName());
                                            pathItems.add((Object)new PathRefItem(property));
                                        }
                                    } else {
                                        this.processModule(dependentModule, dependencyLevel + 1, moduleOrderEntry.isExported());
                                    }
                                }
                            } else if (orderEntry instanceof LibraryOrderEntry) {
                                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                                String libraryName = libraryOrderEntry.getLibraryName();
                                if (((LibraryOrderEntry)orderEntry).isModuleLevel()) {
                                    CompositeGenerator gen = new CompositeGenerator();
                                    gen.setHasLeadingNewline(false);
                                    LibraryDefinitionsGeneratorFactory.genLibraryContent(project, genOptions, libraryOrderEntry.getLibrary(), baseDir, gen);
                                    pathItems.add((Object)new GeneratorItem(libraryName, (Generator)gen));
                                } else {
                                    pathItems.add((Object)new PathRefItem(BuildProperties.getLibraryPathId((String)libraryName)));
                                }
                            } else if (!(orderEntry instanceof ModuleSourceOrderEntry)) {
                                pathItems.add((Object)new GeneratorItem(orderEntry.getClass().getName(), new Comment("Unknown OrderEntryType: " + orderEntry.getClass().getName())));
                            } else {
                                for (String url : ModuleChunkClasspath.getCompilationClasses(orderEntry, (GenerationOptionsImpl)genOptions, generateRuntimeClasspath, generateTestClasspath, dependencyLevel == 0)) {
                                    String propertyRef;
                                    if (url.endsWith("!/")) {
                                        url = url.substring(0, url.length() - "!/".length());
                                    }
                                    if ((propertyRef = genOptions.getPropertyRefForUrl(url)) != null) {
                                        pathItems.add((Object)new PathElementItem(propertyRef));
                                        continue;
                                    }
                                    String path = VirtualFileManager.extractPath((String)url);
                                    pathItems.add((Object)new PathElementItem(GenerationUtils.toRelativePath((String)path, (File)chunk.getBaseDir(), (String)moduleChunkBasedirProperty, (GenerationOptions)genOptions)));
                                }
                            }
                        }
                        ++i$;
                    }
                }
            }.processModule(module, 0, false);
        }
        for (ClasspathItem pathItem : pathItems) {
            this.add(pathItem.toGenerator());
        }
    }

    private static String generateClasspathName(ModuleChunk chunk, boolean generateRuntimeClasspath, boolean generateTestClasspath) {
        if (generateTestClasspath) {
            return generateRuntimeClasspath ? BuildProperties.getTestRuntimeClasspathProperty((String)chunk.getName()) : BuildProperties.getTestClasspathProperty((String)chunk.getName());
        }
        return generateRuntimeClasspath ? BuildProperties.getRuntimeClasspathProperty((String)chunk.getName()) : BuildProperties.getClasspathProperty((String)chunk.getName());
    }

    private static String[] getCompilationClasses(OrderEntry orderEntry, GenerationOptionsImpl options, boolean forRuntime, boolean forTest, boolean firstLevel) {
        if (!forRuntime) {
            if (forTest) {
                return orderEntry.getUrls(firstLevel ? OrderRootType.PRODUCTION_COMPILATION_CLASSES : OrderRootType.COMPILATION_CLASSES);
            }
            return firstLevel ? new String[]{} : orderEntry.getUrls(OrderRootType.PRODUCTION_COMPILATION_CLASSES);
        }
        Set<String> jdkUrls = options.getAllJdkUrls();
        OrderedSet urls = new OrderedSet();
        urls.addAll(Arrays.asList(orderEntry.getUrls(forTest ? OrderRootType.COMPILATION_CLASSES : OrderRootType.PRODUCTION_COMPILATION_CLASSES)));
        urls.removeAll(jdkUrls);
        return ArrayUtil.toStringArray((Collection)urls);
    }

    private static class PathRefItem
    extends ClasspathItem {
        public PathRefItem(String value) {
            super(value);
        }

        @Override
        public Generator toGenerator() {
            return new PathRef(this.myValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathRefItem)) {
                return false;
            }
            PathRefItem pathRefItem = (PathRefItem)o;
            return this.myValue.equals(pathRefItem.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }
    }

    private static class PathElementItem
    extends ClasspathItem {
        public PathElementItem(String value) {
            super(value);
        }

        @Override
        public Generator toGenerator() {
            return new PathElement(this.myValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathElementItem)) {
                return false;
            }
            PathElementItem pathElementItem = (PathElementItem)o;
            return this.myValue.equals(pathElementItem.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }
    }

    private static class GeneratorItem
    extends ClasspathItem {
        final Generator myGenerator;

        public GeneratorItem(String value, Generator generator) {
            super(value);
            this.myGenerator = generator;
        }

        @Override
        public Generator toGenerator() {
            return this.myGenerator;
        }
    }

    private static abstract class ClasspathItem {
        protected final String myValue;

        public ClasspathItem(String value) {
            this.myValue = value;
        }

        public abstract Generator toGenerator();
    }
}

