/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.Nullable;

public final class CompilerMessageImpl
implements CompilerMessage {
    private final Project myProject;
    private final CompilerMessageCategory myCategory;
    @Nullable
    private Navigatable myNavigatable;
    private final String myMessage;
    private VirtualFile myFile;
    private final int myRow;
    private final int myColumn;

    public CompilerMessageImpl(Project project, CompilerMessageCategory category, String message, final String url, int row, int column, @Nullable Navigatable navigatable) {
        this.myProject = project;
        this.myCategory = category;
        this.myNavigatable = navigatable;
        this.myMessage = message == null ? "" : message;
        this.myRow = row;
        this.myColumn = column;
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                CompilerMessageImpl.this.myFile = url == null ? null : VirtualFileManager.getInstance().findFileByUrl(url);
            }
        });
    }

    public CompilerMessageCategory getCategory() {
        return this.myCategory;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Navigatable getNavigatable() {
        int line;
        if (this.myNavigatable != null) {
            return this.myNavigatable;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile != null && virtualFile.isValid() && (line = this.getLine() - 1) >= 0) {
            this.myNavigatable = new OpenFileDescriptor(this.myProject, virtualFile, line, Math.max(0, this.getColumn() - 1));
            return this.myNavigatable;
        }
        return null;
    }

    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public String getExportTextPrefix() {
        if (this.getLine() >= 0) {
            return CompilerBundle.message((String)"compiler.results.export.text.prefix", (Object[])new Object[]{this.getLine()});
        }
        return "";
    }

    public String getRenderTextPrefix() {
        if (this.getLine() >= 0) {
            return "(" + this.getLine() + ", " + this.getColumn() + ")";
        }
        return "";
    }

    public int getLine() {
        return this.myRow;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompilerMessage)) {
            return false;
        }
        CompilerMessageImpl compilerMessage = (CompilerMessageImpl)o;
        if (this.myColumn != compilerMessage.myColumn) {
            return false;
        }
        if (this.myRow != compilerMessage.myRow) {
            return false;
        }
        if (!this.myCategory.equals((Object)compilerMessage.myCategory)) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(compilerMessage.myFile) : compilerMessage.myFile != null) {
            return false;
        }
        return this.myMessage.equals(compilerMessage.myMessage);
    }

    public int hashCode() {
        int result = this.myCategory.hashCode();
        result = 29 * result + this.myMessage.hashCode();
        result = 29 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 29 * result + this.myRow;
        result = 29 * result + this.myColumn;
        return result;
    }

    public String toString() {
        return this.myMessage;
    }
}

