/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MoveToPackageFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrongPackageStatementInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspection.checkFile must not be null");
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (file instanceof PsiJavaFile) {
            if (JspPsiUtil.isInJspFile((PsiElement)file)) {
                return null;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            PsiClass[] classes = javaFile.getClasses();
            if (classes.length == 0) {
                return null;
            }
            PsiDirectory directory = javaFile.getContainingDirectory();
            if (directory == null) {
                return null;
            }
            PsiPackage dirPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (dirPackage == null) {
                return null;
            }
            PsiPackageStatement packageStatement = javaFile.getPackageStatement();
            String packageName = dirPackage.getQualifiedName();
            if (!Comparing.strEqual((String)packageName, (String)"", (boolean)true) && packageStatement == null) {
                String description = JavaErrorMessages.message("missing.package.statement", packageName);
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)classes[0].getNameIdentifier(), description, (LocalQuickFix)new AdjustPackageNameFix(javaFile, null, dirPackage), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
            }
            if (packageStatement != null) {
                PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
                PsiPackage classPackage = (PsiPackage)packageReference.resolve();
                ArrayList<Object> availableFixes = new ArrayList<Object>();
                if (classPackage == null) {
                    availableFixes.add(new AdjustPackageNameFix(javaFile, packageStatement, dirPackage));
                } else if (!Comparing.equal((String)dirPackage.getQualifiedName(), (String)packageReference.getText(), (boolean)true)) {
                    availableFixes.add(new AdjustPackageNameFix(javaFile, packageStatement, dirPackage));
                    MoveToPackageFix moveToPackageFix = new MoveToPackageFix(file, classPackage);
                    if (moveToPackageFix.isAvailable()) {
                        availableFixes.add(moveToPackageFix);
                    }
                }
                if (!availableFixes.isEmpty()) {
                    String description = JavaErrorMessages.message("package.name.file.path.mismatch", packageReference.getText(), dirPackage.getQualifiedName());
                    return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)packageStatement, description, isOnTheFly, availableFixes.toArray(new LocalQuickFix[availableFixes.size()]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
                }
            }
        }
        return null;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspection.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"wrong.package.statement", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("WrongPackageStatement" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspection.getShortName must not return null");
        }
        return "WrongPackageStatement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

