/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ui.ReorderableListController;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public class SpecialAnnotationsUtil {
    public static JPanel createSpecialAnnotationsListControl(final List<String> list, String borderTitle) {
        final SortedListModel listModel = new SortedListModel((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        JList injectionList = new JList(listModel);
        for (String s : list) {
            listModel.add((Object)s);
        }
        injectionList.setSelectionMode(1);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ReorderableListController controller = ReorderableListController.create(injectionList, (DefaultActionGroup)actionGroup);
        controller.addAddAction(InspectionsBundle.message((String)"special.annotations.list.add.annotation.class", (Object[])new Object[0]), (Factory)new Factory<String>(){

            public String create() {
                return Messages.showInputDialog((String)InspectionsBundle.message((String)"special.annotations.list.annotation.class", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"special.annotations.list.add.annotation.class", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            }
        }, true);
        controller.addRemoveAction(InspectionsBundle.message((String)"special.annotations.list.remove.annotation.class", (Object[])new Object[0]));
        injectionList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.listChanged();
            }

            private void listChanged() {
                list.clear();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    list.add((String)listModel.getElementAt(i));
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.listChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.listChanged();
            }
        });
        JScrollPane listScrollPane = ScrollPaneFactory.createScrollPane(injectionList);
        listScrollPane.setVerticalScrollBarPolicy(20);
        listScrollPane.setHorizontalScrollBarPolicy(30);
        FontMetrics fontMetrics = injectionList.getFontMetrics(injectionList.getFont());
        listScrollPane.setPreferredSize(new Dimension(0, fontMetrics.getHeight() * 5));
        listScrollPane.setMinimumSize(new Dimension(0, fontMetrics.getHeight() * 3));
        JPanel listPanel = new JPanel(new BorderLayout());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        listPanel.add((Component)actionToolbar.getComponent(), "North");
        listPanel.add((Component)listScrollPane, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)borderTitle, null), "North");
        panel.add((Component)listPanel, "Center");
        return panel;
    }

    public static IntentionAction createAddToSpecialAnnotationsListIntentionAction(final String text, final String family, final List<String> targetList, final String qualifiedName) {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = text;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/util/SpecialAnnotationsUtil$4.getText must not return null");
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = family;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/util/SpecialAnnotationsUtil$4.getFamilyName must not return null");
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/util/SpecialAnnotationsUtil$4.isAvailable must not be null");
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/util/SpecialAnnotationsUtil$4.invoke must not be null");
                }
                SpecialAnnotationsUtil.doQuickFixInternal(project, targetList, qualifiedName);
            }

            public boolean startInWriteAction() {
                return true;
            }
        };
    }

    public static LocalQuickFix createAddToSpecialAnnotationsListQuickFix(final String text, final String family, final List<String> targetList, final String qualifiedName, PsiElement context) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = text;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/util/SpecialAnnotationsUtil$5.getName must not return null");
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = family;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/util/SpecialAnnotationsUtil$5.getFamilyName must not return null");
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/util/SpecialAnnotationsUtil$5.applyFix must not be null");
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/util/SpecialAnnotationsUtil$5.applyFix must not be null");
                }
                SpecialAnnotationsUtil.doQuickFixInternal(project, targetList, qualifiedName);
            }
        };
    }

    private static void doQuickFixInternal(Project project, List<String> targetList, String qualifiedName) {
        targetList.add(qualifiedName);
        Collections.sort(targetList);
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        ((InspectionProfileImpl)inspectionProfile).isProperSetting(HighlightDisplayKey.find((String)"UNUSED_SYMBOL"));
        InspectionProfileManager.getInstance().fireProfileChanged((Profile)inspectionProfile);
    }

    public static void createAddToSpecialAnnotationFixes(PsiModifierListOwner owner, Processor<String> processor) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            PsiAnnotation psiAnnotation;
            String name;
            PsiAnnotation[] psiAnnotations;
            PsiAnnotation[] arr$ = psiAnnotations = modifierList.getAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((name = (psiAnnotation = arr$[i$]).getQualifiedName()) == null || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.jetbrains.") || processor.process((Object)name)); ++i$) {
            }
        }
    }
}

