/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedParameters;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionTool;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.HTMLJavaHTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedParametersInspection
extends GlobalJavaInspectionTool {
    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isSyntheticJSP()) {
                return null;
            }
            if (refMethod.isExternalOverride()) {
                return null;
            }
            if (!refMethod.isStatic() && !refMethod.isConstructor() && refMethod.getSuperMethods().size() > 0) {
                return null;
            }
            if ((refMethod.isAbstract() || refMethod.getOwnerClass().isInterface()) && refMethod.getDerivedMethods().isEmpty()) {
                return null;
            }
            if (RefUtil.isEntryPoint((RefElement)refMethod)) {
                return null;
            }
            ArrayList<RefParameter> unusedParameters = UnusedParametersInspection.getUnusedParameters(refMethod);
            if (unusedParameters.size() == 0) {
                return null;
            }
            ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
            for (RefParameter refParameter : unusedParameters) {
                PsiIdentifier psiIdentifier = refParameter.getElement().getNameIdentifier();
                if (psiIdentifier == null) continue;
                result.add(manager.createProblemDescriptor((PsiElement)psiIdentifier, refMethod.isAbstract() ? InspectionsBundle.message((String)"inspection.unused.parameter.composer", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.unused.parameter.composer1", (Object[])new Object[0]), (LocalQuickFix)new AcceptSuggested(globalContext.getRefManager(), processor, refParameter.toString()), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
            }
            return result.toArray(new CommonProblemDescriptor[result.size()]);
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(RefManager manager, GlobalJavaInspectionContext globalContext, final ProblemDescriptionsProcessor processor) {
        Project project = manager.getProject();
        for (RefElement entryPoint : globalContext.getEntryPointsManager(manager).getEntryPoints()) {
            processor.ignoreElement((RefEntity)entryPoint);
        }
        final PsiSearchHelper helper = PsiManager.getInstance((Project)project).getSearchHelper();
        final AnalysisScope scope = manager.getScope();
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                RefMethod refMethod;
                PsiModifierListOwner element;
                if (refEntity instanceof RefMethod && (element = (refMethod = (RefMethod)refEntity).getElement()) instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)element;
                    if (!(refMethod.isStatic() || refMethod.isConstructor() || "private".equals(refMethod.getAccessModifier()))) {
                        ArrayList<RefParameter> unusedParameters = UnusedParametersInspection.getUnusedParameters(refMethod);
                        if (unusedParameters.isEmpty()) {
                            return;
                        }
                        PsiMethod[] derived = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)psiMethod, (SearchScope)psiMethod.getUseScope(), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                        for (final RefParameter refParameter : unusedParameters) {
                            if (refMethod.isAbstract() && derived.length == 0) {
                                refParameter.parameterReferenced(false);
                                processor.ignoreElement((RefEntity)refParameter);
                                continue;
                            }
                            int idx = refParameter.getIndex();
                            final boolean[] found = new boolean[]{false};
                            for (int i = 0; i < derived.length && !found[0]; ++i) {
                                if (scope.contains((PsiElement)derived[i])) continue;
                                PsiParameter psiParameter = derived[i].getParameterList().getParameters()[idx];
                                ReferencesSearch.search((PsiElement)psiParameter, (SearchScope)helper.getUseScope((PsiElement)psiParameter), (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(new PsiReferenceProcessor(){

                                    public boolean execute(PsiReference element) {
                                        refParameter.parameterReferenced(false);
                                        processor.ignoreElement((RefEntity)refParameter);
                                        found[0] = true;
                                        return false;
                                    }
                                }));
                            }
                        }
                    }
                }
            }
        });
        return false;
    }

    @Nullable
    public String getHint(QuickFix fix) {
        return ((AcceptSuggested)fix).getHint();
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new AcceptSuggested(null, null, hint);
    }

    public void compose(StringBuffer buf, RefEntity refEntity, HTMLComposer composer) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            HTMLJavaHTMLComposer javaComposer = (HTMLJavaHTMLComposer)composer.getExtension(HTMLJavaHTMLComposer.COMPOSER);
            javaComposer.appendDerivedMethods(buf, refMethod);
            javaComposer.appendSuperMethods(buf, refMethod);
        }
    }

    public static ArrayList<RefParameter> getUnusedParameters(RefMethod refMethod) {
        boolean checkDeep = !refMethod.isStatic() && !refMethod.isConstructor();
        ArrayList<RefParameter> res = new ArrayList<RefParameter>();
        RefParameter[] methodParameters = refMethod.getParameters();
        RefParameter[] result = new RefParameter[methodParameters.length];
        System.arraycopy(methodParameters, 0, result, 0, methodParameters.length);
        UnusedParametersInspection.clearUsedParameters(refMethod, result, checkDeep);
        for (RefParameter parameter : result) {
            if (parameter == null) continue;
            res.add(parameter);
        }
        return res;
    }

    private static void clearUsedParameters(@NotNull RefMethod refMethod, RefParameter[] params, boolean checkDeep) {
        if (refMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/unusedParameters/UnusedParametersInspection.clearUsedParameters must not be null");
        }
        RefParameter[] methodParms = refMethod.getParameters();
        for (int i = 0; i < methodParms.length; ++i) {
            if (!methodParms[i].isUsedForReading()) continue;
            params[i] = null;
        }
        if (checkDeep) {
            for (RefMethod refOverride : refMethod.getDerivedMethods()) {
                UnusedParametersInspection.clearUsedParameters(refOverride, params, checkDeep);
            }
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.unused.parameter.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedParameters/UnusedParametersInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedParameters/UnusedParametersInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnusedParameters" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedParameters/UnusedParametersInspection.getShortName must not return null");
        }
        return "UnusedParameters";
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private final RefManager myManager;
        private final String myHint;
        private final ProblemDescriptionsProcessor myProcessor;

        public AcceptSuggested(RefManager manager, ProblemDescriptionsProcessor processor, String hint) {
            this.myManager = manager;
            this.myProcessor = processor;
            this.myHint = hint;
        }

        public String getHint() {
            return this.myHint;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.unused.parameter.delete.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedParameters/UnusedParametersInspection$AcceptSuggested.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedParameters/UnusedParametersInspection$AcceptSuggested.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RefElement refMethod;
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/unusedParameters/UnusedParametersInspection$AcceptSuggested.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/unusedParameters/UnusedParametersInspection$AcceptSuggested.applyFix must not be null");
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{PsiUtilBase.getVirtualFile((PsiElement)descriptor.getPsiElement())}).hasReadonlyFiles()) {
                return;
            }
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
            if (psiMethod != null && (refMethod = this.myManager.getReference((PsiElement)psiMethod)) != null) {
                ArrayList<PsiElement> psiParameters = new ArrayList<PsiElement>();
                if (this.myManager != null) {
                    for (RefParameter refParameter : UnusedParametersInspection.getUnusedParameters((RefMethod)refMethod)) {
                        psiParameters.add((PsiElement)refParameter.getElement());
                    }
                } else {
                    PsiParameter[] parameters;
                    for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
                        if (!Comparing.strEqual((String)parameter.getName(), (String)this.myHint)) continue;
                        psiParameters.add((PsiElement)parameter);
                        break;
                    }
                }
                PsiModificationTracker tracker = psiMethod.getManager().getModificationTracker();
                long startModificationCount = tracker.getModificationCount();
                AcceptSuggested.removeUnusedParameterViaChangeSignature(psiMethod, psiParameters);
                if (this.myManager != null && startModificationCount != tracker.getModificationCount()) {
                    this.myProcessor.ignoreElement((RefEntity)refMethod);
                }
            }
        }

        private static void removeUnusedParameterViaChangeSignature(PsiMethod psiMethod, Collection<PsiElement> parametersToDelete) {
            ArrayList<ParameterInfoImpl> newParameters = new ArrayList<ParameterInfoImpl>();
            PsiParameter[] oldParameters = psiMethod.getParameterList().getParameters();
            for (int i = 0; i < oldParameters.length; ++i) {
                PsiParameter oldParameter = oldParameters[i];
                if (parametersToDelete.contains(oldParameter)) continue;
                newParameters.add(new ParameterInfoImpl(i, oldParameter.getName(), oldParameter.getType()));
            }
            ParameterInfoImpl[] parameterInfos = newParameters.toArray(new ParameterInfoImpl[newParameters.size()]);
            ChangeSignatureProcessor csp = new ChangeSignatureProcessor(psiMethod.getProject(), psiMethod, false, null, psiMethod.getName(), psiMethod.getReturnType(), parameterInfos);
            csp.run();
        }
    }
}

