/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NullableStuffInspection
extends BaseLocalInspectionTool {
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    private static final AnnotateMethodFix ANNOTATE_OVERRIDDEN_METHODS_FIX = new AnnotateMethodFix("org.jetbrains.annotations.NotNull", new String[]{"org.jetbrains.annotations.Nullable"}){

        @Override
        protected boolean annotateOverriddenMethods() {
            return true;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"annotate.overridden.methods.as.notnull", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/nullable/NullableStuffInspection$1.getName must not return null");
            }
            return string;
        }
    };
    private static final AnnotateOverriddenMethodParameterFix ANNOTATE_OVERRIDDEN_METHODS_PARAMS_FIX = new AnnotateOverriddenMethodParameterFix("org.jetbrains.annotations.NotNull", "org.jetbrains.annotations.Nullable");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/nullable/NullableStuffInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitMethod(PsiMethod method) {
                if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)method)) {
                    return;
                }
                NullableStuffInspection.this.checkNullableStuffForMethod(method, holder);
            }

            public void visitField(PsiField field) {
                if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)field)) {
                    return;
                }
                Annotated annotated = NullableStuffInspection.check((PsiModifierListOwner)field, holder, field.getType());
                if (annotated.isDeclaredNotNull || annotated.isDeclaredNullable) {
                    PsiMethod setter;
                    PsiMethod getter;
                    String anno = annotated.isDeclaredNotNull ? "org.jetbrains.annotations.NotNull" : "org.jetbrains.annotations.Nullable";
                    String annoToRemove = annotated.isDeclaredNotNull ? "org.jetbrains.annotations.Nullable" : "org.jetbrains.annotations.NotNull";
                    String simpleName = annotated.isDeclaredNotNull ? "NotNull" : "Nullable";
                    String propName = JavaCodeStyleManager.getInstance((Project)field.getProject()).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
                    boolean isStatic = field.hasModifierProperty("static");
                    if (NullableStuffInspection.this.REPORT_NOT_ANNOTATED_GETTER && (getter = PropertyUtil.findPropertyGetter((PsiClass)field.getContainingClass(), (String)propName, (boolean)isStatic, (boolean)false)) != null && !AnnotationUtil.isAnnotated((PsiModifierListOwner)getter, (Collection)AnnotationUtil.ALL_ANNOTATIONS) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)getter.getReturnType())) {
                        holder.registerProblem((PsiElement)getter.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.not.annotated", (Object[])new Object[]{simpleName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AnnotateMethodFix(anno, annoToRemove)});
                    }
                    if (NullableStuffInspection.this.REPORT_NOT_ANNOTATED_SETTER_PARAMETER && (setter = PropertyUtil.findPropertySetter((PsiClass)field.getContainingClass(), (String)propName, (boolean)isStatic, (boolean)false)) != null) {
                        PsiParameter[] parameters = setter.getParameterList().getParameters();
                        assert (parameters.length == 1);
                        PsiParameter parameter = parameters[0];
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (Collection)AnnotationUtil.ALL_ANNOTATIONS) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType())) {
                            holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", (Object[])new Object[]{simpleName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddAnnotationFix(anno, (PsiModifierListOwner)parameter, new String[]{annoToRemove})});
                        }
                    }
                }
            }

            public void visitParameter(PsiParameter parameter) {
                if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)parameter)) {
                    return;
                }
                NullableStuffInspection.check((PsiModifierListOwner)parameter, holder, parameter.getType());
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/nullable/NullableStuffInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private static Annotated check(PsiModifierListOwner parameter, ProblemsHolder holder, PsiType type) {
        PsiAnnotation isDeclaredNotNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (String[])new String[]{"org.jetbrains.annotations.NotNull"});
        PsiAnnotation isDeclaredNullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (String[])new String[]{"org.jetbrains.annotations.Nullable"});
        if (isDeclaredNullable != null && isDeclaredNotNull != null) {
            NullableStuffInspection.reportNullableNotNullConflict(holder, parameter, isDeclaredNullable, isDeclaredNotNull);
        }
        if ((isDeclaredNotNull != null || isDeclaredNullable != null) && type != null && TypeConversionUtil.isPrimitive((String)type.getCanonicalText())) {
            PsiAnnotation annotation = isDeclaredNotNull == null ? isDeclaredNullable : isDeclaredNotNull;
            NullableStuffInspection.reportPrimitiveType(holder, (PsiElement)annotation, annotation, parameter);
        }
        return new Annotated(isDeclaredNotNull != null, isDeclaredNullable != null);
    }

    private static void reportPrimitiveType(ProblemsHolder holder, PsiElement psiElement, PsiAnnotation annotation, PsiModifierListOwner listOwner) {
        holder.registerProblem(psiElement.isPhysical() ? psiElement : listOwner.getNavigationElement(), InspectionsBundle.message((String)"inspection.nullable.problems.primitive.type.annotation", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, listOwner)});
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.nullable.problems.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/nullable/NullableStuffInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/nullable/NullableStuffInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("NullableProblems" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/nullable/NullableStuffInspection.getShortName must not return null");
        }
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method, ProblemsHolder holder) {
        Annotated annotated = NullableStuffInspection.check((PsiModifierListOwner)method, holder, method.getReturnType());
        PsiParameter[] parameters = method.getParameterList().getParameters();
        List superMethodSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
        boolean reported_not_annotated_method_overrides_notnull = false;
        boolean reported_nullable_method_overrides_notnull = false;
        boolean[] reported_notnull_parameter_overrides_nullable = new boolean[parameters.length];
        boolean[] reported_not_annotated_parameter_overrides_notnull = new boolean[parameters.length];
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiParameter[] superParameters;
            PsiMethod superMethod = superMethodSignature.getMethod();
            if (!reported_nullable_method_overrides_notnull && this.REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL && annotated.isDeclaredNullable && AnnotationUtil.isNotNull((PsiModifierListOwner)superMethod)) {
                reported_nullable_method_overrides_notnull = true;
                holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
            if (!reported_not_annotated_method_overrides_notnull && this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !annotated.isDeclaredNullable && !annotated.isDeclaredNotNull && AnnotationUtil.isNotNull((PsiModifierListOwner)superMethod)) {
                reported_not_annotated_method_overrides_notnull = true;
                holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.method.overrides.NotNull", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AnnotateMethodFix("org.jetbrains.annotations.NotNull", new String[]{"org.jetbrains.annotations.Nullable"}){

                    @Override
                    public int annotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
                        return NullableStuffInspection.this.annotateBaseMethod(method, superMethod, project);
                    }
                }});
            }
            if (!this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && !this.REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL || (superParameters = superMethod.getParameterList().getParameters()).length != parameters.length) continue;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiParameter superParameter = superParameters[i];
                if (!reported_notnull_parameter_overrides_nullable[i] && this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"org.jetbrains.annotations.NotNull", (boolean)false) && AnnotationUtil.isAnnotated((PsiModifierListOwner)superParameter, (String)"org.jetbrains.annotations.Nullable", (boolean)false)) {
                    reported_notnull_parameter_overrides_nullable[i] = true;
                    holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.Nullable", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                if (reported_not_annotated_parameter_overrides_notnull[i] || !this.REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL || AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (Collection)AnnotationUtil.ALL_ANNOTATIONS) || !AnnotationUtil.isAnnotated((PsiModifierListOwner)superParameter, (String)"org.jetbrains.annotations.NotNull", (boolean)false)) continue;
                reported_not_annotated_parameter_overrides_notnull[i] = true;
                holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.parameter.overrides.NotNull", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddNotNullAnnotationFix((PsiModifierListOwner)parameter)});
            }
        }
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean[] parameterAnnotated = new boolean[parameters.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters.length];
            boolean hasAnnotatedParameter = false;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                parameterAnnotated[i] = AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"org.jetbrains.annotations.NotNull", (boolean)false);
                hasAnnotatedParameter |= parameterAnnotated[i];
            }
            if (hasAnnotatedParameter || annotated.isDeclaredNotNull) {
                PsiManager manager = method.getManager();
                PsiMethod[] overridings = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)GlobalSearchScope.allScope((Project)manager.getProject()), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    if (!manager.isInProject((PsiElement)overriding)) continue;
                    if (!methodQuickFixSuggested && annotated.isDeclaredNotNull && !AnnotationUtil.isAnnotated((PsiModifierListOwner)overriding, (String)"org.jetbrains.annotations.NotNull", (boolean)false)) {
                        method.getNameIdentifier();
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.jetbrains.annotations.NotNull"});
                        holder.registerProblem((PsiElement)annotation, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.methods.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{ANNOTATE_OVERRIDDEN_METHODS_FIX});
                        methodQuickFixSuggested = true;
                    }
                    if (!hasAnnotatedParameter) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i = 0; i < psiParameters.length; ++i) {
                        if (parameterQuickFixSuggested[i]) continue;
                        PsiParameter parameter = psiParameters[i];
                        if (!parameterAnnotated[i] || AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"org.jetbrains.annotations.NotNull", (boolean)false)) continue;
                        parameters[i].getNameIdentifier();
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameters[i], (String[])new String[]{"org.jetbrains.annotations.NotNull"});
                        holder.registerProblem((PsiElement)annotation, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.method.parameters.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{ANNOTATE_OVERRIDDEN_METHODS_PARAMS_FIX});
                        parameterQuickFixSuggested[i] = true;
                    }
                }
            }
        }
    }

    protected int annotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
        return new AnnotateMethodFix("org.jetbrains.annotations.NotNull", "org.jetbrains.annotations.Nullable").annotateBaseMethod(method, superMethod, project);
    }

    private static void reportNullableNotNullConflict(ProblemsHolder holder, PsiModifierListOwner listOwner, PsiAnnotation declaredNullable, PsiAnnotation declaredNotNull) {
        holder.registerProblem((PsiElement)(declaredNotNull.isPhysical() ? declaredNotNull : listOwner.getNavigationElement()), InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.NotNull.conflict", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNotNull, listOwner)});
        holder.registerProblem((PsiElement)(declaredNullable.isPhysical() ? declaredNullable : listOwner.getNavigationElement()), InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.NotNull.conflict", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNullable, listOwner)});
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    private class OptionsPanel
    extends JPanel {
        private JCheckBox myNNParameterOverridesN;
        private JCheckBox myNAMethodOverridesNN;
        private JCheckBox myNMethodOverridesNN;
        private JCheckBox myNAParameterOverridesNN;
        private JPanel myPanel;
        private JCheckBox myReportNotAnnotatedSetterParameter;
        private JCheckBox myReportNotAnnotatedGetter;
        private JCheckBox myReportAnnotationNotPropagated;

        private OptionsPanel() {
            super(new BorderLayout());
            this.$$$setupUI$$$();
            this.add((Component)this.myPanel, "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.apply();
                }
            };
            this.myNAMethodOverridesNN.addActionListener(actionListener);
            this.myNMethodOverridesNN.addActionListener(actionListener);
            this.myNNParameterOverridesN.addActionListener(actionListener);
            this.myNAParameterOverridesNN.addActionListener(actionListener);
            this.myReportNotAnnotatedSetterParameter.addActionListener(actionListener);
            this.myReportNotAnnotatedGetter.addActionListener(actionListener);
            this.myReportAnnotationNotPropagated.addActionListener(actionListener);
            this.reset();
        }

        private void reset() {
            this.myNNParameterOverridesN.setSelected(NullableStuffInspection.this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE);
            this.myNAMethodOverridesNN.setSelected(NullableStuffInspection.this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL);
            this.myNMethodOverridesNN.setSelected(NullableStuffInspection.this.REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL);
            this.myNAParameterOverridesNN.setSelected(NullableStuffInspection.this.REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL);
            this.myReportNotAnnotatedGetter.setSelected(NullableStuffInspection.this.REPORT_NOT_ANNOTATED_GETTER);
            this.myReportNotAnnotatedSetterParameter.setSelected(NullableStuffInspection.this.REPORT_NOT_ANNOTATED_SETTER_PARAMETER);
            this.myReportAnnotationNotPropagated.setSelected(NullableStuffInspection.this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS);
        }

        private void apply() {
            NullableStuffInspection.this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = this.myNAMethodOverridesNN.isSelected();
            NullableStuffInspection.this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = this.myNNParameterOverridesN.isSelected();
            NullableStuffInspection.this.REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = this.myNMethodOverridesNN.isSelected();
            NullableStuffInspection.this.REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = this.myNAParameterOverridesNN.isSelected();
            NullableStuffInspection.this.REPORT_NOT_ANNOTATED_SETTER_PARAMETER = this.myReportNotAnnotatedSetterParameter.isSelected();
            NullableStuffInspection.this.REPORT_NOT_ANNOTATED_GETTER = this.myReportNotAnnotatedGetter.isSelected();
            NullableStuffInspection.this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = this.myReportAnnotationNotPropagated.isSelected();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myNMethodOverridesNN = jCheckBox7 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.parameter.overrides.option"));
            jPanel.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myNAMethodOverridesNN = jCheckBox6 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.method.overrides.option"));
            jPanel.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myNNParameterOverridesN = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.method.overrides.notnull.option"));
            jPanel.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myNAParameterOverridesNN = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.method.overrides.notnull"));
            jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myReportNotAnnotatedSetterParameter = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.not.annotated.parameters.for.annotated.field.setters"));
            jPanel.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myReportNotAnnotatedGetter = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.not.annotated.getters.for.annotated.fields"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myReportAnnotationNotPropagated = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.annotation.not.propagated"));
            jPanel.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;

        private Annotated(boolean isDeclaredNotNull, boolean isDeclaredNullable) {
            this.isDeclaredNotNull = isDeclaredNotNull;
            this.isDeclaredNullable = isDeclaredNullable;
        }
    }
}

