/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomTagOrAttributeIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUnknownTagInspection
extends HtmlLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspection");
    public JDOMExternalizableStringList myValues;
    public boolean myCustomValuesEnabled;
    @NonNls
    public static final String TAG_SHORT_NAME = "HtmlUnknownTag";

    public HtmlUnknownTagInspection() {
        this("nobr,noembed,comment,noscript");
    }

    protected HtmlUnknownTagInspection(@NonNls @NotNull String defaultValues) {
        if (defaultValues == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.<init> must not be null");
        }
        this.myCustomValuesEnabled = true;
        this.myValues = HtmlUnknownTagInspection.reparseProperties(defaultValues);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.unknown.tag", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (TAG_SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.getShortName must not return null");
        }
        return TAG_SHORT_NAME;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BoxLayout(internalPanel, 1));
        result.add((Component)internalPanel, "South");
        final FieldPanel additionalAttributesPanel = new FieldPanel(null, this.getPanelTitle(), null, null);
        additionalAttributesPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Document document = e.getDocument();
                try {
                    String text = document.getText(0, document.getLength());
                    if (text != null) {
                        HtmlUnknownTagInspection.this.myValues = HtmlUnknownTagInspection.reparseProperties(text.trim());
                    }
                }
                catch (BadLocationException e1) {
                    HtmlUnknownTagInspection.this.getLogger().error((Throwable)e1);
                }
            }
        });
        final JCheckBox checkBox = new JCheckBox(this.getCheckboxTitle());
        checkBox.setSelected(this.myCustomValuesEnabled);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = checkBox.isSelected();
                if (b != HtmlUnknownTagInspection.this.myCustomValuesEnabled) {
                    HtmlUnknownTagInspection.this.myCustomValuesEnabled = b;
                    additionalAttributesPanel.setEnabled(HtmlUnknownTagInspection.this.myCustomValuesEnabled);
                }
            }
        });
        internalPanel.add(checkBox);
        internalPanel.add((Component)additionalAttributesPanel);
        additionalAttributesPanel.setPreferredSize(new Dimension(150, additionalAttributesPanel.getPreferredSize().height));
        additionalAttributesPanel.setEnabled(this.myCustomValuesEnabled);
        additionalAttributesPanel.setText(this.createPropertiesString());
        return result;
    }

    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.getLogger must not return null");
        }
        return logger;
    }

    private String createPropertiesString() {
        StringBuffer buffer = new StringBuffer();
        for (String property : this.myValues) {
            if (buffer.length() == 0) {
                buffer.append(property);
                continue;
            }
            buffer.append(',');
            buffer.append(property);
        }
        return buffer.toString();
    }

    public String getAdditionalEntries() {
        return this.createPropertiesString();
    }

    protected String getCheckboxTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.checkbox.title", (Object[])new Object[0]);
    }

    protected static JDOMExternalizableStringList reparseProperties(@NotNull String properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.reparseProperties must not be null");
        }
        JDOMExternalizableStringList result = new JDOMExternalizableStringList();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add((Object)tokenizer.nextToken().toLowerCase().trim());
        }
        return result;
    }

    public void setAdditionalValues(@NotNull String values) {
        if (values == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.setAdditionalValues must not be null");
        }
        this.myValues = HtmlUnknownTagInspection.reparseProperties(values);
    }

    protected String getPanelTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.title", (Object[])new Object[0]);
    }

    protected boolean isCustomValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.isCustomValue must not be null");
        }
        return this.myValues.contains((Object)value.toLowerCase());
    }

    public void addCustomPropertyName(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.addCustomPropertyName must not be null");
        }
        String s = text.trim().toLowerCase();
        if (!this.isCustomValue(s)) {
            this.myValues.add((Object)s);
        }
        if (!this.isCustomValuesEnabled()) {
            this.myCustomValuesEnabled = true;
        }
    }

    public boolean isCustomValuesEnabled() {
        return this.myCustomValuesEnabled;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.checkTag must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspection.checkTag must not be null");
        }
        if (tag.getUserData(DO_NOT_VALIDATE_KEY) == null) {
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (tag instanceof HtmlTag && (descriptor instanceof AnyXmlElementDescriptor || descriptor == null)) {
                String name = tag.getName();
                if (!this.isCustomValuesEnabled() || !this.isCustomValue(name)) {
                    AddCustomTagOrAttributeIntentionAction action = new AddCustomTagOrAttributeIntentionAction(this.getShortName(), name, 1);
                    String message = XmlErrorMessages.message("unknown.html.tag", name);
                    XmlToken startTagName = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                    XmlToken endTagName = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
                    CreateNSDeclarationIntentionFix declarationIntentionFix = isOnTheFly ? new CreateNSDeclarationIntentionFix((PsiElement)startTagName, "") : null;
                    ProblemHighlightType highlightType = tag.getContainingFile().getContext() == null ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                    holder.registerProblem((PsiElement)startTagName, message, highlightType, new LocalQuickFix[]{action, declarationIntentionFix});
                    if (endTagName != null) {
                        holder.registerProblem((PsiElement)endTagName, message, highlightType, new LocalQuickFix[]{action, declarationIntentionFix});
                    }
                }
            }
        }
    }
}

