/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlLocalInspectionTool
extends XmlSuppressableInspectionTool {
    public static final Key<String> DO_NOT_VALIDATE_KEY = XmlHighlightVisitor.DO_NOT_VALIDATE_KEY;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.HTML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/HtmlLocalInspectionTool.getGroupDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlLocalInspectionTool.checkTag must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlLocalInspectionTool.checkTag must not be null");
        }
    }

    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (attribute == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlLocalInspectionTool.checkAttribute must not be null");
        }
        if (holder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlLocalInspectionTool.checkAttribute must not be null");
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/htmlInspections/HtmlLocalInspectionTool.buildVisitor must not be null");
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlToken(XmlToken token) {
                if (token.getTokenType() == XmlTokenType.XML_NAME) {
                    PsiElement parent;
                    PsiElement element = token.getPrevSibling();
                    while (element instanceof PsiWhiteSpace) {
                        element = element.getPrevSibling();
                    }
                    if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element.getParent()) instanceof XmlTag && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                        XmlTag tag = (XmlTag)parent;
                        HtmlLocalInspectionTool.this.checkTag(tag, holder, isOnTheFly);
                    }
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                HtmlLocalInspectionTool.this.checkAttribute(attribute, holder, isOnTheFly);
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/htmlInspections/HtmlLocalInspectionTool.buildVisitor must not return null");
        }
        return xmlElementVisitor;
    }
}

