/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class HTMLExporter {
    private final String myRootFolder;
    private final Project myProject;
    private int myFileCounter;
    private final HashMap<RefEntity, String> myElementToFilenameMap;
    private final HTMLComposerImpl myComposer;
    private final HashSet<RefEntity> myGeneratedReferences;
    private final HashSet<RefEntity> myGeneratedPages;

    public HTMLExporter(String rootFolder, HTMLComposerImpl composer, Project project) {
        this.myRootFolder = rootFolder;
        this.myProject = project;
        this.myElementToFilenameMap = new HashMap();
        this.myFileCounter = 0;
        this.myComposer = composer;
        this.myGeneratedPages = new HashSet();
        this.myGeneratedReferences = new HashSet();
    }

    public void createPage(RefEntity element) {
        String currentFileName = this.fileNameForElement(element);
        StringBuffer buf = new StringBuffer();
        this.appendNavBar(buf, element);
        this.myComposer.composeWithExporter(buf, element, this);
        HTMLExporter.writeFile(this.myRootFolder, currentFileName, buf, this.myProject);
        this.myGeneratedPages.add(element);
    }

    private void appendNavBar(@NonNls StringBuffer buf, RefEntity element) {
        buf.append("<a href=\"../index.html\" target=\"_top\">");
        buf.append(InspectionsBundle.message((String)"inspection.export.inspections.link.text", (Object[])new Object[0]));
        buf.append("</a>  ");
        if (element instanceof RefElement) {
            this.myComposer.appendElementReference(buf, this.getURL(element), InspectionsBundle.message((String)"inspection.export.open.source.link.text", (Object[])new Object[0]), "_blank");
        }
        buf.append("<hr>");
    }

    public static void writeFile(String folder, @NonNls String fileName, StringBuffer buf, final Project project) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        final String fullPath = folder + File.separator + fileName;
        if (indicator != null) {
            ProgressManager.checkCanceled();
            indicator.setText(InspectionsBundle.message((String)"inspection.export.generating.html.for", (Object[])new Object[]{fullPath}));
        }
        OutputStreamWriter writer = null;
        try {
            File folderFile = new File(folder);
            folderFile.mkdirs();
            writer = new FileWriter(fullPath);
            writer.write(buf.toString().toCharArray());
        }
        catch (IOException e) {
            Runnable showError = new Runnable(){

                @Override
                public void run() {
                    Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.export.error.writing.to", (Object[])new Object[]{fullPath}), (String)InspectionsBundle.message((String)"inspection.export.results.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                }
            };
            ApplicationManager.getApplication().invokeLater(showError, ModalityState.NON_MODAL);
            throw new ProcessCanceledException();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getURL(RefEntity element) {
        this.myGeneratedReferences.add(element);
        return this.fileNameForElement(element);
    }

    private String fileNameForElement(RefEntity element) {
        String fileName = (String)this.myElementToFilenameMap.get((Object)element);
        if (fileName == null) {
            fileName = "e" + Integer.toString(++this.myFileCounter) + ".html";
            this.myElementToFilenameMap.put((Object)element, (Object)fileName);
        }
        return fileName;
    }

    private Set<RefEntity> getReferencesWithoutPages() {
        HashSet<RefEntity> result = new HashSet<RefEntity>();
        for (RefEntity refElement : this.myGeneratedReferences) {
            if (this.myGeneratedPages.contains(refElement)) continue;
            result.add(refElement);
        }
        return result;
    }

    public void generateReferencedPages() {
        Set<RefEntity> extras = this.getReferencesWithoutPages();
        while (extras.size() > 0) {
            for (RefEntity refElement : extras) {
                this.createPage(refElement);
            }
            extras = this.getReferencesWithoutPages();
        }
    }

    public String getRootFolder() {
        return this.myRootFolder;
    }
}

