/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.emptyMethod;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.BidirectionalMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyMethodInspection
extends GlobalJavaInspectionTool {
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.empty.method.display.name", (Object[])new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "EmptyMethod";
    private final BidirectionalMap<Boolean, QuickFix> myQuickFixes = new BidirectionalMap();
    private final JDOMExternalizableStringList EXCLUDE_ANNOS = new JDOMExternalizableStringList();
    @NonNls
    private static final String QUICK_FIX_NAME = InspectionsBundle.message((String)"inspection.empty.method.delete.quickfix", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.emptyMethod.EmptyMethodInspection");

    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor processor) {
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        final RefMethod refMethod = (RefMethod)refEntity;
        if (!this.isBodyEmpty(refMethod)) {
            return null;
        }
        if (refMethod.isConstructor()) {
            return null;
        }
        if (refMethod.isSyntheticJSP()) {
            return null;
        }
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (this.checkElement((RefEntity)refSuper, scope, manager, globalContext, processor) == null) continue;
            return null;
        }
        String message = null;
        boolean needToDeleteHierarchy = false;
        if (refMethod.isOnlyCallsSuper() && !refMethod.isFinal()) {
            RefMethod refSuper = EmptyMethodInspection.findSuperWithBody(refMethod);
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            if (refSuper != null && Comparing.strEqual((String)refMethod.getAccessModifier(), (String)refSuper.getAccessModifier())) {
                PsiModifierListOwner supMethod;
                PsiModifierList list;
                if (Comparing.strEqual((String)refSuper.getAccessModifier(), (String)"protected") && !Comparing.strEqual((String)refUtil.getPackageName((RefEntity)refSuper), (String)refUtil.getPackageName((RefEntity)refMethod))) {
                    return null;
                }
                PsiModifierListOwner modifierListOwner = refMethod.getElement();
                if (modifierListOwner != null && (list = modifierListOwner.getModifierList()) != null && (supMethod = refSuper.getElement()) != null) {
                    PsiModifierList superModifiedList = supMethod.getModifierList();
                    LOG.assertTrue(superModifiedList != null);
                    if (list.hasModifierProperty("synchronized") && !superModifiedList.hasModifierProperty("synchronized")) {
                        return null;
                    }
                }
            }
            if (refSuper == null || refUtil.compareAccess(refMethod.getAccessModifier(), refSuper.getAccessModifier()) <= 0) {
                message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor", (Object[])new Object[0]);
            }
        } else if (refMethod.hasBody() && this.hasEmptySuperImplementation(refMethod)) {
            message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor1", (Object[])new Object[0]);
        } else if (this.areAllImplementationsEmpty(refMethod)) {
            if (refMethod.hasBody()) {
                if (refMethod.getDerivedMethods().isEmpty()) {
                    if (refMethod.getSuperMethods().isEmpty()) {
                        message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor2", (Object[])new Object[0]);
                    }
                } else {
                    needToDeleteHierarchy = true;
                    message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor3", (Object[])new Object[0]);
                }
            } else if (!refMethod.getDerivedMethods().isEmpty()) {
                needToDeleteHierarchy = true;
                message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor4", (Object[])new Object[0]);
            }
        }
        if (message != null) {
            final ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            fixes.add(this.getFix(processor, needToDeleteHierarchy));
            SpecialAnnotationsUtil.createAddToSpecialAnnotationFixes(refMethod.getElement(), new Processor<String>(){

                public boolean process(String qualifiedName) {
                    fixes.add(SpecialAnnotationsUtil.createAddToSpecialAnnotationsListQuickFix(QuickFixBundle.message("fix.add.special.annotation.text", qualifiedName), QuickFixBundle.message("fix.add.special.annotation.family", new Object[0]), (List<String>)EmptyMethodInspection.this.EXCLUDE_ANNOS, qualifiedName, (PsiElement)refMethod.getElement()));
                    return true;
                }
            });
            ProblemDescriptor descriptor = manager.createProblemDescriptor(refMethod.getElement().getNavigationElement(), message, false, fixes.toArray(new LocalQuickFix[fixes.size()]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    private boolean isBodyEmpty(RefMethod refMethod) {
        if (!refMethod.isBodyEmpty()) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)refMethod.getElement(), (Collection)this.EXCLUDE_ANNOS)) {
            return false;
        }
        for (Object extension : Extensions.getExtensions((String)"com.intellij.canBeEmpty")) {
            if (!((Condition)extension).value((Object)refMethod)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static RefMethod findSuperWithBody(RefMethod refMethod) {
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (!refSuper.hasBody()) continue;
            return refSuper;
        }
        return null;
    }

    private boolean areAllImplementationsEmpty(RefMethod refMethod) {
        if (refMethod.hasBody() && !this.isBodyEmpty(refMethod)) {
            return false;
        }
        for (RefMethod refDerived : refMethod.getDerivedMethods()) {
            if (this.areAllImplementationsEmpty(refDerived)) continue;
            return false;
        }
        return true;
    }

    private boolean hasEmptySuperImplementation(RefMethod refMethod) {
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (!refSuper.hasBody() || !this.isBodyEmpty(refSuper)) continue;
            return true;
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(RefManager manager, final GlobalJavaInspectionContext context, final ProblemDescriptionsProcessor descriptionsProcessor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (refEntity instanceof RefElement && descriptionsProcessor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final RefMethod refMethod) {
                            context.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                public boolean process(PsiMethod derivedMethod) {
                                    PsiCodeBlock body = derivedMethod.getBody();
                                    if (body == null) {
                                        return true;
                                    }
                                    if (body.getStatements().length == 0) {
                                        return true;
                                    }
                                    if (RefJavaUtil.getInstance().isMethodOnlyCallsSuper(derivedMethod)) {
                                        return true;
                                    }
                                    descriptionsProcessor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/emptyMethod/EmptyMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/emptyMethod/EmptyMethodInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/emptyMethod/EmptyMethodInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    private LocalQuickFix getFix(ProblemDescriptionsProcessor processor, boolean needToDeleteHierarchy) {
        Object fix = (QuickFix)this.myQuickFixes.get((Object)needToDeleteHierarchy);
        if (fix == null) {
            fix = new DeleteMethodQuickFix(processor, needToDeleteHierarchy);
            this.myQuickFixes.put((Object)needToDeleteHierarchy, fix);
            return (LocalQuickFix)fix;
        }
        return (LocalQuickFix)fix;
    }

    public String getHint(QuickFix fix) {
        List list = this.myQuickFixes.getKeysByValue((Object)fix);
        if (list != null) {
            LOG.assertTrue(list.size() == 1);
            return String.valueOf(list.get(0));
        }
        return null;
    }

    @Nullable
    public LocalQuickFix getQuickFix(String hint) {
        return new DeleteMethodIntention(hint);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel listPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)this.EXCLUDE_ANNOS, InspectionsBundle.message((String)"special.annotations.annotations.list", (Object[])new Object[0]));
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)listPanel, "North");
        return panel;
    }

    private class DeleteMethodQuickFix
    implements LocalQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private final boolean myNeedToDEleteHierarchy;

        public DeleteMethodQuickFix(ProblemDescriptionsProcessor processor, boolean needToDeleteHierarchy) {
            this.myProcessor = processor;
            this.myNeedToDEleteHierarchy = needToDeleteHierarchy;
        }

        @NotNull
        public String getName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix.getName must not return null");
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix.applyFix must not be null");
            }
            RefElement refElement = (RefElement)this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
            if (refElement.isValid() && refElement instanceof RefMethod) {
                final ArrayList<RefElement> refElements = new ArrayList<RefElement>(1);
                RefMethod refMethod = (RefMethod)refElement;
                final ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
                if (this.myNeedToDEleteHierarchy) {
                    this.deleteHierarchy(refMethod, psiElements, refElements);
                } else {
                    this.deleteMethod(refMethod, psiElements, refElements);
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SafeDeleteHandler.invoke(project, psiElements.toArray(new PsiElement[psiElements.size()]), false, new Runnable(){

                            @Override
                            public void run() {
                                QuickFixAction.removeElements(refElements.toArray(new RefElement[refElements.size()]), project, (InspectionTool)DeleteMethodQuickFix.this.myProcessor);
                            }
                        });
                    }
                });
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix.getFamilyName must not return null");
            }
            return string;
        }

        private void deleteHierarchy(RefMethod refMethod, List<PsiElement> result, List<RefElement> refElements) {
            RefMethod[] refMethods;
            Collection derivedMethods = refMethod.getDerivedMethods();
            for (RefMethod refDerived : refMethods = derivedMethods.toArray(new RefMethod[derivedMethods.size()])) {
                this.deleteMethod(refDerived, result, refElements);
            }
            this.deleteMethod(refMethod, result, refElements);
        }

        private void deleteMethod(RefMethod refMethod, List<PsiElement> result, List<RefElement> refElements) {
            refElements.add((RefElement)refMethod);
            PsiModifierListOwner psiElement = refMethod.getElement();
            if (psiElement == null) {
                return;
            }
            if (!result.contains(psiElement)) {
                result.add((PsiElement)psiElement);
            }
        }
    }

    private class DeleteMethodIntention
    implements LocalQuickFix {
        private final String myHint;

        public DeleteMethodIntention(String hint) {
            this.myHint = hint;
        }

        @NotNull
        public String getName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention.applyFix must not be null");
            }
            final PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class, (boolean)false);
            if (psiMethod != null) {
                final ArrayList<PsiMethod> psiElements = new ArrayList<PsiMethod>();
                psiElements.add(psiMethod);
                if (Boolean.valueOf(this.myHint).booleanValue()) {
                    Query query = AllOverridingMethodsSearch.search((PsiClass)psiMethod.getContainingClass());
                    query.forEach((Processor)new Processor<Pair<PsiMethod, PsiMethod>>(){

                        public boolean process(Pair<PsiMethod, PsiMethod> pair) {
                            if (pair.first == psiMethod) {
                                psiElements.add(pair.second);
                            }
                            return true;
                        }
                    });
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SafeDeleteHandler.invoke(project, psiElements.toArray(new PsiElement[psiElements.size()]), false);
                    }
                });
            }
        }
    }
}

