/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defaultFileTemplateUsage;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.defaultFileTemplateUsage.DefaultFileTemplateUsageInspection;
import com.intellij.codeInspection.defaultFileTemplateUsage.ReplaceWithFileTemplateFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodBodyChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.defaultFileTemplateUsage.MethodBodyChecker");
    private static final Key<Map<String, PsiMethod>> CACHE_KEY = new Key("MethodBodyChecker templates cache");
    private static final String NEW_METHOD_BODY_TEMPLATE_NAME = FileTemplateManager.getInstance().getDefaultTemplate("New Method Body.java").getName();

    @Nullable
    private static PsiMethod getTemplateMethod(PsiType returnType, List<HierarchicalMethodSignature> superSignatures, PsiClass aClass) {
        Project project = aClass.getProject();
        if (!(returnType instanceof PsiPrimitiveType)) {
            returnType = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        }
        try {
            FileTemplate template = MethodBodyChecker.getMethodFileTemplate(superSignatures, true);
            if (template == null) {
                return null;
            }
            String fileTemplateName = template.getName();
            String methodName = superSignatures.isEmpty() ? "" : superSignatures.get(0).getName();
            String key = returnType.getCanonicalText() + "+" + methodName + "+" + fileTemplateName;
            Map<String, PsiMethod> cache = MethodBodyChecker.getTemplatesCache(aClass);
            PsiMethod method = cache.get(key);
            if (method == null) {
                method = JavaPsiFacade.getInstance((Project)project).getElementFactory().createMethod("x", returnType);
                MethodBodyChecker.setupMethodBody(superSignatures, method, aClass, true);
                cache.put(key, method);
            }
            return method;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static Map<String, PsiMethod> getTemplatesCache(PsiClass aClass) {
        Map cache = (Map)aClass.getUserData(CACHE_KEY);
        if (cache == null) {
            cache = (Map)((UserDataHolderEx)aClass).putUserDataIfAbsent(CACHE_KEY, (Object)new ConcurrentHashMap());
        }
        return cache;
    }

    static void checkMethodBody(PsiMethod method, InspectionManager manager, Collection<ProblemDescriptor> problemDescriptors, boolean onTheFly) {
        PsiType returnType = method.getReturnType();
        if (method.isConstructor() || returnType == null) {
            return;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || aClass.isInterface()) {
            return;
        }
        List superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
        final PsiMethod superMethod = superSignatures.isEmpty() ? null : ((HierarchicalMethodSignature)superSignatures.get(0)).getMethod();
        final PsiMethod templateMethod = MethodBodyChecker.getTemplateMethod(returnType, superSignatures, aClass);
        if (templateMethod == null) {
            return;
        }
        PsiCodeBlock templateBody = templateMethod.getBody();
        if (templateBody == null) {
            return;
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)body, (PsiElement)templateBody, (Comparator)new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement element1, PsiElement element2) {
                if (element1 == superMethod && (element2 == templateMethod || element2 == null)) {
                    return 0;
                }
                return 1;
            }
        }, (boolean)true)) {
            Pair<? extends PsiElement, ? extends PsiElement> range = DefaultFileTemplateUsageInspection.getInteriorRange(body);
            String description = InspectionsBundle.message((String)"default.file.template.description", (Object[])new Object[0]);
            ProblemDescriptor problem = manager.createProblemDescriptor((PsiElement)range.first, (PsiElement)range.second, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, MethodBodyChecker.createMethodBodyQuickFix(method));
            problemDescriptors.add(problem);
        }
    }

    @Nullable
    private static FileTemplate getMethodFileTemplate(List<HierarchicalMethodSignature> superSignatures, boolean useDefaultTemplate) {
        FileTemplate template;
        FileTemplateManager templateManager = FileTemplateManager.getInstance();
        if (superSignatures.isEmpty()) {
            String name = "New Method Body.java";
            template = useDefaultTemplate ? templateManager.getDefaultTemplate(name) : templateManager.getCodeTemplate(name);
        } else {
            PsiMethod superMethod = superSignatures.get(0).getMethod();
            String name = superMethod.hasModifierProperty("abstract") ? "Implemented Method Body.java" : "Overridden Method Body.java";
            template = useDefaultTemplate ? templateManager.getDefaultTemplate(name) : templateManager.getCodeTemplate(name);
        }
        return template;
    }

    @Nullable
    private static FileTemplate setupMethodBody(List<HierarchicalMethodSignature> superSignatures, PsiMethod templateMethod, PsiClass aClass, boolean useDefaultTemplate) throws IncorrectOperationException {
        FileTemplate template = MethodBodyChecker.getMethodFileTemplate(superSignatures, useDefaultTemplate);
        if (template == null) {
            return null;
        }
        if (NEW_METHOD_BODY_TEMPLATE_NAME.equals(template.getName())) {
            CreateFromUsageUtils.setupMethodBody(templateMethod, aClass, template);
        } else {
            PsiMethod superMethod = superSignatures.get(0).getMethod();
            OverrideImplementUtil.setupMethodBody(templateMethod, superMethod, aClass, template);
        }
        return template;
    }

    @Nullable
    private static LocalQuickFix[] createMethodBodyQuickFix(final PsiMethod method) {
        FileTemplate template;
        PsiType returnType = method.getReturnType();
        PsiClass aClass = method.getContainingClass();
        List superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
        try {
            PsiMethod templateMethod = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createMethod("x", returnType);
            template = MethodBodyChecker.setupMethodBody(superSignatures, templateMethod, aClass, false);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        ReplaceWithFileTemplateFix replaceWithFileTemplateFix = new ReplaceWithFileTemplateFix(){

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/MethodBodyChecker$2.applyFix must not be null");
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/defaultFileTemplateUsage/MethodBodyChecker$2.applyFix must not be null");
                }
                PsiType returnType = method.getReturnType();
                if (method.isConstructor() || returnType == null) {
                    return;
                }
                PsiCodeBlock body = method.getBody();
                if (body == null) {
                    return;
                }
                if (!CodeInsightUtil.preparePsiElementsForWrite(new PsiElement[]{body})) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                List superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
                try {
                    PsiMethod templateMethod = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createMethod("x", returnType);
                    MethodBodyChecker.setupMethodBody(superSignatures, templateMethod, aClass, false);
                    PsiCodeBlock templateBody = templateMethod.getBody();
                    if (templateBody == null) {
                        return;
                    }
                    PsiElement newBody = body.replace((PsiElement)templateBody);
                    CodeStyleManager.getInstance((Project)project).reformat(newBody);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        LocalQuickFix editFileTemplateFix = DefaultFileTemplateUsageInspection.createEditFileTemplateFix(template, replaceWithFileTemplateFix);
        if (template != null && template.isDefault()) {
            return new LocalQuickFix[]{editFileTemplateFix};
        }
        return new LocalQuickFix[]{replaceWithFileTemplateFix, editFileTemplateFix};
    }
}

