/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotationsAwareDataFlowRunner
extends DataFlowRunner {
    @Override
    protected Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, InstructionVisitor visitor) {
        if (psiBlock == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/AnnotationsAwareDataFlowRunner.createInitialStates must not be null");
        }
        Collection<DfaMemoryState> initialStates = super.createInitialStates(psiBlock, visitor);
        if (initialStates == null) {
            return null;
        }
        PsiElement parent = psiBlock.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                if (!AnnotationUtil.isNotNull((PsiModifierListOwner)parameter)) continue;
                DfaVariableValue value = this.getFactory().getVarFactory().create((PsiVariable)parameter, false);
                for (DfaMemoryState initialState : initialStates) {
                    initialState.applyNotNull(value);
                }
            }
        }
        return initialStates;
    }
}

