/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class JCiPOrderEntryFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + JCiPOrderEntryFix.class.getName()));

    @NotNull
    public String getText() {
        if ("Add jcip-annotations.jar to classpath" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/JCiPOrderEntryFix.getText must not return null");
        }
        return "Add jcip-annotations.jar to classpath";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/concurrencyAnnotations/JCiPOrderEntryFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/concurrencyAnnotations/JCiPOrderEntryFix.isAvailable must not be null");
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiReference reference = TargetElementUtil.findReference(editor);
        if (!(reference instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        if (reference.resolve() != null) {
            return false;
        }
        String referenceName = ((PsiJavaCodeReferenceElement)reference).getReferenceName();
        if (referenceName == null) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (fileIndex.getModuleForFile(virtualFile) == null) {
            return false;
        }
        if (!(((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnnotation) || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)((PsiJavaCodeReferenceElement)reference))) {
            return false;
        }
        return JCiPUtil.isJCiPAnnotation(referenceName);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/concurrencyAnnotations/JCiPOrderEntryFix.invoke must not be null");
        }
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)TargetElementUtil.findReference(editor);
        LOG.assertTrue(reference != null);
        String jarPath = PathUtil.getJarPathForClass(GuardedBy.class);
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        OrderEntryFix.addBundledJarToRoots(project, editor, ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project), (PsiReference)reference, "net.jcip.annotations." + reference.getReferenceName(), jarPath);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

