/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Macro;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import java.util.Collection;
import java.util.Hashtable;
import org.jetbrains.annotations.NonNls;

public class MacroFactory {
    private static Hashtable<String, Macro> myMacroTable = null;

    public static Macro createMacro(@NonNls String name) {
        if (myMacroTable == null) {
            MacroFactory.init();
        }
        return myMacroTable.get(name);
    }

    public static Macro[] getMacros() {
        if (myMacroTable == null) {
            MacroFactory.init();
        }
        Collection<Macro> values = myMacroTable.values();
        return values.toArray(new Macro[values.size()]);
    }

    private static void init() {
        myMacroTable = new Hashtable();
        for (Macro macro : (Macro[])Extensions.getExtensions((ExtensionPointName)Macro.EP_NAME)) {
            MacroFactory.register(macro);
        }
    }

    public static void register(Macro macro) {
        if (myMacroTable == null) {
            MacroFactory.init();
        }
        myMacroTable.put(macro.getName(), macro);
    }
}

