/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.util.Query;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotatedMacro
implements Macro {
    @NonNls
    public String getName() {
        return "annotated";
    }

    public String getDescription() {
        return "annotated(\"annotation qname\")";
    }

    @NonNls
    public String getDefaultValue() {
        return "";
    }

    @Nullable
    private static Query<PsiMember> findAnnotated(ExpressionContext context, Expression[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        PsiManager instance = PsiManager.getInstance((Project)context.getProject());
        String paramResult = params[0].calculateResult(context).toString();
        if (paramResult == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)context.getProject());
        PsiClass myBaseClass = JavaPsiFacade.getInstance((Project)instance.getProject()).findClass(paramResult, scope);
        if (myBaseClass != null) {
            return AnnotatedMembersSearch.search((PsiClass)myBaseClass, (SearchScope)scope);
        }
        return null;
    }

    public Result calculateResult(@NotNull Expression[] expressions, ExpressionContext expressionContext) {
        PsiMember member;
        if (expressions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/AnnotatedMacro.calculateResult must not be null");
        }
        Query<PsiMember> psiMembers = AnnotatedMacro.findAnnotated(expressionContext, expressions);
        if (psiMembers != null && (member = (PsiMember)psiMembers.findFirst()) != null) {
            return new TextResult(member instanceof PsiClass ? ((PsiClass)member).getQualifiedName() : member.getName());
        }
        return null;
    }

    public Result calculateQuickResult(@NotNull Expression[] expressions, ExpressionContext expressionContext) {
        if (expressions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/AnnotatedMacro.calculateQuickResult must not be null");
        }
        return this.calculateResult(expressions, expressionContext);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/AnnotatedMacro.calculateLookupItems must not be null");
        }
        Query<PsiMember> query = AnnotatedMacro.findAnnotated(context, params);
        if (query != null) {
            LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
            String secondParamValue = params.length > 1 ? params[1].calculateResult(context).toString() : null;
            boolean isShortName = secondParamValue != null && Boolean.valueOf(secondParamValue) == false;
            Project project = context.getProject();
            PsiClass findInClass = secondParamValue != null ? JavaPsiFacade.getInstance((Project)project).findClass(secondParamValue, GlobalSearchScope.allScope((Project)project)) : null;
            for (PsiMember object : query.findAll()) {
                if (findInClass != null && !object.getContainingClass().equals(findInClass)) continue;
                boolean isClazz = object instanceof PsiClass;
                String name = isShortName || !isClazz ? object.getName() : ((PsiClass)object).getQualifiedName();
                set.add(LookupElementBuilder.create((String)name));
            }
            return set.toArray(new LookupElement[set.size()]);
        }
        return LookupElement.EMPTY_ARRAY;
    }
}

