/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.application.options.ExportSchemeAction;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.EditTemplateDialog;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Alarm;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

class TemplateListPanel
extends JPanel {
    private CheckboxTree myTree;
    private JButton myCopyButton;
    private JButton myEditButton;
    private JButton myRemoveButton;
    private JButton myExportButton;
    private JButton myImportButton;
    private Editor myEditor;
    private final List<TemplateGroup> myTemplateGroups = new ArrayList<TemplateGroup>();
    private JComboBox myExpandByCombo;
    private static final String SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
    private static final String TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
    private static final String ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);
    private CheckedTreeNode myTreeRoot = new CheckedTreeNode(null);
    private final Alarm myAlarm = new Alarm();
    private boolean myUpdateNeeded = false;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.TemplateListPanel");
    private final Map<Integer, Map<TemplateOptionalProcessor, Boolean>> myTemplateOptions = new LinkedHashMap<Integer, Map<TemplateOptionalProcessor, Boolean>>();
    private final Map<Integer, Map<TemplateContextType, Boolean>> myTemplateContext = new LinkedHashMap<Integer, Map<TemplateContextType, Boolean>>();

    public TemplateListPanel() {
        this.setLayout(new BorderLayout());
        this.fillPanel(this);
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
        this.myAlarm.cancelAllRequests();
    }

    public void reset() {
        this.myTemplateOptions.clear();
        this.myTemplateContext.clear();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        ArrayList<TemplateGroup> groups = new ArrayList<TemplateGroup>(templateSettings.getTemplateGroups());
        Collections.sort(groups, new Comparator<TemplateGroup>(){

            @Override
            public int compare(TemplateGroup o1, TemplateGroup o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.initTemplates(groups, templateSettings.getLastSelectedTemplateKey());
        if (templateSettings.getDefaultShortcutChar() == '\t') {
            this.myExpandByCombo.setSelectedItem(TAB);
        } else if (templateSettings.getDefaultShortcutChar() == '\n') {
            this.myExpandByCombo.setSelectedItem(ENTER);
        } else {
            this.myExpandByCombo.setSelectedItem(SPACE);
        }
        UiNotifyConnector.doWhenFirstShown((JComponent)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                TemplateListPanel.this.updateTemplateText();
            }
        });
        this.myUpdateNeeded = true;
    }

    public void apply() {
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        List<TemplateGroup> templateGroups = this.getTemplateGroups();
        for (TemplateGroup templateGroup : templateGroups) {
            for (TemplateImpl template : templateGroup.getElements()) {
                template.applyOptions(this.getOptions(template));
                template.applyContext(this.getContext(template));
            }
        }
        templateSettings.setTemplates(templateGroups);
        templateSettings.setDefaultShortcutChar(this.getDefaultShortcutChar());
        this.reset();
    }

    public boolean isModified() {
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        if (templateSettings.getDefaultShortcutChar() != this.getDefaultShortcutChar()) {
            return true;
        }
        List<TemplateGroup> originalGroups = templateSettings.getTemplateGroups();
        List<TemplateGroup> newGroups = this.getTemplateGroups();
        return !this.checkAreEqual(TemplateListPanel.collectTemplates(originalGroups), TemplateListPanel.collectTemplates(newGroups));
    }

    private static List<TemplateImpl> collectTemplates(List<TemplateGroup> groups) {
        ArrayList<TemplateImpl> result = new ArrayList<TemplateImpl>();
        for (TemplateGroup group : groups) {
            result.addAll(group.getElements());
        }
        Collections.sort(result, new Comparator<TemplateImpl>(){

            @Override
            public int compare(TemplateImpl o1, TemplateImpl o2) {
                int groupsEqual = o1.getGroupName().compareTo(o2.getGroupName());
                if (groupsEqual != 0) {
                    return groupsEqual;
                }
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return result;
    }

    private boolean checkAreEqual(List<TemplateImpl> originalGroup, List<TemplateImpl> newGroup) {
        if (originalGroup.size() != newGroup.size()) {
            return false;
        }
        for (int i = 0; i < newGroup.size(); ++i) {
            TemplateImpl newTemplate = newGroup.get(i);
            newTemplate.parseSegments();
            TemplateImpl originalTemplate = originalGroup.get(i);
            originalTemplate.parseSegments();
            if (!originalTemplate.equals(newTemplate)) {
                return false;
            }
            if (originalTemplate.isDeactivated() != newTemplate.isDeactivated()) {
                return false;
            }
            if (!this.areOptionsEqual(newTemplate, originalTemplate)) {
                return false;
            }
            if (this.areContextsEqual(newTemplate, originalTemplate)) continue;
            return false;
        }
        return true;
    }

    private boolean areContextsEqual(TemplateImpl newTemplate, TemplateImpl originalTemplate) {
        Map<TemplateContextType, Boolean> templateContext = this.getTemplateContext(newTemplate);
        for (TemplateContextType processor : templateContext.keySet()) {
            if (originalTemplate.getTemplateContext().isEnabled(processor) == templateContext.get(processor).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean areOptionsEqual(TemplateImpl newTemplate, TemplateImpl originalTemplate) {
        Map<TemplateOptionalProcessor, Boolean> templateOptions = this.getTemplateOptions(newTemplate);
        for (TemplateOptionalProcessor processor : templateOptions.keySet()) {
            if (processor.isEnabled(originalTemplate) == templateOptions.get(processor).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Map<TemplateContextType, Boolean> getTemplateContext(TemplateImpl newTemplate) {
        return this.myTemplateContext.get(TemplateListPanel.getKey(newTemplate));
    }

    private Map<TemplateOptionalProcessor, Boolean> getTemplateOptions(TemplateImpl newTemplate) {
        return this.myTemplateOptions.get(TemplateListPanel.getKey(newTemplate));
    }

    private char getDefaultShortcutChar() {
        Object selectedItem = this.myExpandByCombo.getSelectedItem();
        if (TAB.equals(selectedItem)) {
            return '\t';
        }
        if (ENTER.equals(selectedItem)) {
            return '\n';
        }
        return ' ';
    }

    private List<TemplateGroup> getTemplateGroups() {
        return this.myTemplateGroups;
    }

    private void fillPanel(JPanel optionsPanel) {
        JPanel tablePanel = new JPanel();
        tablePanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this.createTable(), "Center");
        JPanel tableButtonsPanel = new JPanel();
        tableButtonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        tableButtonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        JButton addButton = TemplateListPanel.createButton(tableButtonsPanel, gbConstraints, CodeInsightBundle.message((String)"templates.dialog.table.action.add", (Object[])new Object[0]));
        addButton.setEnabled(true);
        this.myCopyButton = TemplateListPanel.createButton(tableButtonsPanel, gbConstraints, CodeInsightBundle.message((String)"templates.dialog.table.action.copy", (Object[])new Object[0]));
        this.myEditButton = TemplateListPanel.createButton(tableButtonsPanel, gbConstraints, CodeInsightBundle.message((String)"templates.dialog.table.action.edit", (Object[])new Object[0]));
        this.myRemoveButton = TemplateListPanel.createButton(tableButtonsPanel, gbConstraints, CodeInsightBundle.message((String)"templates.dialog.table.action.remove", (Object[])new Object[0]));
        if (TemplateListPanel.getSchemesManager().isExportAvailable()) {
            this.myExportButton = TemplateListPanel.createButton(tableButtonsPanel, gbConstraints, "Share...");
            this.myEditButton.setMnemonic('S');
            this.myExportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TemplateListPanel.this.exportCurrentGroup();
                }
            });
        }
        if (TemplateListPanel.getSchemesManager().isImportAvailable()) {
            this.myImportButton = TemplateListPanel.createButton(tableButtonsPanel, gbConstraints, "Import Shared...");
            this.myImportButton.setMnemonic('I');
            this.myImportButton.setEnabled(true);
            this.myImportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new SchemesToImportPopup<TemplateGroup, TemplateGroup>((Component)TemplateListPanel.this){

                        @Override
                        protected void onSchemeSelected(TemplateGroup scheme) {
                            for (TemplateImpl newTemplate : scheme.getElements()) {
                                for (TemplateImpl existingTemplate : TemplateListPanel.this.collectAllTemplates()) {
                                    if (!existingTemplate.getKey().equals(newTemplate.getKey())) continue;
                                    Messages.showMessageDialog((Component)TemplateListPanel.this, (String)CodeInsightBundle.message((String)"dialog.edit.template.error.already.exists", (Object[])new Object[]{existingTemplate.getKey(), existingTemplate.getGroupName()}), (String)CodeInsightBundle.message((String)"dialog.edit.template.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                                    return;
                                }
                            }
                            TemplateListPanel.this.insertNewGroup(scheme);
                            for (TemplateImpl template : scheme.getElements()) {
                                TemplateListPanel.this.addTemplate(template);
                            }
                        }
                    }.show(TemplateListPanel.getSchemesManager(), TemplateListPanel.this.myTemplateGroups);
                }
            });
        }
        gbConstraints.weighty = 1.0;
        tableButtonsPanel.add((Component)new JPanel(), gbConstraints);
        tablePanel.add((Component)tableButtonsPanel, "East");
        optionsPanel.add((Component)tablePanel, "Center");
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.myEditor = TemplateEditorUtil.createEditor(true, "");
        textPanel.add((Component)this.myEditor.getComponent(), "Center");
        textPanel.add((Component)this.createExpandByPanel(), "South");
        textPanel.setPreferredSize(new Dimension(100, this.myEditor.getLineHeight() * 12));
        optionsPanel.add((Component)textPanel, "South");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateListPanel.this.addRow();
            }
        });
        this.myCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateListPanel.this.copyRow();
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateListPanel.this.edit();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateListPanel.this.removeRow();
            }
        });
    }

    private Iterable<? extends TemplateImpl> collectAllTemplates() {
        ArrayList result = new ArrayList();
        for (TemplateGroup templateGroup : this.myTemplateGroups) {
            result.addAll(templateGroup.getElements());
        }
        return result;
    }

    private void exportCurrentGroup() {
        int selected = this.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        ExportSchemeAction.doExport(this.getGroup(selected), TemplateListPanel.getSchemesManager());
    }

    private static SchemesManager<TemplateGroup, TemplateGroup> getSchemesManager() {
        return TemplateSettings.getInstance().getSchemesManager();
    }

    private static JButton createButton(JPanel tableButtonsPanel, GridBagConstraints gbConstraints, String message) {
        JButton button = new JButton(message);
        button.setEnabled(false);
        tableButtonsPanel.add((Component)button, gbConstraints);
        return button;
    }

    private JPanel createExpandByPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weighty = 0.0;
        gbConstraints.insets = new Insets(4, 0, 0, 0);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridy = 0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"templates.dialog.shortcut.chooser.label", (Object[])new Object[0])), gbConstraints);
        gbConstraints.gridx = 1;
        this.myExpandByCombo = new JComboBox();
        this.myExpandByCombo.addItem(SPACE);
        this.myExpandByCombo.addItem(TAB);
        this.myExpandByCombo.addItem(ENTER);
        panel.add((Component)this.myExpandByCombo, gbConstraints);
        gbConstraints.gridx = 2;
        gbConstraints.weightx = 1.0;
        panel.add((Component)new JPanel(), gbConstraints);
        return panel;
    }

    @Nullable
    private TemplateKey getTemplateKey(int row) {
        DefaultMutableTreeNode node;
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateImpl) {
            return new TemplateKey((TemplateImpl)node.getUserObject());
        }
        return null;
    }

    @Nullable
    private TemplateImpl getTemplate(int row) {
        DefaultMutableTreeNode node;
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateImpl) {
            return (TemplateImpl)node.getUserObject();
        }
        return null;
    }

    @Nullable
    private TemplateGroup getGroup(int row) {
        DefaultMutableTreeNode node;
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateGroup) {
            return (TemplateGroup)((Object)node.getUserObject());
        }
        return null;
    }

    private void edit() {
        int selected = this.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        TemplateImpl template = this.getTemplate(selected);
        DefaultMutableTreeNode oldTemplateNode = this.getNode(selected);
        if (template == null) {
            return;
        }
        String oldGroupName = template.getGroupName();
        EditTemplateDialog dialog = new EditTemplateDialog(this, CodeInsightBundle.message((String)"dialog.edit.live.template.title", (Object[])new Object[0]), template, this.getTemplateGroups(), (String)this.myExpandByCombo.getSelectedItem(), this.getOptions(template), this.getContext(template));
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        TemplateGroup group = this.getTemplateGroup(template.getGroupName());
        LOG.assertTrue(group != null, (Object)template.getGroupName());
        dialog.apply();
        if (!oldGroupName.equals(template.getGroupName())) {
            DefaultMutableTreeNode templateNode;
            TemplateGroup oldGroup = this.getTemplateGroup(oldGroupName);
            if (oldGroup != null) {
                oldGroup.removeElement(template);
            }
            template.setId(null);
            CheckboxTree tree = this.myTree;
            if (oldTemplateNode != null) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)oldTemplateNode.getParent();
                this.removeNodeFromParent(oldTemplateNode);
                if (parent.getChildCount() == 0) {
                    this.removeNodeFromParent(parent);
                }
            }
            if ((templateNode = this.addTemplate(template)) != null) {
                TreePath newTemplatePath = new TreePath(templateNode.getPath());
                ((JTree)((Object)tree)).expandPath(newTemplatePath);
                selected = ((JTree)((Object)tree)).getRowForPath(newTemplatePath);
            }
            ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged((TreeNode)this.myTreeRoot);
        }
        this.myTree.setSelectionInterval(selected, selected);
        this.updateTemplateTextArea();
    }

    private Map<TemplateOptionalProcessor, Boolean> getOptions(TemplateImpl template) {
        return this.getTemplateOptions(template);
    }

    @Nullable
    private DefaultMutableTreeNode getNode(int row) {
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null) {
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    @Nullable
    private TemplateGroup getTemplateGroup(String groupName) {
        for (TemplateGroup group : this.myTemplateGroups) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    private void addRow() {
        int selected = this.getSelectedIndex();
        String defaultGroup = "user";
        DefaultMutableTreeNode node = this.getNode(selected);
        if (node != null) {
            if (node.getUserObject() instanceof TemplateImpl) {
                defaultGroup = ((TemplateImpl)node.getUserObject()).getGroupName();
            } else if (node.getUserObject() instanceof TemplateGroup) {
                defaultGroup = ((TemplateGroup)((Object)node.getUserObject())).getName();
            }
        }
        TemplateImpl template = new TemplateImpl("", "", defaultGroup);
        this.myTemplateOptions.put(TemplateListPanel.getKey(template), template.createOptions());
        this.myTemplateContext.put(TemplateListPanel.getKey(template), template.createContext());
        EditTemplateDialog dialog = new EditTemplateDialog(this, CodeInsightBundle.message((String)"dialog.add.live.template.title", (Object[])new Object[0]), template, this.getTemplateGroups(), (String)this.myExpandByCombo.getSelectedItem(), this.getOptions(template), this.getContext(template));
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.apply();
        this.addTemplate(template);
    }

    private static int getKey(TemplateImpl template) {
        return System.identityHashCode(template);
    }

    private void copyRow() {
        int selected = this.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        TemplateImpl orTemplate = this.getTemplate(selected);
        LOG.assertTrue(orTemplate != null);
        TemplateImpl template = orTemplate.copy();
        this.myTemplateOptions.put(TemplateListPanel.getKey(template), this.getOptions(orTemplate));
        this.myTemplateContext.put(TemplateListPanel.getKey(template), this.getContext(orTemplate));
        EditTemplateDialog dialog = new EditTemplateDialog(this, CodeInsightBundle.message((String)"dialog.copy.live.template.title", (Object[])new Object[0]), template, this.getTemplateGroups(), (String)this.myExpandByCombo.getSelectedItem(), this.getOptions(template), this.getContext(template));
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.apply();
        this.addTemplate(template);
    }

    private Map<TemplateContextType, Boolean> getContext(TemplateImpl template) {
        return this.getTemplateContext(template);
    }

    private int getSelectedIndex() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return -1;
        }
        return this.myTree.getRowForPath(selectionPath);
    }

    private void removeRow() {
        int selected = this.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        TemplateKey templateKey = this.getTemplateKey(selected);
        if (templateKey != null) {
            int result = Messages.showOkCancelDialog((Component)this, (String)CodeInsightBundle.message((String)"template.delete.confirmation.text", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"template.delete.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result != 0) {
                return;
            }
            this.removeTemplateAt(selected);
        } else {
            TemplateGroup group = this.getGroup(selected);
            if (group != null) {
                int result = Messages.showOkCancelDialog((Component)this, (String)CodeInsightBundle.message((String)"template.delete.group.confirmation.text", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"template.delete.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result != 0) {
                    return;
                }
                CheckboxTree tree = this.myTree;
                TreePath path = ((JTree)((Object)tree)).getPathForRow(selected);
                this.myTemplateGroups.remove((Object)group);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                this.removeNodeFromParent(node);
            }
        }
    }

    private JScrollPane createTable() {
        this.myTreeRoot = new CheckedTreeNode(null);
        this.myTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if ((value = ((DefaultMutableTreeNode)value).getUserObject()) instanceof TemplateImpl) {
                    this.getTextRenderer().append(((TemplateImpl)value).getKey(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String description = ((TemplateImpl)value).getDescription();
                    if (description != null && description.length() > 0) {
                        this.getTextRenderer().append(" (" + description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else if (value instanceof TemplateGroup) {
                    this.getTextRenderer().append(((TemplateGroup)((Object)value)).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        }, this.myTreeRoot){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                Object obj = node.getUserObject();
                if (obj instanceof TemplateImpl) {
                    ((TemplateImpl)obj).setDeactivated(!node.isChecked());
                }
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
        this.myTree.setSelectionModel(selModel);
        selModel.setSelectionMode(1);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                boolean enableEditButton = false;
                boolean enableRemoveButton = false;
                boolean enableCopyButton = false;
                boolean enableExportButton = false;
                int selected = TemplateListPanel.this.getSelectedIndex();
                if (selected >= 0 && selected < TemplateListPanel.this.myTree.getRowCount()) {
                    TemplateGroup group;
                    TemplateSettings templateSettings = TemplateSettings.getInstance();
                    TemplateImpl template = TemplateListPanel.this.getTemplate(selected);
                    if (template != null) {
                        templateSettings.setLastSelectedTemplateKey(template.getKey());
                    } else {
                        templateSettings.setLastSelectedTemplateKey(null);
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)TemplateListPanel.this.myTree.getPathForRow(selected).getLastPathComponent();
                    enableExportButton = false;
                    enableEditButton = false;
                    enableCopyButton = false;
                    if (node.getUserObject() instanceof TemplateImpl) {
                        enableCopyButton = true;
                        if (template != null && (group = TemplateListPanel.this.getTemplateGroup(template.getGroupName())) != null && !TemplateListPanel.getSchemesManager().isShared((Scheme)group)) {
                            enableEditButton = true;
                            enableRemoveButton = true;
                        }
                    }
                    if (node.getUserObject() instanceof TemplateGroup) {
                        enableRemoveButton = true;
                        group = (TemplateGroup)((Object)node.getUserObject());
                        enableExportButton = !TemplateListPanel.getSchemesManager().isShared((Scheme)group);
                    }
                }
                TemplateListPanel.this.updateTemplateTextArea();
                TemplateListPanel.this.myEditor.getComponent().setEnabled(enableEditButton);
                if (TemplateListPanel.this.myCopyButton != null) {
                    TemplateListPanel.this.myCopyButton.setEnabled(enableCopyButton);
                    TemplateListPanel.this.myEditButton.setEnabled(enableEditButton);
                    TemplateListPanel.this.myRemoveButton.setEnabled(enableRemoveButton);
                }
                if (TemplateListPanel.this.myExportButton != null) {
                    TemplateListPanel.this.myExportButton.setEnabled(enableExportButton);
                }
                if (TemplateListPanel.this.myImportButton != null) {
                    TemplateListPanel.this.myImportButton.setEnabled(true);
                }
            }
        });
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateListPanel.this.addRow();
            }
        }, KeyStroke.getKeyStroke(155, 0), 0);
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateListPanel.this.removeRow();
            }
        }, KeyStroke.getKeyStroke(127, 0), 0);
        this.myTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TemplateListPanel.this.edit();
                }
            }
        });
        JScrollPane scrollpane = ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myTree));
        if (this.myTemplateGroups.size() > 0) {
            this.myTree.setSelectionInterval(0, 0);
        }
        scrollpane.setPreferredSize(new Dimension(600, 400));
        return scrollpane;
    }

    private void updateTemplateTextArea() {
        if (!this.myUpdateNeeded) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                TemplateListPanel.this.updateTemplateText();
            }
        }, 100);
    }

    private void updateTemplateText() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                int selected = TemplateListPanel.this.getSelectedIndex();
                if (selected < 0) {
                    TemplateListPanel.this.myEditor.getDocument().replaceString(0, TemplateListPanel.this.myEditor.getDocument().getTextLength(), (CharSequence)"");
                } else {
                    TemplateImpl template = TemplateListPanel.this.getTemplate(selected);
                    if (template != null) {
                        String text = template.getString();
                        TemplateListPanel.this.myEditor.getDocument().replaceString(0, TemplateListPanel.this.myEditor.getDocument().getTextLength(), (CharSequence)text);
                        TemplateEditorUtil.setHighlighter(TemplateListPanel.this.myEditor, template.getTemplateContext());
                    } else {
                        TemplateListPanel.this.myEditor.getDocument().replaceString(0, TemplateListPanel.this.myEditor.getDocument().getTextLength(), (CharSequence)"");
                    }
                }
            }
        });
    }

    @Nullable
    private DefaultMutableTreeNode addTemplate(TemplateImpl template) {
        TemplateGroup newGroup = this.getTemplateGroup(template.getGroupName());
        if (newGroup == null) {
            newGroup = new TemplateGroup(template.getGroupName());
            this.insertNewGroup(newGroup);
        }
        if (!newGroup.contains(template)) {
            newGroup.addElement(template);
        }
        CheckedTreeNode node = new CheckedTreeNode((Object)template);
        node.setChecked(!template.isDeactivated());
        if (this.myTreeRoot.getChildCount() > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.myTreeRoot.getFirstChild();
            while (child != null) {
                if (((TemplateGroup)((Object)child.getUserObject())).getName().equals(template.getGroupName())) {
                    int index = TemplateListPanel.getIndexToInsert(child, template.getKey());
                    child.insert((MutableTreeNode)node, index);
                    ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted(child, new int[]{index});
                    this.setSelectedNode((DefaultMutableTreeNode)node);
                    return node;
                }
                child = (DefaultMutableTreeNode)this.myTreeRoot.getChildAfter((TreeNode)child);
            }
        }
        return null;
    }

    private void insertNewGroup(TemplateGroup newGroup) {
        this.myTemplateGroups.add(newGroup);
        int index = TemplateListPanel.getIndexToInsert((DefaultMutableTreeNode)this.myTreeRoot, newGroup.getName());
        CheckedTreeNode groupNode = new CheckedTreeNode((Object)newGroup);
        this.myTreeRoot.insert((MutableTreeNode)groupNode, index);
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted((TreeNode)this.myTreeRoot, new int[]{index});
    }

    private static int getIndexToInsert(DefaultMutableTreeNode parent, String key) {
        if (parent.getChildCount() == 0) {
            return 0;
        }
        int res = 0;
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getFirstChild();
        while (child != null) {
            String key1;
            Object o = child.getUserObject();
            String string = key1 = o instanceof TemplateImpl ? ((TemplateImpl)o).getKey() : ((TemplateGroup)((Object)o)).getName();
            if (key1.compareTo(key) > 0) {
                return res;
            }
            ++res;
            child = (DefaultMutableTreeNode)parent.getChildAfter(child);
        }
        return res;
    }

    private void setSelectedNode(DefaultMutableTreeNode node) {
        CheckboxTree tree = this.myTree;
        TreePath path = new TreePath(node.getPath());
        ((JTree)((Object)tree)).expandPath(path.getParentPath());
        int row = ((JTree)((Object)tree)).getRowForPath(path);
        this.myTree.setSelectionInterval(row, row);
    }

    private void removeTemplateAt(int row) {
        DefaultMutableTreeNode parent;
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        LOG.assertTrue(node.getUserObject() instanceof TemplateImpl);
        TemplateImpl template = (TemplateImpl)node.getUserObject();
        TemplateGroup templateGroup = this.getTemplateGroup(template.getGroupName());
        if (templateGroup != null) {
            templateGroup.removeElement(template);
        }
        TreePath treePathToSelect = (parent = (DefaultMutableTreeNode)node.getParent()).getChildAfter(node) != null || parent.getChildCount() == 1 ? ((JTree)((Object)tree)).getPathForRow(row + 1) : ((JTree)((Object)tree)).getPathForRow(row - 1);
        DefaultMutableTreeNode toSelect = treePathToSelect != null ? (DefaultMutableTreeNode)treePathToSelect.getLastPathComponent() : null;
        this.removeNodeFromParent(node);
        if (parent.getChildCount() == 0) {
            this.myTemplateGroups.remove(parent.getUserObject());
            this.removeNodeFromParent(parent);
        }
        if (toSelect != null) {
            this.setSelectedNode(toSelect);
        }
    }

    private void removeNodeFromParent(DefaultMutableTreeNode node) {
        TreeNode parent = node.getParent();
        int idx = parent.getIndex(node);
        node.removeFromParent();
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereRemoved(parent, new int[]{idx}, new TreeNode[]{node});
    }

    private void initTemplates(List<TemplateGroup> groups, String lastSelectedKey) {
        this.myTreeRoot.removeAllChildren();
        this.myTemplateGroups.clear();
        for (TemplateGroup group : groups) {
            this.myTemplateGroups.add((TemplateGroup)group.copy());
        }
        DefaultMutableTreeNode nodeToSelect = null;
        for (TemplateGroup group : this.myTemplateGroups) {
            CheckedTreeNode groupNode = new CheckedTreeNode((Object)group);
            ArrayList templates = new ArrayList(group.getElements());
            Collections.sort(templates, new Comparator<TemplateImpl>(){

                @Override
                public int compare(TemplateImpl o1, TemplateImpl o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            Iterator i$ = templates.iterator();
            while (i$.hasNext()) {
                TemplateImpl groupTemplate;
                TemplateImpl template = groupTemplate = (TemplateImpl)i$.next();
                this.myTemplateOptions.put(TemplateListPanel.getKey(template), template.createOptions());
                this.myTemplateContext.put(TemplateListPanel.getKey(template), template.createContext());
                CheckedTreeNode node = new CheckedTreeNode((Object)template);
                node.setChecked(!template.isDeactivated());
                groupNode.add((MutableTreeNode)node);
                if (lastSelectedKey == null || !lastSelectedKey.equals(template.getKey())) continue;
                nodeToSelect = node;
            }
            this.myTreeRoot.add((MutableTreeNode)groupNode);
        }
        ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged((TreeNode)this.myTreeRoot);
        if (nodeToSelect != null) {
            CheckboxTree tree = this.myTree;
            TreePath path = new TreePath(nodeToSelect.getPath());
            ((JTree)((Object)tree)).expandPath(path.getParentPath());
            int rowToSelect = ((JTree)((Object)tree)).getRowForPath(path);
            this.myTree.setSelectionInterval(rowToSelect, rowToSelect);
        }
    }

    class ActivationStateColumnInfo
    extends ColumnInfo {
        public ActivationStateColumnInfo(String name) {
            super(name);
        }

        public boolean isCellEditable(Object o) {
            return o != null;
        }

        public void setValue(Object obj, Object aValue) {
            if ((obj = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof TemplateImpl) {
                boolean state;
                TemplateImpl template = (TemplateImpl)obj;
                boolean bl = state = (Boolean)aValue == false;
                if (state != template.isDeactivated()) {
                    template.setDeactivated((Boolean)aValue == false);
                }
            }
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Object valueOf(Object object) {
            if ((object = ((DefaultMutableTreeNode)object).getUserObject()) instanceof TemplateImpl) {
                return ((TemplateImpl)object).isDeactivated() ? Boolean.FALSE : Boolean.TRUE;
            }
            return null;
        }
    }

    private static class TemplateKey
    implements Comparable {
        private final String myKey;
        private final String myGroupName;

        public TemplateKey(TemplateImpl template) {
            String key = template.getKey();
            if (key == null) {
                key = "";
            }
            this.myKey = key;
            String groupName = template.getGroupName();
            if (groupName == null) {
                groupName = "";
            }
            this.myGroupName = groupName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TemplateKey)) {
                return false;
            }
            TemplateKey templateKey = (TemplateKey)obj;
            return this.myGroupName.compareTo(templateKey.myGroupName) == 0 && this.myKey.compareTo(templateKey.myKey) == 0;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof TemplateKey)) {
                return 1;
            }
            TemplateKey templateKey = (TemplateKey)obj;
            int result = this.myGroupName.compareTo(templateKey.myGroupName);
            return result != 0 ? result : this.myKey.compareTo(templateKey.myKey);
        }
    }
}

