/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public class ColorUtil {
    private ColorUtil() {
    }

    public static String toHex(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/javadoc/ColorUtil.toHex must not be null");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            String s = Integer.toHexString(i == 0 ? color.getRed() : (i == 1 ? color.getGreen() : color.getBlue()));
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String generatePreviewHtml(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/javadoc/ColorUtil.generatePreviewHtml must not be null");
        }
        return String.format("<div style=\"width: 50px; height: 30px; background-color: #%s; border: 1px solid #222;\">&nbsp;</div>", ColorUtil.toHex(color));
    }

    public static void appendColorPreview(PsiVariable variable, StringBuilder buffer) {
        PsiType type;
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (type = initializer.getType()) != null && "java.awt.Color".equals(type.getCanonicalText())) {
            PsiClass psiClass;
            PsiElement psiElement;
            PsiReference reference;
            if (initializer instanceof PsiNewExpression) {
                PsiExpressionList argumentList = ((PsiNewExpression)initializer).getArgumentList();
                if (argumentList != null) {
                    PsiExpression[] expressions = argumentList.getExpressions();
                    int[] values = ArrayUtil.newIntArray((int)expressions.length);
                    float[] values2 = new float[expressions.length];
                    int i = 0;
                    int j = 0;
                    PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)initializer.getProject()).getConstantEvaluationHelper();
                    for (PsiExpression each : expressions) {
                        Object o = helper.computeConstantExpression((PsiElement)each);
                        if (o instanceof Integer) {
                            values[i] = (Integer)o;
                            values[i] = values[i] > 255 ? 255 : (values[i] < 0 ? 0 : values[i]);
                            ++i;
                            continue;
                        }
                        if (!(o instanceof Float)) continue;
                        values2[j] = ((Float)o).floatValue();
                        values2[j] = values2[j] > 1.0f ? 1.0f : (values2[j] < 0.0f ? 0.0f : values2[j]);
                        ++j;
                    }
                    Color c = null;
                    if (i == expressions.length) {
                        switch (values.length) {
                            case 1: {
                                c = new Color(values[0]);
                                break;
                            }
                            case 3: {
                                c = new Color(values[0], values[1], values[2]);
                                break;
                            }
                            case 4: {
                                c = new Color(values[0], values[1], values[2], values[3]);
                                break;
                            }
                        }
                    } else if (j == expressions.length) {
                        switch (values2.length) {
                            case 3: {
                                c = new Color(values2[0], values2[1], values2[2]);
                                break;
                            }
                            case 4: {
                                c = new Color(values2[0], values2[1], values2[2], values2[3]);
                                break;
                            }
                        }
                    }
                    if (c != null) {
                        buffer.append(ColorUtil.generatePreviewHtml(c));
                    }
                }
            } else if (initializer instanceof PsiReferenceExpression && (reference = initializer.getReference()) != null && (psiElement = reference.resolve()) instanceof PsiField && (psiClass = ((PsiField)psiElement).getContainingClass()) != null && "java.awt.Color".equals(psiClass.getQualifiedName())) {
                try {
                    Field field = Class.forName("java.awt.Color").getField(((PsiField)psiElement).getName());
                    Color c = (Color)field.get(null);
                    buffer.append(ColorUtil.generatePreviewHtml(c));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

