/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlParameterInfoHandler
implements ParameterInfoHandler<XmlTag, XmlElementDescriptor> {
    private static final Comparator<XmlAttributeDescriptor> COMPARATOR = new Comparator<XmlAttributeDescriptor>(){

        @Override
        public int compare(XmlAttributeDescriptor o1, XmlAttributeDescriptor o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object lookupItem = item.getObject();
        if (lookupItem instanceof XmlElementDescriptor) {
            return new Object[]{lookupItem};
        }
        return null;
    }

    public Object[] getParametersForDocumentation(XmlElementDescriptor p, ParameterInfoContext context) {
        return XmlParameterInfoHandler.getSortedDescriptors(p);
    }

    public static XmlAttributeDescriptor[] getSortedDescriptors(XmlElementDescriptor p) {
        XmlAttributeDescriptor[] xmlAttributeDescriptors = p.getAttributesDescriptors(null);
        Arrays.sort(xmlAttributeDescriptors, COMPARATOR);
        return xmlAttributeDescriptors;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    public XmlTag findElementForParameterInfo(CreateParameterInfoContext context) {
        XmlElementDescriptor descriptor;
        XmlTag tag = XmlParameterInfoHandler.findXmlTag(context.getFile(), context.getOffset());
        XmlElementDescriptor xmlElementDescriptor = descriptor = tag != null ? tag.getDescriptor() : null;
        if (descriptor == null) {
            DaemonCodeAnalyzer.getInstance((Project)context.getProject()).updateVisibleHighlighters(context.getEditor());
            return null;
        }
        context.setItemsToShow(new Object[]{descriptor});
        return tag;
    }

    public void showParameterInfo(@NotNull XmlTag element, CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler.showParameterInfo must not be null");
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    public XmlTag findElementForUpdatingParameterInfo(UpdateParameterInfoContext context) {
        PsiElement currentXmlTag;
        XmlTag tag = XmlParameterInfoHandler.findXmlTag(context.getFile(), context.getOffset());
        if (tag != null && ((currentXmlTag = context.getParameterOwner()) == null || currentXmlTag == tag)) {
            return tag;
        }
        return null;
    }

    public void updateParameterInfo(@NotNull XmlTag o, UpdateParameterInfoContext context) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler.updateParameterInfo must not be null");
        }
        if (context.getParameterOwner() == null || o.equals(context.getParameterOwner())) {
            context.setParameterOwner((PsiElement)o);
        } else {
            context.removeHint();
        }
    }

    public String getParameterCloseChars() {
        return null;
    }

    public boolean tracksParameterIndex() {
        return false;
    }

    @Nullable
    private static XmlTag findXmlTag(PsiFile file, int offset) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (!(element instanceof XmlTag)) continue;
            XmlTag tag = (XmlTag)element;
            PsiElement[] children = tag.getChildren();
            if (offset <= children[0].getTextRange().getStartOffset()) {
                return null;
            }
            for (PsiElement child : children) {
                XmlToken token;
                TextRange range = child.getTextRange();
                if (range.getStartOffset() <= offset && range.getEndOffset() > offset) {
                    return tag;
                }
                if (!(child instanceof XmlToken) || (token = (XmlToken)child).getTokenType() != XmlTokenType.XML_TAG_END) continue;
                return null;
            }
            return null;
        }
        return null;
    }

    public void updateUI(XmlElementDescriptor o, final ParameterInfoUIContext context) {
        XmlParameterInfoHandler.updateElementDescriptor(o, context, new Function<String, Boolean>(){
            final XmlTag parameterOwner;
            {
                this.parameterOwner = (XmlTag)context.getParameterOwner();
            }

            public Boolean fun(String s) {
                return this.parameterOwner != null ? this.parameterOwner.getAttributeValue(s) != null : false;
            }
        });
    }

    public static void updateElementDescriptor(XmlElementDescriptor descriptor, ParameterInfoUIContext context, Function<String, Boolean> attributePresentFun) {
        XmlAttributeDescriptor[] attributes = descriptor != null ? XmlParameterInfoHandler.getSortedDescriptors(descriptor) : XmlAttributeDescriptor.EMPTY;
        StringBuffer buffer = new StringBuffer();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (attributes.length == 0) {
            buffer.append(CodeInsightBundle.message((String)"xml.tag.info.no.attributes", (Object[])new Object[0]));
        } else {
            StringBuffer text1 = new StringBuffer(" ");
            StringBuffer text2 = new StringBuffer(" ");
            StringBuffer text3 = new StringBuffer(" ");
            for (XmlAttributeDescriptor attribute : attributes) {
                if (Boolean.TRUE.equals(attributePresentFun.fun((Object)attribute.getName()))) {
                    if (!text1.toString().equals(" ")) {
                        text1.append(", ");
                    }
                    text1.append(attribute.getName());
                    continue;
                }
                if (attribute.isRequired()) {
                    if (!text2.toString().equals(" ")) {
                        text2.append(", ");
                    }
                    text2.append(attribute.getName());
                    continue;
                }
                if (!text3.toString().equals(" ")) {
                    text3.append(", ");
                }
                text3.append(attribute.getName());
            }
            if (!text1.toString().equals(" ") && !text2.toString().equals(" ")) {
                text1.append(", ");
            }
            if (!text2.toString().equals(" ") && !text3.toString().equals(" ")) {
                text2.append(", ");
            }
            if (!text1.toString().equals(" ") && !text3.toString().equals(" ") && text2.toString().equals(" ")) {
                text1.append(", ");
            }
            buffer.append(text1);
            highlightStartOffset = buffer.length();
            buffer.append(text2);
            highlightEndOffset = buffer.length();
            buffer.append(text3);
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, false, true, context.getDefaultParameterColor());
    }
}

