/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoContext
implements CreateParameterInfoContext {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final Project myProject;
    private final int myOffset;
    private final int myParameterListStart;
    private PsiElement myHighlightedElement;
    private Object[] myItems;

    public ShowParameterInfoContext(Editor editor, Project project, PsiFile file, int offset, int parameterListStart) {
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = file;
        this.myParameterListStart = parameterListStart;
        this.myOffset = offset;
    }

    public Project getProject() {
        return this.myProject;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getParameterListStart() {
        return this.myParameterListStart;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/ShowParameterInfoContext.getEditor must not return null");
        }
        return editor;
    }

    public PsiElement getHighlightedElement() {
        return this.myHighlightedElement;
    }

    public void setHighlightedElement(PsiElement element) {
        this.myHighlightedElement = element;
    }

    public void setItemsToShow(Object[] items) {
        this.myItems = items;
    }

    public Object[] getItemsToShow() {
        return this.myItems;
    }

    public void showHint(PsiElement element, int offset, ParameterInfoHandler handler) {
        Object[] itemsToShow = this.getItemsToShow();
        if (itemsToShow == null || itemsToShow.length == 0) {
            return;
        }
        ShowParameterInfoContext.showMethodInfo(this.getProject(), this.getEditor(), element, this.getHighlightedElement(), itemsToShow, offset, handler);
    }

    private static void showParameterHint(PsiElement element, final Editor editor, Object[] descriptors, final Project project, final ShowParameterInfoHandler.BestLocationPointProvider provider, @Nullable PsiElement highlighted, final int elementStart, final ParameterInfoHandler handler) {
        if (ParameterInfoController.isAlreadyShown(editor, elementStart)) {
            return;
        }
        if (editor.isDisposed()) {
            return;
        }
        ParameterInfoComponent component = new ParameterInfoComponent(descriptors, editor, handler);
        component.setParameterOwner(element);
        if (highlighted != null) {
            component.setHighlightedParameter(highlighted);
        }
        component.update();
        final LightweightHint hint = new LightweightHint(component);
        hint.setSelectingHint(true);
        final HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        final Point p = provider.getBestPointPosition(hint, element, elementStart);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                hintManager.showEditorHint(hint, editor, p, 129, 0, false);
                new ParameterInfoController(project, editor, elementStart, hint, handler, provider);
            }
        });
    }

    private static void showMethodInfo(Project project, Editor editor, PsiElement list, PsiElement highlighted, Object[] candidates, int offset, ParameterInfoHandler handler) {
        ShowParameterInfoContext.showParameterHint(list, editor, candidates, project, new MyBestLocationPointProvider(editor), (PsiElement)(candidates.length > 1 ? highlighted : null), offset, handler);
    }

    static Point chooseBestHintPosition(Project project, Editor editor, int line, int col, LightweightHint hint) {
        int underSpace;
        int aboveSpace;
        boolean p2Ok;
        Point p2;
        Point p1;
        boolean isLookupShown;
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        boolean bl = isLookupShown = LookupManager.getInstance(project).getActiveLookup() != null;
        if (isLookupShown) {
            p1 = hintManager.getHintPosition(hint, editor, (short)2);
            p2 = hintManager.getHintPosition(hint, editor, (short)1);
        } else {
            LogicalPosition pos = new LogicalPosition(line, col);
            p1 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)2);
            p2 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)1);
        }
        p1.x = Math.min(p1.x, layeredPane.getWidth() - hintSize.width);
        p1.x = Math.max(p1.x, 0);
        p2.x = Math.min(p2.x, layeredPane.getWidth() - hintSize.width);
        p2.x = Math.max(p2.x, 0);
        boolean p1Ok = p1.y + hintSize.height < layeredPane.getHeight();
        boolean bl2 = p2Ok = p2.y >= 0;
        if (isLookupShown) {
            if (p2Ok) {
                return p2;
            }
            if (p1Ok) {
                return p1;
            }
        } else {
            if (p1Ok) {
                return p1;
            }
            if (p2Ok) {
                return p2;
            }
        }
        return (aboveSpace = p2.y) > (underSpace = layeredPane.getHeight() - p1.y) ? new Point(p2.x, 0) : p1;
    }

    static class MyBestLocationPointProvider
    implements ShowParameterInfoHandler.BestLocationPointProvider {
        private final Editor myEditor;
        private int previousOffset = -1;
        private Point previousBestPoint;

        public MyBestLocationPointProvider(Editor editor) {
            this.myEditor = editor;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Point getBestPointPosition(LightweightHint hint, PsiElement list, int offset) {
            Point p;
            Point point;
            TextRange textRange = list.getTextRange();
            int n = offset = textRange.contains(offset) ? offset : textRange.getStartOffset() + 1;
            if (this.previousOffset == offset) {
                point = this.previousBestPoint;
                if (point == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/ShowParameterInfoContext$MyBestLocationPointProvider.getBestPointPosition must not return null");
                return point;
            }
            String listText = list.getText();
            boolean isMultiline = listText.indexOf(10) >= 0 || listText.indexOf(13) >= 0;
            LogicalPosition pos = this.myEditor.offsetToLogicalPosition(offset);
            if (!isMultiline) {
                p = ShowParameterInfoContext.chooseBestHintPosition(this.myEditor.getProject(), this.myEditor, pos.line, pos.column, hint);
            } else {
                p = HintManagerImpl.getHintPosition(hint, this.myEditor, pos, (short)1);
                Dimension hintSize = hint.getComponent().getPreferredSize();
                JComponent editorComponent = this.myEditor.getComponent();
                JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
                p.x = Math.min(p.x, layeredPane.getWidth() - hintSize.width);
                p.x = Math.max(p.x, 0);
            }
            this.previousBestPoint = p;
            this.previousOffset = offset;
            point = p;
            if (point != null) return point;
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/ShowParameterInfoContext$MyBestLocationPointProvider.getBestPointPosition must not return null");
        }
    }
}

