/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ElementLocationUtil {
    public static final Icon LIB_ICON_CLOSED = IconLoader.getIcon((String)"/nodes/ppLibClosed.png");

    private ElementLocationUtil() {
    }

    public static void customizeElementLabel(PsiElement element, JLabel label) {
        if (element != null) {
            VirtualFile vfile;
            PsiFile file = element.getContainingFile();
            VirtualFile virtualFile = vfile = file == null ? null : file.getVirtualFile();
            if (vfile == null) {
                label.setText("");
                label.setIcon(null);
                return;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
            Module module = fileIndex.getModuleForFile(vfile);
            if (module != null) {
                label.setText(module.getName());
                label.setIcon(module.getModuleType().getNodeIcon(false));
            } else {
                List entries = fileIndex.getOrderEntriesForFile(vfile);
                OrderEntry entry = null;
                for (OrderEntry order : entries) {
                    if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                    entry = order;
                    break;
                }
                if (entry != null) {
                    label.setText(entry.getPresentableName());
                    label.setIcon(LIB_ICON_CLOSED);
                }
            }
        }
    }
}

