/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfExpressionSurrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

public class JavaWithIfElseExpressionSurrounder
extends JavaWithIfExpressionSurrounder {
    @Override
    public TextRange surroundExpression(Project project, Editor editor, PsiExpression expr) throws IncorrectOperationException {
        PsiManager manager = expr.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        String text = "if(a){\nst;\n}else{\n}";
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(text, null);
        ifStatement = (PsiIfStatement)codeStyleManager.reformat((PsiElement)ifStatement);
        ifStatement.getCondition().replace((PsiElement)expr);
        PsiExpressionStatement statement = (PsiExpressionStatement)expr.getParent();
        ifStatement = (PsiIfStatement)statement.replace((PsiElement)ifStatement);
        PsiCodeBlock block = ((PsiBlockStatement)ifStatement.getThenBranch()).getCodeBlock();
        PsiStatement afterStatement = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(block.getStatements()[0]);
        TextRange range = afterStatement.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        return new TextRange(range.getStartOffset(), range.getStartOffset());
    }

    @Override
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.ifelse.expression.template", (Object[])new Object[0]);
    }
}

