/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDelegateHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateDelegateHandler");

    public void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateDelegateHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateDelegateHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateDelegateHandler.invoke must not be null");
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final PsiElement target = GenerateDelegateHandler.chooseTarget(file, editor, project);
        if (target == null) {
            return;
        }
        final PsiMethodMember[] candidates = GenerateDelegateHandler.chooseMethods(target, file, editor, project);
        if (candidates == null || candidates.length == 0) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    int offset = editor.getCaretModel().getOffset();
                    ArrayList<PsiGenerationInfo> prototypes = new ArrayList<PsiGenerationInfo>(candidates.length);
                    for (PsiMethodMember candidate : candidates) {
                        prototypes.add(GenerateDelegateHandler.generateDelegatePrototype(candidate, target));
                    }
                    List results = GenerateMembersUtil.insertMembersAtOffset(file, offset, prototypes);
                    if (!results.isEmpty()) {
                        PsiMethod firstMethod = (PsiMethod)((PsiGenerationInfo)results.get(0)).getPsiMember();
                        PsiCodeBlock block = firstMethod.getBody();
                        assert (block != null);
                        PsiElement first = block.getFirstBodyElement();
                        assert (first != null);
                        editor.getCaretModel().moveToOffset(first.getTextRange().getStartOffset());
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().removeSelection();
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static PsiGenerationInfo<PsiMethod> generateDelegatePrototype(PsiMethodMember methodCandidate, PsiElement target) throws IncorrectOperationException {
        PsiMethod method = GenerateMembersUtil.substituteGenericMethod((PsiMethod)methodCandidate.getElement(), methodCandidate.getSubstitutor());
        GenerateDelegateHandler.clearMethod(method);
        GenerateDelegateHandler.clearModifiers(method);
        StringBuffer call = new StringBuffer();
        PsiModifierList modifierList = null;
        if (method.getReturnType() != PsiType.VOID) {
            call.append("return ");
        }
        if (target instanceof PsiField) {
            PsiParameter[] parameters;
            PsiField field = (PsiField)target;
            modifierList = field.getModifierList();
            String name = field.getName();
            for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                if (!name.equals(parameter.getName())) continue;
                call.append("this.");
                break;
            }
            call.append(name);
            call.append(".");
        } else if (target instanceof PsiMethod) {
            PsiMethod m = (PsiMethod)target;
            modifierList = m.getModifierList();
            call.append(m.getName());
            call.append("().");
        }
        call.append(method.getName());
        call.append("(");
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int j = 0; j < parameters.length; ++j) {
            PsiParameter parameter = parameters[j];
            if (j > 0) {
                call.append(",");
            }
            call.append(parameter.getName());
        }
        call.append(");");
        PsiManager psiManager = method.getManager();
        PsiStatement stmt = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText(call.toString(), (PsiElement)method);
        stmt = (PsiStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)stmt);
        method.getBody().add((PsiElement)stmt);
        if (modifierList != null && modifierList.hasModifierProperty("static")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        Project project = method.getProject();
        for (PsiAnnotation annotation : ((PsiMethod)methodCandidate.getElement()).getModifierList().getAnnotations()) {
            GenerateDelegateHandler.annotate(method, project, annotation.getQualifiedName());
        }
        PsiClass targetClass = ((PsiMember)target).getContainingClass();
        LOG.assertTrue(targetClass != null);
        PsiMethod[] methods = targetClass.findMethodsBySignature(method, true);
        boolean insertOverride = false;
        for (PsiMethod superMethod : methods) {
            if (!OverrideImplementUtil.isInsertOverride(superMethod, targetClass)) continue;
            insertOverride = true;
            break;
        }
        if (insertOverride) {
            GenerateDelegateHandler.annotate(method, project, Override.class.getName());
        }
        return new PsiGenerationInfo<PsiMethod>(method);
    }

    private static void annotate(PsiMethod method, Project project, String qualifiedName) {
        AddAnnotationFix fix = new AddAnnotationFix(qualifiedName, (PsiModifierListOwner)method, new String[0]);
        if (fix.isAvailable(project, null, method.getContainingFile())) {
            fix.invoke(project, null, method.getContainingFile());
        }
    }

    private static void clearMethod(PsiMethod method) throws IncorrectOperationException {
        LOG.assertTrue(!method.isPhysical());
        PsiCodeBlock codeBlock = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createCodeBlock();
        if (method.getBody() != null) {
            method.getBody().replace((PsiElement)codeBlock);
        } else {
            method.add((PsiElement)codeBlock);
        }
        PsiDocComment docComment = method.getDocComment();
        if (docComment != null) {
            docComment.delete();
        }
    }

    private static void clearModifiers(PsiMethod method) throws IncorrectOperationException {
        PsiElement[] children;
        for (PsiElement child : children = method.getModifierList().getChildren()) {
            if (!(child instanceof PsiKeyword)) continue;
            child.delete();
        }
    }

    @Nullable
    private static PsiMethodMember[] chooseMethods(PsiElement target, PsiFile file, Editor editor, Project project) {
        PsiMethodMember[] result;
        PsiClassType.ClassResolveResult resolveResult = null;
        if (target instanceof PsiField) {
            resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)((PsiField)target).getType());
        } else if (target instanceof PsiMethod) {
            resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)((PsiMethod)target).getReturnType());
        }
        if (resolveResult == null || resolveResult.getElement() == null) {
            return null;
        }
        PsiClass targetClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (aClass == null) {
            return null;
        }
        ArrayList<PsiMethodMember> methodInstances = new ArrayList<PsiMethodMember>();
        PsiMethod[] allMethods = targetClass.getAllMethods();
        HashSet signatures = new HashSet();
        HashMap superSubstitutors = new HashMap();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)target.getProject());
        for (PsiMethod method : allMethods) {
            PsiSubstitutor methodSubstitutor;
            MethodSignature signature;
            PsiClass superClass = method.getContainingClass();
            if ("java.lang.Object".equals(superClass.getQualifiedName()) || method.isConstructor()) continue;
            PsiSubstitutor superSubstitutor = (PsiSubstitutor)superSubstitutors.get(superClass);
            if (superSubstitutor == null) {
                superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)targetClass, (PsiSubstitutor)substitutor);
                superSubstitutors.put(superClass, superSubstitutor);
            }
            if (signatures.contains(signature = method.getSignature(methodSubstitutor = GenerateMembersUtil.correctSubstitutor(method, superSubstitutor)))) continue;
            signatures.add(signature);
            if (!facade.getResolveHelper().isAccessible((PsiMember)method, target, aClass)) continue;
            methodInstances.add(new PsiMethodMember(method, methodSubstitutor));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser((ClassMember[])methodInstances.toArray(new PsiMethodMember[methodInstances.size()]), false, true, project);
            chooser.setTitle(CodeInsightBundle.message((String)"generate.delegate.method.chooser.title", (Object[])new Object[0]));
            chooser.setCopyJavadocVisible(false);
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            List<PsiMethodMember> list = chooser.getSelectedElements();
            result = list.toArray(new PsiMethodMember[list.size()]);
        } else {
            result = new PsiMethodMember[]{(PsiMethodMember)methodInstances.get(0)};
        }
        return result;
    }

    public static boolean isApplicable(PsiFile file, Editor editor) {
        PsiElementClassMember[] targetElements = GenerateDelegateHandler.getTargetElements(file, editor);
        return targetElements != null && targetElements.length > 0;
    }

    @Nullable
    private static PsiElement chooseTarget(PsiFile file, Editor editor, Project project) {
        PsiElement target = null;
        ClassMember[] targetElements = GenerateDelegateHandler.getTargetElements(file, editor);
        if (targetElements == null || targetElements.length == 0) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser(targetElements, false, false, project);
            chooser.setTitle(CodeInsightBundle.message((String)"generate.delegate.target.chooser.title", (Object[])new Object[0]));
            chooser.setCopyJavadocVisible(false);
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            List selectedElements = chooser.getSelectedElements();
            if (selectedElements != null && selectedElements.size() > 0) {
                target = (PsiElement)((PsiElementClassMember)selectedElements.get(0)).getElement();
            }
        } else {
            target = (PsiElement)targetElements[0].getElement();
        }
        return target;
    }

    @Nullable
    private static PsiElementClassMember[] getTargetElements(PsiFile file, Editor editor) {
        PsiMethod[] methods;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (aClass == null) {
            return null;
        }
        ArrayList<PsiElementClassMember> result = new ArrayList<PsiElementClassMember>();
        PsiField[] fields = aClass.getAllFields();
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        for (PsiField field : fields) {
            PsiType type = field.getType();
            if (!helper.isAccessible((PsiMember)field, (PsiElement)aClass, aClass) || !(type instanceof PsiClassType)) continue;
            result.add(new PsiFieldMember(field));
        }
        for (PsiMethod method : methods = aClass.getAllMethods()) {
            PsiType returnType;
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || (returnType = method.getReturnType()) == null || !PropertyUtil.isSimplePropertyGetter((PsiMethod)method) || !helper.isAccessible((PsiMember)method, (PsiElement)aClass, aClass) || !(returnType instanceof PsiClassType)) continue;
            result.add(new PsiMethodMember(method));
        }
        return result.toArray(new PsiElementClassMember[result.size()]);
    }
}

