/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateConstructorHandler
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateConstructorHandler");
    private boolean myCopyJavadoc;

    public GenerateConstructorHandler() {
        super(CodeInsightBundle.message((String)"generate.constructor.fields.chooser.title", (Object[])new Object[0]));
    }

    @Override
    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        PsiField[] fields = aClass.getFields();
        ArrayList<PsiFieldMember> array = new ArrayList<PsiFieldMember>();
        ImplicitUsageProvider[] implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME);
        block0: for (PsiField field : fields) {
            if (field.hasModifierProperty("static") || field.hasModifierProperty("final") && field.getInitializer() != null) continue;
            for (ImplicitUsageProvider provider : implicitUsageProviders) {
                if (provider.isImplicitWrite((PsiElement)field)) continue block0;
            }
            array.add(new PsiFieldMember(field));
        }
        return array.toArray(new ClassMember[array.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        ClassMember[] members;
        ClassMember[] allMembers;
        if (aClass instanceof PsiAnonymousClass) {
            Messages.showMessageDialog((Project)project, (String)CodeInsightBundle.message((String)"error.attempt.to.generate.constructor.for.anonymous.class", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return null;
        }
        this.myCopyJavadoc = false;
        PsiMethod[] baseConstructors = null;
        PsiClass baseClass = aClass.getSuperClass();
        if (baseClass != null) {
            PsiMethod[] methods;
            ArrayList<PsiMethod> array = new ArrayList<PsiMethod>();
            for (PsiMethod method : methods = baseClass.getMethods()) {
                if (!method.isConstructor() || !JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper().isAccessible((PsiMember)method, (PsiElement)aClass, aClass)) continue;
                array.add(method);
            }
            if (array.size() > 0) {
                if (array.size() == 1) {
                    baseConstructors = new PsiMethod[]{(PsiMethod)array.get(0)};
                } else {
                    void var11_16;
                    final PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    ClassMember[] constructors = (PsiMethodMember[])ContainerUtil.map2Array(array, PsiMethodMember.class, (Function)new Function<PsiMethod, PsiMethodMember>(){

                        public PsiMethodMember fun(PsiMethod s) {
                            return new PsiMethodMember(s, substitutor);
                        }
                    });
                    MemberChooser chooser = new MemberChooser(constructors, false, true, project);
                    chooser.setTitle(CodeInsightBundle.message((String)"generate.constructor.super.constructor.chooser.title", (Object[])new Object[0]));
                    chooser.show();
                    List elements = chooser.getSelectedElements();
                    if (elements == null || elements.size() == 0) {
                        return null;
                    }
                    baseConstructors = new PsiMethod[elements.size()];
                    boolean bl = false;
                    while (var11_16 < elements.size()) {
                        ClassMember member = (ClassMember)elements.get((int)var11_16);
                        baseConstructors[var11_16] = (PsiMethod)((PsiMethodMember)member).getElement();
                        ++var11_16;
                    }
                    this.myCopyJavadoc = chooser.isCopyJavadoc();
                }
            }
        }
        if ((allMembers = this.getAllOriginalMembers(aClass)).length == 0) {
            members = ClassMember.EMPTY_ARRAY;
        } else {
            members = this.chooseMembers(allMembers, true, false, project);
            if (members == null) {
                return null;
            }
        }
        if (baseConstructors != null) {
            ArrayList<ClassMember> array = new ArrayList<ClassMember>();
            for (void var11_17 : baseConstructors) {
                array.add(new PsiMethodMember((PsiMethod)var11_17));
            }
            array.addAll(Arrays.asList(members));
            members = array.toArray(new ClassMember[array.size()]);
        }
        return members;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        List<PsiGenerationInfo<PsiMethod>> list;
        ArrayList<PsiMethod> baseConstructors = new ArrayList<PsiMethod>();
        ArrayList fieldsVector = new ArrayList();
        for (ClassMember member1 : members) {
            Object member = ((PsiElementClassMember)member1).getElement();
            if (member instanceof PsiMethod) {
                baseConstructors.add((PsiMethod)member);
                continue;
            }
            fieldsVector.add(member);
        }
        PsiField[] fields = fieldsVector.toArray(new PsiField[fieldsVector.size()]);
        if (!baseConstructors.isEmpty()) {
            ArrayList<PsiGenerationInfo<PsiMethod>> constructors = new ArrayList<PsiGenerationInfo<PsiMethod>>(baseConstructors.size());
            PsiClass superClass = aClass.getSuperClass();
            assert (superClass != null);
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            for (PsiMethod baseConstructor : baseConstructors) {
                if (substitutor != PsiSubstitutor.EMPTY) {
                    baseConstructor = GenerateMembersUtil.substituteGenericMethod(baseConstructor, substitutor);
                }
                constructors.add(new PsiGenerationInfo<PsiMethod>(GenerateConstructorHandler.generateConstructorPrototype(aClass, baseConstructor, this.myCopyJavadoc, fields)));
            }
            list = constructors;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateConstructorHandler.generateMemberPrototypes must not return null");
            return list;
        }
        list = Collections.singletonList(new PsiGenerationInfo<PsiMethod>(GenerateConstructorHandler.generateConstructorPrototype(aClass, null, false, fields)));
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateConstructorHandler.generateMemberPrototypes must not return null");
    }

    public static PsiMethod generateConstructorPrototype(PsiClass aClass, PsiMethod baseConstructor, boolean copyJavaDoc, PsiField[] fields) throws IncorrectOperationException {
        PsiManager manager = aClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        PsiMethod constructor = factory.createConstructor();
        String modifier = GenerateConstructorHandler.getConstructorModifier(aClass);
        if (modifier != null) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)modifier, (boolean)true);
        }
        if (baseConstructor != null) {
            PsiDocComment docComment;
            PsiJavaCodeReferenceElement[] throwRefs;
            for (PsiJavaCodeReferenceElement ref : throwRefs = baseConstructor.getThrowsList().getReferenceElements()) {
                constructor.getThrowsList().add((PsiElement)ref);
            }
            if (copyJavaDoc && (docComment = ((PsiMethod)baseConstructor.getNavigationElement()).getDocComment()) != null) {
                constructor.addAfter((PsiElement)docComment, null);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("{\n");
        if (baseConstructor != null) {
            PsiClass superClass = aClass.getSuperClass();
            LOG.assertTrue(superClass != null);
            if (!"java.lang.Enum".equals(superClass.getQualifiedName())) {
                PsiParameter[] parms;
                if (baseConstructor instanceof PsiCompiledElement) {
                    PsiClass dummyClass = factory.createClass("Dummy");
                    baseConstructor = (PsiMethod)dummyClass.add((PsiElement)baseConstructor);
                }
                for (PsiParameter parm : parms = baseConstructor.getParameterList().getParameters()) {
                    constructor.getParameterList().add((PsiElement)parm);
                }
                if (parms.length > 0) {
                    buffer.append("super(");
                    for (int j = 0; j < parms.length; ++j) {
                        PsiParameter parm = parms[j];
                        if (j > 0) {
                            buffer.append(",");
                        }
                        buffer.append(parm.getName());
                    }
                    buffer.append(");\n");
                }
            }
        }
        JavaCodeStyleManager javaStyle = JavaCodeStyleManager.getInstance((Project)aClass.getProject());
        for (PsiField field : fields) {
            String fieldName = field.getName();
            String name = javaStyle.variableNameToPropertyName(fieldName, VariableKind.FIELD);
            String parmName = javaStyle.propertyNameToVariableName(name, VariableKind.PARAMETER);
            PsiParameter parm = factory.createParameter(parmName, field.getType());
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (String)"org.jetbrains.annotations.NotNull", (boolean)false)) {
                PsiAnnotation annotation = factory.createAnnotationFromText("@org.jetbrains.annotations.NotNull", (PsiElement)field);
                parm.getModifierList().addAfter((PsiElement)annotation, null);
            }
            constructor.getParameterList().add((PsiElement)parm);
            if (fieldName.equals(parmName)) {
                buffer.append("this.");
            }
            buffer.append(fieldName);
            buffer.append("=");
            buffer.append(parmName);
            buffer.append(";\n");
        }
        buffer.append("}");
        PsiCodeBlock body = factory.createCodeBlockFromText(buffer.toString(), null);
        constructor.getBody().replace((PsiElement)body);
        constructor = (PsiMethod)codeStyleManager.reformat((PsiElement)constructor);
        return constructor;
    }

    @Modifier
    @Nullable
    private static String getConstructorModifier(PsiClass aClass) {
        String modifier = "public";
        if (aClass.hasModifierProperty("abstract")) {
            modifier = "protected";
        } else if (aClass.hasModifierProperty("packageLocal")) {
            modifier = "packageLocal";
        } else if (aClass.hasModifierProperty("private")) {
            modifier = "private";
        }
        return modifier;
    }

    @Override
    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) {
        LOG.assertTrue(false);
        return null;
    }
}

