/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.JavadocAutoLookupHandler;
import com.intellij.codeInsight.editorActions.JavaTypedHandlerUtil;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.position.SuperParentFilter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.Nullable;

public class JavaTypedHandler
extends TypedHandlerDelegate {
    private boolean myJavaLTTyped;

    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        if (charTyped == '@' && file instanceof PsiJavaFile) {
            JavaTypedHandler.autoPopupJavadocLookup(project, editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (charTyped == '#' || charTyped == '.') {
            AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, new MemberAutoLookupCondition());
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        FileType originalFileType = JavaTypedHandler.getOriginalFileType(file);
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && file instanceof PsiJavaFile && !(file instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && JavaTypedHandler.isAfterClassLikeIdentifierOrDot(offsetBefore, editor);
        if ('>' == c && file instanceof PsiJavaFile && !(file instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && JavaTypedHandler.handleJavaGT(editor)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == ';' && JavaTypedHandler.handleSemicolon(editor, fileType)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (originalFileType == StdFileTypes.JAVA && c == '{') {
            int offset = editor.getCaretModel().getOffset();
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
            while (iterator.getTokenType() == TokenType.WHITE_SPACE) {
                iterator.retreat();
            }
            if (iterator.getTokenType() == JavaTokenType.RBRACKET || iterator.getTokenType() == JavaTokenType.EQ) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement leaf = file.findElementAt(offset);
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiArrayInitializerExpression.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiCodeBlock.class, (boolean)false, (Class[])new Class[]{PsiMember.class}) != null) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{", (boolean)false, (boolean)true);
                TypedHandler.indentOpenedBrace(project, editor);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, Editor editor, PsiFile file) {
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            JavaTypedHandler.handleAfterJavaLT(editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Nullable
    private static FileType getOriginalFileType(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? virtualFile.getFileType() : null;
    }

    private static boolean handleSemicolon(Editor editor, FileType fileType) {
        if (fileType != StdFileTypes.JAVA) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        char charAt = editor.getDocument().getCharsSequence().charAt(offset);
        if (charAt != ';') {
            return false;
        }
        editor.getCaretModel().moveToOffset(offset + 1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return true;
    }

    private static boolean handleJavaGT(Editor editor) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.getTokenType() != JavaTokenType.GT) {
            return false;
        }
        while (!iterator.atEnd() && !JavaTypedHandlerUtil.isTokenInvalidInsideReference(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return false;
        }
        if (JavaTypedHandlerUtil.isTokenInvalidInsideReference(iterator.getTokenType())) {
            iterator.retreat();
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == JavaTokenType.LT) {
                --balance;
            } else if (tokenType == JavaTokenType.GT) {
                ++balance;
            } else if (JavaTypedHandlerUtil.isTokenInvalidInsideReference(tokenType)) break;
            iterator.retreat();
        }
        if (balance == 0) {
            editor.getCaretModel().moveToOffset(offset + 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return true;
        }
        return false;
    }

    private static void handleAfterJavaLT(Editor editor) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        while (iterator.getStart() > 0 && !JavaTypedHandlerUtil.isTokenInvalidInsideReference(iterator.getTokenType())) {
            iterator.retreat();
        }
        if (JavaTypedHandlerUtil.isTokenInvalidInsideReference(iterator.getTokenType())) {
            iterator.advance();
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == JavaTokenType.LT) {
                ++balance;
            } else if (tokenType == JavaTokenType.GT) {
                --balance;
            } else if (JavaTypedHandlerUtil.isTokenInvalidInsideReference(tokenType)) break;
            iterator.advance();
        }
        if (balance == 1) {
            editor.getDocument().insertString(offset, (CharSequence)">");
        }
    }

    private static void autoPopupJavadocLookup(final Project project, final Editor editor) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTO_POPUP_JAVADOC_LOOKUP) {
            final PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (file == null) {
                return;
            }
            Runnable request = new Runnable(){

                @Override
                public void run() {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            new JavadocAutoLookupHandler().invoke(project, editor, file);
                        }
                    }, "", null, UndoConfirmationPolicy.DEFAULT, editor.getDocument());
                }
            };
            AutoPopupController.getInstance(project).invokeAutoPopupRunnable(request, settings.JAVADOC_LOOKUP_DELAY);
        }
    }

    public static boolean isAfterClassLikeIdentifierOrDot(int offset, Editor editor) {
        IElementType tokenType;
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
        }
        if ((tokenType = iterator.getTokenType()) == JavaTokenType.DOT) {
            return true;
        }
        if (tokenType == JavaTokenType.IDENTIFIER && iterator.getEnd() == offset) {
            CharSequence chars = editor.getDocument().getCharsSequence();
            char startChar = chars.charAt(iterator.getStart());
            if (!Character.isUpperCase(startChar)) {
                return false;
            }
            CharSequence word = chars.subSequence(iterator.getStart(), iterator.getEnd());
            if (word.length() == 1) {
                return true;
            }
            for (int i = 1; i < word.length(); ++i) {
                if (!Character.isLowerCase(word.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static class MemberAutoLookupCondition
    implements Condition<Editor> {
        private MemberAutoLookupCondition() {
        }

        public boolean value(Editor editor) {
            Project project = editor.getProject();
            if (project == null) {
                return false;
            }
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = file.findElementAt(offset - 1);
            if (lastElement == null) {
                return false;
            }
            PsiElement prevSibling = lastElement.getPrevSibling();
            if (prevSibling == null || ".".equals(prevSibling.getText())) {
                return false;
            }
            PsiElement parent = prevSibling;
            while ((parent = parent.getParent()) instanceof PsiJavaCodeReferenceElement || parent instanceof PsiTypeElement) {
            }
            if (parent instanceof PsiParameterList) {
                return false;
            }
            if (!".".equals(lastElement.getText()) && !"#".equals(lastElement.getText())) {
                return false;
            }
            PsiElement element = file.findElementAt(offset);
            return element == null || !"#".equals(lastElement.getText()) || new SuperParentFilter(new ClassFilter(PsiDocComment.class)).isAcceptable(element, element.getParent());
        }
    }
}

