/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.NotLookupOrSearchCondition;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + DocumentationManager.class.getName()));
    private static final String SHOW_DOCUMENTATION_IN_TOOL_WINDOW = "ShowDocumentationInToolWindow";
    private static final String DOCUMENTATION_AUTO_UPDATE_ENABLED = "DocumentationAutoUpdateEnabled";
    @NonNls
    public static final String JAVADOC_LOCATION_AND_SIZE = "javadoc.popup";
    private final Project myProject;
    private Editor myEditor = null;
    private ParameterInfoController myParameterInfoController;
    private final Alarm myUpdateDocAlarm;
    private WeakReference<JBPopup> myDocInfoHintRef;
    private Component myPreviouslyFocused = null;
    public static final Key<SmartPsiElementPointer> ORIGINAL_ELEMENT_KEY = Key.create((String)"Original element");
    @NonNls
    public static final String PSI_ELEMENT_PROTOCOL = "psi_element://";
    @NonNls
    private static final String DOC_ELEMENT_PROTOCOL = "doc_element://";
    private ToolWindow myToolWindow = null;
    private final ActionManagerEx myActionManagerEx;
    private static final int ourFlagsForTargetElements = TargetElementUtilBase.getInstance().getAllAccepted();
    private boolean myAutoUpdateDocumentation = PropertiesComponent.getInstance().isTrueValue("DocumentationAutoUpdateEnabled");
    private Runnable myAutoUpdateRequest;

    public static DocumentationManager getInstance(Project project) {
        return (DocumentationManager)ServiceManager.getService((Project)project, DocumentationManager.class);
    }

    public DocumentationManager(Project project, ActionManagerEx managerEx) {
        this.myProject = project;
        this.myActionManagerEx = managerEx;
        AnActionListener actionListener = new AnActionListener(){

            @Override
            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null) {
                    if (action instanceof HintManagerImpl.ActionToIgnore) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManagerEx.getAction("EditorDown")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManagerEx.getAction("EditorUp")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManagerEx.getAction("EditorPageDown")) {
                        return;
                    }
                    if (action == DocumentationManager.this.myActionManagerEx.getAction("EditorPageUp")) {
                        return;
                    }
                    if (action == ActionManagerEx.getInstanceEx().getAction("EditorEscape")) {
                        return;
                    }
                    hint.cancel();
                }
            }

            @Override
            public void beforeEditorTyping(char c, DataContext dataContext) {
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null) {
                    hint.cancel();
                }
            }

            @Override
            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            }
        };
        this.myActionManagerEx.addAnActionListener(actionListener, (Disposable)project);
        this.myUpdateDocAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, (Disposable)this.myProject);
    }

    public void showJavaDocInfo(@NotNull PsiElement element, final PsiElement original) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/documentation/DocumentationManager.showJavaDocInfo must not be null");
        }
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(element.getProject()){

            @Override
            public void updatePopup(Object lookupItemObject) {
                if (lookupItemObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo((PsiElement)lookupItemObject, true, false, this, original, false);
                }
            }
        };
        this.doShowJavaDocInfo(element, true, false, updateProcessor, original, false);
    }

    public void showJavaDocInfo(Editor editor, @Nullable PsiFile file, boolean requestFocus) {
        this.showJavaDocInfo(editor, file, requestFocus, false);
    }

    private void showJavaDocInfo(Editor editor, final @Nullable PsiFile file, boolean requestFocus, final boolean autoupdate) {
        Object[] objects;
        PsiElement originalElement;
        PsiElement element;
        this.myEditor = editor;
        Project project = this.getProject((PsiElement)file);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Object list = ParameterInfoController.findArgumentList(file, editor.getCaretModel().getOffset(), -1);
        if (list != null) {
            this.myParameterInfoController = ParameterInfoController.findControllerAtOffset(editor, list.getTextRange().getStartOffset());
        }
        if ((element = this.findTargetElement(editor, file, originalElement = file != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null)) == null && this.myParameterInfoController != null && (objects = this.myParameterInfoController.getSelectedElements()) != null && objects.length > 0 && objects[0] instanceof PsiElement) {
            element = (PsiElement)objects[0];
        }
        if (element == null && file == null) {
            return;
        }
        if (element == null) {
            element = originalElement;
            if (element == null) {
                return;
            }
            PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class);
            if (comment == null) {
                return;
            }
            element = comment.getParent();
        }
        DocumentationManager.storeOriginalElement(project, originalElement, element);
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project){

            @Override
            public void updatePopup(Object lookupIteObject) {
                if (lookupIteObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo((PsiElement)lookupIteObject, false, false, this, originalElement, autoupdate);
                    return;
                }
                DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file);
                PsiElement element = null;
                if (documentationProvider != null) {
                    element = documentationProvider.getDocumentationElementForLookupItem(PsiManager.getInstance((Project)DocumentationManager.this.myProject), lookupIteObject, originalElement);
                }
                if (element == null) {
                    return;
                }
                if (DocumentationManager.this.myEditor != null) {
                    PsiFile file2 = element.getContainingFile();
                    if (file2 != null) {
                        Editor editor = DocumentationManager.this.myEditor;
                        DocumentationManager.this.showJavaDocInfo(DocumentationManager.this.myEditor, file2, false);
                        DocumentationManager.this.myEditor = editor;
                    }
                } else {
                    DocumentationManager.this.doShowJavaDocInfo(element, false, false, this, originalElement, autoupdate);
                }
            }
        };
        this.doShowJavaDocInfo(element, false, requestFocus, updateProcessor, originalElement, autoupdate);
    }

    private void doShowJavaDocInfo(final PsiElement element, boolean heavyWeight, boolean requestFocus, PopupUpdateProcessor updateProcessor, final PsiElement originalElement, boolean autoupdate) {
        Content content;
        Project project = this.getProject(element);
        if (this.myToolWindow == null && PropertiesComponent.getInstance().isTrueValue(SHOW_DOCUMENTATION_IN_TOOL_WINDOW)) {
            this.createToolWindow(element, originalElement, true);
            return;
        }
        if (this.myToolWindow != null && (content = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            DocumentationComponent component = (DocumentationComponent)content.getComponent();
            if (component.getElement() != element) {
                content.setDisplayName(DocumentationManager.getTitle(element, true));
                this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component, true);
                if (!this.myToolWindow.isVisible()) {
                    this.myToolWindow.show(null);
                }
                return;
            }
            if (element != null && !autoupdate) {
                this.restorePopupBehavior();
            } else {
                return;
            }
        }
        final DocumentationComponent component = new DocumentationComponent(this);
        Processor<JBPopup> pinCallback = new Processor<JBPopup>(){

            public boolean process(JBPopup popup) {
                DocumentationManager.this.createToolWindow(element, originalElement, true);
                popup.cancel();
                return false;
            }
        };
        KeyboardShortcut keyboardShortcut = ActionManagerEx.getInstanceEx().getKeyboardShortcut("QuickJavaDoc");
        List<Pair> actions = Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationManager.this.createToolWindow(element, originalElement, false);
                JBPopup hint = DocumentationManager.this.getDocInfoHint();
                if (hint != null && hint.isVisible()) {
                    hint.cancel();
                }
            }
        }, (Object)(keyboardShortcut != null ? keyboardShortcut.getFirstKeyStroke() : null)));
        JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, (JComponent)component).setRequestFocusCondition(project, (Condition)NotLookupOrSearchCondition.INSTANCE).setProject(project).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setKeyboardActions(actions).setForceHeavyweight(heavyWeight).setDimensionServiceKey(this.myProject, JAVADOC_LOCATION_AND_SIZE, false).setResizable(true).setMovable(true).setTitle(DocumentationManager.getTitle(element, false)).setCouldPin((Processor)pinCallback).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (DocumentationManager.this.fromQuickSearch()) {
                    ((ChooseByNameBase.JPanelProvider)DocumentationManager.this.myPreviouslyFocused.getParent()).unregisterHint();
                }
                Disposer.dispose((Disposable)component);
                DocumentationManager.this.myEditor = null;
                DocumentationManager.this.myPreviouslyFocused = null;
                DocumentationManager.this.myParameterInfoController = null;
                return Boolean.TRUE;
            }
        }).createPopup();
        AbstractPopup oldHint = (AbstractPopup)this.getDocInfoHint();
        if (oldHint != null) {
            DocumentationComponent oldComponent = (DocumentationComponent)oldHint.getComponent();
            PsiElement element1 = oldComponent.getElement();
            if (Comparing.equal((Object)element, (Object)element1)) {
                if (requestFocus) {
                    component.getComponent().requestFocus();
                }
                return;
            }
            oldHint.cancel();
        }
        component.setHint(hint);
        if (this.myEditor == null) {
            Lookup lookup = LookupManager.getInstance(this.myProject).getActiveLookup();
            this.myEditor = lookup != null ? lookup.getEditor() : null;
        }
        this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component);
        this.myDocInfoHintRef = new WeakReference<JBPopup>(hint);
        this.myPreviouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(project);
        if (this.fromQuickSearch()) {
            ((ChooseByNameBase.JPanelProvider)this.myPreviouslyFocused.getParent()).registerHint(hint);
        }
    }

    private void createToolWindow(PsiElement element, PsiElement originalElement, boolean automatic) {
        assert (this.myToolWindow == null);
        DocumentationComponent component = new DocumentationComponent(this, new AnAction[]{new ToggleAction("Auto show documentation for selected element", "Show documentation for current element automatically", IconLoader.getIcon((String)"/general/autoscrollFromSource.png")){

            public boolean isSelected(AnActionEvent e) {
                return DocumentationManager.this.myAutoUpdateDocumentation;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                PropertiesComponent.getInstance().setValue(DocumentationManager.DOCUMENTATION_AUTO_UPDATE_ENABLED, Boolean.TRUE.toString());
                DocumentationManager.this.myAutoUpdateDocumentation = state;
                DocumentationManager.this.restartAutoUpdate(state);
            }
        }, new AnAction("Restore popup behavior", "Restore documentation popup behavior", IconLoader.getIcon((String)"/actions/cancel.png")){

            public void actionPerformed(AnActionEvent e) {
                DocumentationManager.this.restorePopupBehavior();
            }
        }});
        ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(this.myProject);
        this.myToolWindow = toolWindowManagerEx.registerToolWindow(ToolWindowId.DOCUMENTATION, true, ToolWindowAnchor.RIGHT, (Disposable)this.myProject);
        this.myToolWindow.setIcon(IconLoader.getIcon((String)"/general/documentation.png"));
        this.myToolWindow.setAvailable(true, null);
        this.myToolWindow.setToHideOnEmptyContent(false);
        this.myToolWindow.setAutoHide(false);
        Rectangle rectangle = WindowManager.getInstance().getIdeFrame(this.myProject).suggestChildFrameBounds();
        this.myToolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.FLOATING, rectangle);
        final ContentManager contentManager = this.myToolWindow.getContentManager();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent((JComponent)component, DocumentationManager.getTitle(element, true), false);
        contentManager.addContent(content);
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                if (contentManager.getContentCount() == 0) {
                    JComponent c = event.getContent().getComponent();
                    if (c instanceof DocumentationComponent) {
                        Disposer.dispose((Disposable)((DocumentationComponent)c));
                    }
                    DocumentationManager.this.restorePopupBehavior();
                }
            }
        });
        new UiNotifyConnector((Component)component, new Activatable(){

            public void showNotify() {
                DocumentationManager.this.restartAutoUpdate(DocumentationManager.this.myAutoUpdateDocumentation);
            }

            public void hideNotify() {
                DocumentationManager.this.restartAutoUpdate(false);
            }
        });
        this.myToolWindow.show(null);
        PropertiesComponent.getInstance().setValue(SHOW_DOCUMENTATION_IN_TOOL_WINDOW, Boolean.TRUE.toString());
        this.restartAutoUpdate(PropertiesComponent.getInstance().isTrueValue(DOCUMENTATION_AUTO_UPDATE_ENABLED));
        this.fetchDocInfo(this.getDefaultCollector(element, originalElement), component);
    }

    private void restartAutoUpdate(boolean state) {
        if (state && this.myToolWindow != null) {
            if (this.myAutoUpdateRequest == null) {
                this.myAutoUpdateRequest = new Runnable(){

                    @Override
                    public void run() {
                        DataContext dataContext = DataManager.getInstance().getDataContext();
                        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
                        if (editor != null) {
                            PsiFile psiFile;
                            PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)DocumentationManager.this.myProject);
                            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file);
                            if (injectedEditor != null && (psiFile = PsiUtilBase.getPsiFileInEditor((Editor)injectedEditor, (Project)DocumentationManager.this.myProject)) != null) {
                                DocumentationManager.this.showJavaDocInfo(injectedEditor, psiFile, false, true);
                                return;
                            }
                            if (file != null) {
                                DocumentationManager.this.showJavaDocInfo(editor, file, false, true);
                            }
                        }
                    }
                };
                IdeEventQueue.getInstance().addIdleListener(this.myAutoUpdateRequest, 500);
            }
        } else if (this.myAutoUpdateRequest != null) {
            IdeEventQueue.getInstance().removeIdleListener(this.myAutoUpdateRequest);
            this.myAutoUpdateRequest = null;
        }
    }

    private void restorePopupBehavior() {
        if (this.myToolWindow != null) {
            Content[] contents;
            PropertiesComponent.getInstance().setValue(SHOW_DOCUMENTATION_IN_TOOL_WINDOW, Boolean.FALSE.toString());
            for (Content content : contents = this.myToolWindow.getContentManager().getContents()) {
                JComponent c = content.getComponent();
                if (!(c instanceof DocumentationComponent)) continue;
                Disposer.dispose((Disposable)((DocumentationComponent)c));
            }
            ToolWindowManagerEx.getInstanceEx(this.myProject).unregisterToolWindow(ToolWindowId.DOCUMENTATION);
            this.myToolWindow = null;
            this.restartAutoUpdate(false);
        }
    }

    private static String getTitle(@NotNull PsiElement element, boolean _short) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/documentation/DocumentationManager.getTitle must not be null");
        }
        String title = SymbolPresentationUtil.getSymbolPresentableText(element);
        return _short ? (title != null ? title : element.getText()) : CodeInsightBundle.message((String)"javadoc.info.title", (Object[])new Object[]{title != null ? title : element.getText()});
    }

    public static void storeOriginalElement(Project project, PsiElement originalElement, PsiElement element) {
        if (element == null) {
            return;
        }
        try {
            element.putUserData(ORIGINAL_ELEMENT_KEY, (Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(originalElement));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nullable
    public PsiElement findTargetElement(Editor editor, @Nullable PsiFile file, PsiElement contextElement) {
        PsiReference ref;
        PsiElement adjusted;
        PsiElement element;
        PsiElement psiElement = element = editor != null ? TargetElementUtilBase.findTargetElement(editor, ourFlagsForTargetElements) : null;
        if ((element != null || contextElement != null) && (adjusted = TargetElementUtilBase.getInstance().adjustElement(editor, ourFlagsForTargetElements, element, contextElement)) != null) {
            element = adjusted;
        }
        if (element == null && editor != null && (element = this.getElementFromLookup(editor, file)) == null && (ref = TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset())) != null && (element = TargetElementUtilBase.getInstance().adjustReference(ref)) == null && ref instanceof PsiPolyVariantReference) {
            element = ref.getElement();
        }
        DocumentationManager.storeOriginalElement(this.myProject, contextElement, element);
        return element;
    }

    @Nullable
    public PsiElement getElementFromLookup(Editor editor, @Nullable PsiFile file) {
        LookupElement item;
        Lookup activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null) {
            PsiElement contextElement = file != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null;
            PsiReference ref = TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset());
            DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file);
            return documentationProvider.getDocumentationElementForLookupItem(PsiManager.getInstance((Project)this.myProject), item.getObject(), ref != null ? ref.getElement() : contextElement);
        }
        return null;
    }

    private boolean fromQuickSearch() {
        return this.myPreviouslyFocused != null && this.myPreviouslyFocused.getParent() instanceof ChooseByNameBase.JPanelProvider;
    }

    private DocumentationCollector getDefaultCollector(final @NotNull PsiElement element, final @Nullable PsiElement originalElement) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/documentation/DocumentationManager.getDefaultCollector must not be null");
        }
        return new DocumentationCollector(){

            @Override
            @Nullable
            public String getDocumentation() throws Exception {
                String doc;
                List urls;
                String doc2;
                final DocumentationProvider provider = (DocumentationProvider)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DocumentationProvider>(){

                    public DocumentationProvider compute() {
                        return DocumentationManager.getProviderFromElement(element, originalElement);
                    }
                });
                if (DocumentationManager.this.myParameterInfoController != null && (doc2 = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return this.generateParameterInfoDocumentation(provider);
                    }
                })) != null) {
                    return doc2;
                }
                if (provider instanceof ExternalDocumentationProvider && (urls = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<String>>(){

                    public List<String> compute() {
                        SmartPsiElementPointer originalElement = (SmartPsiElementPointer)element.getUserData(ORIGINAL_ELEMENT_KEY);
                        return provider.getUrlFor(element, originalElement != null ? originalElement.getElement() : null);
                    }
                })) != null && (doc = ((ExternalDocumentationProvider)provider).fetchExternalDocumentation(DocumentationManager.this.myProject, element, urls)) != null) {
                    return doc;
                }
                return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    @Nullable
                    public String compute() {
                        SmartPsiElementPointer originalElement = (SmartPsiElementPointer)element.getUserData(ORIGINAL_ELEMENT_KEY);
                        return provider.generateDoc(element, originalElement != null ? originalElement.getElement() : null);
                    }
                });
            }

            private String generateParameterInfoDocumentation(DocumentationProvider provider) {
                Object[] objects = DocumentationManager.this.myParameterInfoController.getSelectedElements();
                if (objects.length > 0) {
                    StringBuffer sb = null;
                    for (Object o : objects) {
                        PsiElement parameter = null;
                        if (o instanceof PsiElement) {
                            parameter = (PsiElement)o;
                        }
                        if (parameter != null) {
                            SmartPsiElementPointer originalElement2 = (SmartPsiElementPointer)parameter.getUserData(ORIGINAL_ELEMENT_KEY);
                            String str2 = provider.generateDoc(parameter, originalElement2 != null ? originalElement2.getElement() : null);
                            if (str2 == null) continue;
                            if (sb == null) {
                                sb = new StringBuffer();
                            }
                            sb.append(str2);
                            sb.append("<br>");
                            continue;
                        }
                        sb = null;
                        break;
                    }
                    if (sb != null) {
                        return sb.toString();
                    }
                }
                return null;
            }

            @Override
            @Nullable
            public PsiElement getElement() {
                return element.isValid() ? element : null;
            }
        };
    }

    @Nullable
    public JBPopup getDocInfoHint() {
        if (this.myDocInfoHintRef == null) {
            return null;
        }
        JBPopup hint = (JBPopup)this.myDocInfoHintRef.get();
        if (hint == null || !hint.isVisible()) {
            this.myDocInfoHintRef = null;
            return null;
        }
        return hint;
    }

    public void fetchDocInfo(DocumentationCollector provider, DocumentationComponent component) {
        this.doFetchDocInfo(component, provider, true, false);
    }

    public void fetchDocInfo(DocumentationCollector provider, DocumentationComponent component, boolean clearHistory) {
        this.doFetchDocInfo(component, provider, true, clearHistory);
    }

    public void fetchDocInfo(PsiElement element, DocumentationComponent component) {
        this.doFetchDocInfo(component, this.getDefaultCollector(element, null), true, false);
    }

    public ActionCallback queueFetchDocInfo(DocumentationCollector provider, DocumentationComponent component, boolean clearHistory) {
        return this.doFetchDocInfo(component, provider, false, clearHistory);
    }

    public ActionCallback queueFetchDocInfo(PsiElement element, DocumentationComponent component) {
        return this.queueFetchDocInfo(this.getDefaultCollector(element, null), component, false);
    }

    private ActionCallback doFetchDocInfo(final DocumentationComponent component, final DocumentationCollector provider, boolean cancelRequests, final boolean clearHistory) {
        final ActionCallback callback = new ActionCallback();
        component.startWait();
        if (cancelRequests) {
            this.myUpdateDocAlarm.cancelAllRequests();
        }
        if (component.isEmpty()) {
            component.setText(CodeInsightBundle.message((String)"javadoc.fetching.progress", (Object[])new Object[0]), null, clearHistory);
        }
        this.myUpdateDocAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                final Throwable[] ex = new Throwable[1];
                String text = null;
                try {
                    text = provider.getDocumentation();
                }
                catch (Throwable e) {
                    LOG.info(e);
                    ex[0] = e;
                }
                if (ex[0] != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String message = ex[0] instanceof IndexNotReadyException ? "Documentation is not available until indices are built." : CodeInsightBundle.message((String)"javadoc.external.fetch.error.message", (Object[])new Object[]{ex[0].getLocalizedMessage()});
                            component.setText(message, null, true);
                            callback.setDone();
                        }
                    });
                    return;
                }
                final PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

                    @Nullable
                    public PsiElement compute() {
                        return provider.getElement();
                    }
                });
                if (element == null) {
                    return;
                }
                final String documentationText = text;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Window window;
                        Dimension storedSize;
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                PsiDocumentManager.getInstance((Project)DocumentationManager.this.myProject).commitAllDocuments();
                            }
                        });
                        if (!element.isValid()) {
                            callback.setDone();
                            return;
                        }
                        if (documentationText == null) {
                            component.setText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), element, true);
                        } else if (documentationText.length() == 0) {
                            component.setText(component.getText(), element, true, clearHistory);
                        } else {
                            component.setData(element, documentationText, clearHistory);
                        }
                        AbstractPopup jbPopup = (AbstractPopup)DocumentationManager.this.getDocInfoHint();
                        if (jbPopup == null) {
                            callback.setDone();
                            return;
                        }
                        jbPopup.setCaption(DocumentationManager.getTitle(element, false));
                        String dimensionServiceKey = jbPopup.getDimensionServiceKey();
                        Dimension dimension = component.getPreferredSize();
                        Dimension dimension2 = storedSize = dimensionServiceKey != null ? DimensionService.getInstance().getSize(dimensionServiceKey, DocumentationManager.this.getProject(element)) : null;
                        if (storedSize != null) {
                            dimension = storedSize;
                        }
                        if ((window = SwingUtilities.getWindowAncestor(component)) != null) {
                            window.setBounds(window.getX(), window.getY(), dimension.width, dimension.height);
                            window.validate();
                            window.repaint();
                        }
                        callback.setDone();
                    }
                });
            }
        }, 10);
        return callback;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(PsiElement element) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element, null);
        if (documentationProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/documentation/DocumentationManager.getProviderFromElement must not return null");
        }
        return documentationProvider;
    }

    @NotNull
    private static DocumentationProvider getProviderFromElement(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        Language baseLanguage;
        if (element != null && !element.isValid()) {
            element = null;
        }
        if (originalElement != null && !originalElement.isValid()) {
            originalElement = null;
        }
        if (originalElement == null) {
            originalElement = DocumentationManager.getOriginalElement(element);
        }
        PsiFile containingFile = originalElement != null ? originalElement.getContainingFile() : (element != null ? element.getContainingFile() : null);
        LinkedHashSet<DocumentationProvider> result = new LinkedHashSet<DocumentationProvider>();
        Language containingFileLanguage = containingFile != null ? containingFile.getLanguage() : null;
        DocumentationProvider originalProvider = containingFile != null ? LanguageDocumentation.INSTANCE.forLanguage(containingFileLanguage) : null;
        Language elementLanguage = element != null ? element.getLanguage() : null;
        DocumentationProvider elementProvider = element == null || elementLanguage.is(containingFileLanguage) ? null : LanguageDocumentation.INSTANCE.forLanguage(elementLanguage);
        DocumentationManager.addProviderToResult(result, elementProvider);
        DocumentationManager.addProviderToResult(result, originalProvider);
        if (containingFile != null && !(baseLanguage = containingFile.getViewProvider().getBaseLanguage()).is(containingFileLanguage)) {
            DocumentationManager.addProviderToResult(result, LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
        }
        CompositeDocumentationProvider compositeDocumentationProvider = new CompositeDocumentationProvider(result);
        if (compositeDocumentationProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/documentation/DocumentationManager.getProviderFromElement must not return null");
        }
        return compositeDocumentationProvider;
    }

    private static void addProviderToResult(Set<DocumentationProvider> result, DocumentationProvider t) {
        if (t instanceof CompositeDocumentationProvider) {
            result.addAll(((CompositeDocumentationProvider)t).getProviders());
        } else {
            ContainerUtil.addIfNotNull((Object)t, result);
        }
    }

    @Nullable
    public static PsiElement getOriginalElement(PsiElement element) {
        SmartPsiElementPointer originalElementPointer = element != null ? (SmartPsiElementPointer)element.getUserData(ORIGINAL_ELEMENT_KEY) : null;
        return originalElementPointer != null ? originalElementPointer.getElement() : null;
    }

    void navigateByLink(DocumentationComponent component, String url) {
        component.setCursor(Cursor.getPredefinedCursor(3));
        final PsiElement psiElement = component.getElement();
        PsiManager manager = PsiManager.getInstance((Project)this.getProject(psiElement));
        if (url.startsWith("open")) {
            VirtualFile virtualFile;
            OrderEntry libraryEntry;
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile != null && (libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)(virtualFile = containingFile.getVirtualFile()), (Project)this.myProject)) != null) {
                ProjectSettingsService.getInstance(this.myProject).openProjectLibrarySettings(new NamedLibraryElement(libraryEntry.getOwnerModule(), libraryEntry));
            }
        } else if (url.startsWith(PSI_ELEMENT_PROTOCOL)) {
            String refText = url.substring(PSI_ELEMENT_PROTOCOL.length());
            DocumentationProvider provider = DocumentationManager.getProviderFromElement(psiElement);
            PsiElement targetElement = provider.getDocumentationElementForLink(manager, refText, psiElement);
            if (targetElement != null) {
                this.fetchDocInfo(this.getDefaultCollector(targetElement, null), component);
            }
        } else {
            final String docUrl = url;
            this.fetchDocInfo(new DocumentationCollector(){

                @Override
                public String getDocumentation() throws Exception {
                    if (docUrl.startsWith(DocumentationManager.DOC_ELEMENT_PROTOCOL)) {
                        List urls = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<String>>(){

                            public List<String> compute() {
                                DocumentationProvider provider = DocumentationManager.getProviderFromElement(psiElement);
                                return provider.getUrlFor(psiElement, DocumentationManager.getOriginalElement(psiElement));
                            }
                        });
                        BrowserUtil.launchBrowser((String)(urls != null && !urls.isEmpty() ? (String)urls.get(0) : docUrl));
                    } else {
                        BrowserUtil.launchBrowser((String)docUrl);
                    }
                    return "";
                }

                @Override
                public PsiElement getElement() {
                    return psiElement;
                }
            }, component);
        }
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    void showHint(JBPopup hint) {
        if (this.myEditor != null) {
            hint.showInBestPositionFor(this.myEditor);
        } else if (this.myPreviouslyFocused != null) {
            hint.showInBestPositionFor(DataManager.getInstance().getDataContext(this.myPreviouslyFocused));
        } else {
            hint.showInBestPositionFor(DataManager.getInstance().getDataContext());
        }
    }

    public void requestFocus() {
        if (this.fromQuickSearch()) {
            this.myPreviouslyFocused.getParent().requestFocus();
        }
    }

    public Project getProject(@Nullable PsiElement element) {
        assert (element == null || !element.isValid() || this.myProject == element.getProject());
        return this.myProject;
    }

    public static void createHyperlink(StringBuilder buffer, String refText, String label, boolean plainLink) {
        buffer.append("<a href=\"");
        buffer.append(PSI_ELEMENT_PROTOCOL);
        buffer.append(refText);
        buffer.append("\">");
        if (!plainLink) {
            buffer.append("<code>");
        }
        buffer.append(label);
        if (!plainLink) {
            buffer.append("</code>");
        }
        buffer.append("</a>");
    }

    private static interface DocumentationCollector {
        @Nullable
        public String getDocumentation() throws Exception;

        @Nullable
        public PsiElement getElement();
    }
}

