/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeClassInterfaceFix
extends IntentionAndQuickFixAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MakeClassInterfaceFix");
    private final PsiClass myClass;
    private final boolean myMakeInterface;

    public MakeClassInterfaceFix(PsiClass aClass, boolean makeInterface) {
        this.myClass = aClass;
        this.myMakeInterface = makeInterface;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message(this.myMakeInterface ? "make.class.an.interface.text" : "make.interface.an.class.text", this.myClass.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MakeClassInterfaceFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("make.class.an.interface.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MakeClassInterfaceFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MakeClassInterfaceFix.isAvailable must not be null");
        }
        return this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)this.myClass);
    }

    public void applyFix(Project project, PsiFile file, @Nullable Editor editor) {
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)this.myClass)) {
            return;
        }
        try {
            PsiReferenceList implementsList;
            PsiReferenceList extendsList = this.myMakeInterface ? this.myClass.getExtendsList() : this.myClass.getImplementsList();
            PsiReferenceList psiReferenceList = implementsList = this.myMakeInterface ? this.myClass.getImplementsList() : this.myClass.getExtendsList();
            if (extendsList != null) {
                for (PsiJavaCodeReferenceElement referenceElement : extendsList.getReferenceElements()) {
                    referenceElement.delete();
                }
                if (implementsList != null) {
                    for (PsiJavaCodeReferenceElement referenceElement : implementsList.getReferenceElements()) {
                        extendsList.addAfter((PsiElement)referenceElement, null);
                        referenceElement.delete();
                    }
                }
            }
            this.convertPsiClass(this.myClass, this.myMakeInterface);
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void convertPsiClass(PsiClass aClass, boolean makeInterface) throws IncorrectOperationException {
        IElementType lookFor = makeInterface ? JavaTokenType.CLASS_KEYWORD : JavaTokenType.INTERFACE_KEYWORD;
        PsiKeyword replaceWith = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory().createKeyword(makeInterface ? "interface" : "class");
        for (PsiElement psiElement : aClass.getChildren()) {
            PsiKeyword psiKeyword;
            if (!(psiElement instanceof PsiKeyword) || (psiKeyword = (PsiKeyword)psiElement).getTokenType() != lookFor) continue;
            psiKeyword.replace((PsiElement)replaceWith);
            break;
        }
    }
}

