/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.NotNull;

public class ImportClassFix
extends ImportClassFixBase<PsiJavaCodeReferenceElement> {
    public ImportClassFix(@NotNull PsiJavaCodeReferenceElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFix.<init> must not be null");
        }
        super(element);
    }

    @Override
    protected String getReferenceName(PsiJavaCodeReferenceElement reference) {
        return reference.getReferenceName();
    }

    @Override
    protected void bindReference(PsiJavaCodeReferenceElement ref, PsiClass targetClass) {
        if (ref instanceof PsiImportStaticReferenceElement) {
            ((PsiImportStaticReferenceElement)ref).bindToTargetClass(targetClass);
        } else {
            super.bindReference(ref, targetClass);
        }
    }

    @Override
    protected boolean hasTypeParameters(PsiJavaCodeReferenceElement reference) {
        PsiReferenceParameterList refParameters = reference.getParameterList();
        return refParameters != null && refParameters.getTypeParameterElements().length > 0;
    }

    @Override
    protected String getQualifiedName(PsiJavaCodeReferenceElement reference) {
        return reference.getQualifiedName();
    }

    @Override
    protected boolean isQualified(PsiJavaCodeReferenceElement reference) {
        return reference.isQualified();
    }

    @Override
    protected boolean hasUnresolvedImportWhichCanImport(PsiFile psiFile, String name) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiImportStatement[] importStatements;
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiImportList importList = ((PsiJavaFile)psiFile).getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
            String className;
            if (importStatement.resolve() != null) continue;
            if (importStatement.isOnDemand()) {
                return true;
            }
            String qualifiedName = importStatement.getQualifiedName();
            String string = className = qualifiedName == null ? null : ClassUtil.extractClassName((String)qualifiedName);
            if (!Comparing.strEqual((String)className, (String)name)) continue;
            return true;
        }
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            if (importStaticStatement.resolve() != null) continue;
            if (importStaticStatement.isOnDemand()) {
                return true;
            }
            String qualifiedName = importStaticStatement.getReferenceName();
            if (qualifiedName == null || !StringUtil.split((String)qualifiedName, (String)".").contains(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAccessible(PsiClass aClass, PsiJavaCodeReferenceElement reference) {
        return aClass.hasModifierProperty("public");
    }
}

