/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SideEffectWarningDialog;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AccessStaticViaInstanceFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AccessStaticViaInstanceFix");
    private final PsiReferenceExpression myExpression;
    private final boolean myOnTheFly;
    private final PsiMember myMember;
    private final JavaResolveResult myResult;

    public AccessStaticViaInstanceFix(PsiReferenceExpression expression, JavaResolveResult result, boolean onTheFly) {
        this.myExpression = expression;
        this.myOnTheFly = onTheFly;
        this.myMember = (PsiMember)result.getElement();
        this.myResult = result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getName() {
        PsiClass aClass = this.myMember.getContainingClass();
        if (aClass == null) {
            return "";
        }
        String string = QuickFixBundle.message("access.static.via.class.reference.text", HighlightMessageUtil.getSymbolName((PsiElement)this.myMember, this.myResult.getSubstitutor()), HighlightUtil.formatClass(aClass), HighlightUtil.formatClass(aClass, false));
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix.getName must not return null");
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("access.static.via.class.reference.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AccessStaticViaInstanceFix.applyFix must not be null");
        }
        if (!this.myExpression.isValid() || !this.myMember.isValid()) {
            return;
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myExpression.getContainingFile())) {
            return;
        }
        PsiClass containingClass = this.myMember.getContainingClass();
        if (containingClass == null) {
            return;
        }
        try {
            PsiExpression qualifierExpression = this.myExpression.getQualifierExpression();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            if (qualifierExpression != null) {
                if (!this.checkSideEffects(project, containingClass, qualifierExpression, factory)) {
                    return;
                }
                PsiElement newQualifier = qualifierExpression.replace((PsiElement)factory.createReferenceExpression(containingClass));
                PsiElement qualifiedWithClassName = this.myExpression.copy();
                newQualifier.delete();
                if (this.myExpression.resolve() != this.myMember) {
                    this.myExpression.replace(qualifiedWithClassName);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean checkSideEffects(Project project, PsiClass containingClass, final PsiExpression qualifierExpression, PsiElementFactory factory) {
        ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
        boolean hasSideEffects = RemoveUnusedVariableFix.checkSideEffects((PsiElement)qualifierExpression, null, sideEffects);
        if (hasSideEffects && !this.myOnTheFly) {
            return false;
        }
        if (hasSideEffects && !ApplicationManager.getApplication().isUnitTestMode()) {
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, sideEffects.toArray(new PsiElement[sideEffects.size()]), attributes, true, null);
            try {
                hasSideEffects = PsiUtil.isStatement((PsiElement)factory.createStatementFromText(qualifierExpression.getText(), (PsiElement)qualifierExpression));
            }
            catch (IncorrectOperationException e) {
                hasSideEffects = false;
            }
            final PsiReferenceExpression qualifiedWithClassName = (PsiReferenceExpression)this.myExpression.copy();
            qualifiedWithClassName.setQualifierExpression((PsiExpression)factory.createReferenceExpression(containingClass));
            final boolean canCopeWithSideEffects = hasSideEffects;
            SideEffectWarningDialog dialog = new SideEffectWarningDialog(project, false, null, ((PsiElement)sideEffects.get(0)).getText(), qualifierExpression.getText(), canCopeWithSideEffects){

                @Override
                protected String sideEffectsDescription() {
                    if (canCopeWithSideEffects) {
                        return "<html><body>  There are possible side effects found in expression '" + qualifierExpression.getText() + "'<br>" + "  You can:<ul><li><b>Remove</b> class reference along with whole expressions involved, or</li>" + "  <li><b>Transform</b> qualified expression into the statement on its own.<br>" + "  That is,<br>" + "  <table border=1><tr><td><code>" + AccessStaticViaInstanceFix.this.myExpression.getText() + "</code></td></tr></table><br> becomes: <br>" + "  <table border=1><tr><td><code>" + qualifierExpression.getText() + ";<br>" + qualifiedWithClassName.getText() + "       </code></td></tr></table></li>" + "  </body></html>";
                    }
                    return "<html><body>  There are possible side effects found in expression '" + qualifierExpression.getText() + "'<br>" + "You can:<ul><li><b>Remove</b> class reference along with whole expressions involved, or</li></body></html>";
                }
            };
            dialog.show();
            int res = dialog.getExitCode();
            if (res == 0) {
                return false;
            }
            try {
                if (res == 1) {
                    PsiStatement statementFromText = factory.createStatementFromText(qualifierExpression.getText() + ";", null);
                    PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myExpression, PsiStatement.class);
                    statement.getParent().addBefore((PsiElement)statementFromText, (PsiElement)statement);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return true;
    }
}

