/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlHighlightVisitorBasedInspection
extends GlobalInspectionTool {
    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public void runInspection(AnalysisScope scope, final InspectionManager manager, final GlobalInspectionContext globalContext, final ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        scope.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){
            final XmlHighlightVisitor highlightVisitor = new XmlHighlightVisitor();
            HighlightInfoHolder myHolder;

            public void visitFile(final PsiFile file) {
                this.myHolder = new HighlightInfoHolder(file, HighlightInfoFilter.EMPTY_ARRAY){

                    @Override
                    public boolean add(@Nullable HighlightInfo info) {
                        if (info != null) {
                            ProblemHighlightType problemHighlightType = HighlightInfo.convertType(info.type);
                            GlobalInspectionUtil.createProblem((PsiElement)file, info.description, problemHighlightType, new TextRange(info.startOffset, info.endOffset), manager, problemDescriptionsProcessor, globalContext);
                        }
                        return true;
                    }
                };
                super.visitFile(file);
            }

            public void visitElement(PsiElement element) {
                this.highlightVisitor.visit(element, this.myHolder);
                super.visitElement(element);
            }
        });
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("General" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection.getGroupDisplayName must not return null");
        }
        return "General";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Xml Highlighting" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection.getDisplayName must not return null");
        }
        return "Xml Highlighting";
    }

    @NotNull
    public String getShortName() {
        if ("XmlHighlighting" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection.getShortName must not return null");
        }
        return "XmlHighlighting";
    }
}

