/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAddNoInspectionCommentFix
extends SuppressIntentionAction {
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;

    @Nullable
    protected abstract PsiElement getContainer(PsiElement var1);

    public AbstractAddNoInspectionCommentFix(String ID2, boolean replaceOtherSuppressionIds) {
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment, @NotNull String oldSuppressionCommentText) {
        if (comment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/actions/AbstractAddNoInspectionCommentFix.replaceSuppressionComment must not be null");
        }
        if (oldSuppressionCommentText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/actions/AbstractAddNoInspectionCommentFix.replaceSuppressionComment must not be null");
        }
        String prefix = this.getLineCommentPrefix(comment);
        assert (prefix != null && oldSuppressionCommentText.startsWith(prefix)) : "Unexpected suppression comment " + oldSuppressionCommentText;
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)comment.getProject());
        String newText = this.myReplaceOtherSuppressionIds ? "noinspection " + this.myID : oldSuppressionCommentText.substring(prefix.length()) + "," + this.myID;
        PsiComment newComment = parserFacade.createLineCommentFromText((LanguageFileType)comment.getContainingFile().getFileType(), newText);
        comment.replace((PsiElement)newComment);
    }

    @Nullable
    protected String getLineCommentPrefix(PsiElement comment) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(comment.getLanguage());
        assert (commenter != null);
        return commenter.getLineCommentPrefix();
    }

    protected void createSuppression(Project project, Editor editor, PsiElement element, PsiElement container) throws IncorrectOperationException {
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
        String text = "noinspection " + this.myID;
        PsiComment comment = parserFacade.createLineOrBlockCommentFromText(element.getLanguage(), text);
        container.getParent().addBefore((PsiElement)comment, container);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/actions/AbstractAddNoInspectionCommentFix.isAvailable must not be null");
        }
        return context != null && context.getManager().isInProject(context) && this.getContainer(context) != null;
    }

    public void invoke(Project project, @Nullable Editor editor, PsiElement element) throws IncorrectOperationException {
        PsiElement container = this.getContainer(element);
        if (container == null) {
            return;
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{container.getContainingFile().getVirtualFile()});
        if (status.hasReadonlyFiles()) {
            return;
        }
        List<? extends PsiElement> comments = this.getCommentsFor(container);
        if (comments != null) {
            for (PsiElement psiElement : comments) {
                if (!(psiElement instanceof PsiComment)) continue;
                String text = psiElement.getText();
                String lineCommentPrefix = this.getLineCommentPrefix(psiElement);
                assert (lineCommentPrefix != null);
                if (!text.startsWith(lineCommentPrefix + "noinspection")) continue;
                this.replaceSuppressionComment(psiElement, text);
                return;
            }
        }
        boolean caretWasBeforeStatement = editor != null && editor.getCaretModel().getOffset() == container.getTextRange().getStartOffset();
        this.createSuppression(project, editor, element, container);
        if (caretWasBeforeStatement) {
            editor.getCaretModel().moveToOffset(container.getTextRange().getStartOffset());
        }
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/actions/AbstractAddNoInspectionCommentFix.getCommentsFor must not be null");
        }
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)container, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev == null) {
            return null;
        }
        return Collections.singletonList(prev);
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/actions/AbstractAddNoInspectionCommentFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

