/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressableTextEditorHighlightingPass
extends TextEditorHighlightingPass {
    private volatile boolean myFinished;
    private volatile long myProgessLimit;
    private final AtomicLong myProgressCount;
    private final Icon myInProgressIcon;
    private final String myPresentableName;
    protected final PsiFile myFile;

    protected ProgressableTextEditorHighlightingPass(Project project, @Nullable Document document, Icon inProgressIcon, String presentableName, @NotNull PsiFile file, boolean runIntentionPassAfter) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ProgressableTextEditorHighlightingPass.<init> must not be null");
        }
        super(project, document, runIntentionPassAfter);
        this.myProgessLimit = 0L;
        this.myProgressCount = new AtomicLong();
        this.myInProgressIcon = inProgressIcon;
        this.myPresentableName = presentableName;
        this.myFile = file;
    }

    @Override
    public final void doCollectInformation(ProgressIndicator progress) {
        this.myFinished = false;
        this.collectInformationWithProgress(progress);
    }

    protected abstract void collectInformationWithProgress(ProgressIndicator var1);

    @Override
    public final void doApplyInformationToEditor() {
        this.myFinished = true;
        this.applyInformationWithProgress();
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).getFileStatusMap().markFileUpToDate(this.myDocument, this.myFile, this.getId());
    }

    protected abstract void applyInformationWithProgress();

    public double getProgress() {
        if (this.myProgessLimit == 0L) {
            return -1.0;
        }
        return (double)this.myProgressCount.get() / (double)this.myProgessLimit;
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    protected final Icon getInProgressIcon() {
        return this.myInProgressIcon;
    }

    protected final String getPresentableName() {
        return this.myPresentableName;
    }

    public void setProgressLimit(long limit) {
        this.myProgessLimit = limit;
    }

    public void advanceProgress(int delta) {
        this.myProgressCount.addAndGet(delta);
    }

    public static class EmptyPass
    extends TextEditorHighlightingPass {
        public EmptyPass(Project project, @Nullable Document document, Icon icon, String text) {
            super(project, document, false);
        }

        @Override
        public void doCollectInformation(ProgressIndicator progress) {
        }

        @Override
        public void doApplyInformationToEditor() {
        }
    }
}

