/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public LocalInspectionsPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, true, 7);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("LocalInspectionsPassFactory" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory.getComponentName must not return null");
        }
        return "LocalInspectionsPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory.createHighlightingPass must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory.createHighlightingPass must not be null");
        }
        TextRange textRange = LocalInspectionsPassFactory.calculateRangeToProcess(editor);
        if (textRange == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument(), LocalInspectionsPass.IN_PROGRESS_ICON, LocalInspectionsPass.PRESENTABLE_NAME);
        }
        return new LocalInspectionsPass(file, editor.getDocument(), textRange.getStartOffset(), textRange.getEndOffset()){

            @Override
            List<LocalInspectionTool> getInspectionTools(InspectionProfileWrapper profile) {
                List<LocalInspectionTool> tools = super.getInspectionTools(profile);
                ArrayList<LocalInspectionTool> result = new ArrayList<LocalInspectionTool>(tools.size());
                for (LocalInspectionTool tool : tools) {
                    if (tool.runForWholeFile()) continue;
                    result.add(tool);
                }
                return result;
            }
        };
    }

    private static TextRange calculateRangeToProcess(Editor editor) {
        return FileStatusMap.getDirtyTextRange(editor, 7);
    }
}

