/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaReferenceImporter
implements ReferenceImporter {
    @Override
    public boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/JavaReferenceImporter.autoImportReferenceAtCursor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/JavaReferenceImporter.autoImportReferenceAtCursor must not be null");
        }
        return JavaReferenceImporter.autoImportReferenceAtCursor(editor, file, false);
    }

    public static boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file, boolean allowCaretNearRef) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/JavaReferenceImporter.autoImportReferenceAtCursor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/JavaReferenceImporter.autoImportReferenceAtCursor must not be null");
        }
        if (!file.getViewProvider().getLanguages().contains(StdLanguages.JAVA)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caretOffset);
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file, startOffset, endOffset);
        for (PsiElement element : elements) {
            PsiJavaCodeReferenceElement ref;
            if (!(element instanceof PsiJavaCodeReferenceElement) || (ref = (PsiJavaCodeReferenceElement)element).multiResolve(true).length != 0) continue;
            new ImportClassFix(ref).doFix(editor, false, allowCaretNearRef);
            return true;
        }
        return false;
    }
}

