/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.SyntaxHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface HighlightInfoType {
    @NonNls
    public static final String UNUSED_SYMBOL_SHORT_NAME = "UNUSED_SYMBOL";
    @NonNls
    public static final String UNUSED_SYMBOL_DISPLAY_NAME = InspectionsBundle.message((String)"unused.symbol", (Object[])new Object[0]);
    @NonNls
    public static final String UNUSED_SYMBOL_ID = "UnusedDeclaration";
    @NonNls
    public static final String DEPRECATION_SHORT_NAME = "Deprecation";
    @NonNls
    public static final String DEPRECATION_ID = "deprecation";
    @NonNls
    public static final String DEPRECATION_DISPLAY_NAME = InspectionsBundle.message((String)"inspection.deprecated.display.name", (Object[])new Object[0]);
    public static final HighlightInfoType WRONG_REF = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
    public static final HighlightInfoType ERROR = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES);
    public static final HighlightInfoType GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER = new HighlightInfoTypeImpl(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING);
    public static final HighlightInfoType DUPLICATE_FROM_SERVER = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.DUPLICATE_FROM_SERVER);
    public static final HighlightInfoType UNUSED_SYMBOL = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.find((String)"UNUSED_SYMBOL") == null ? HighlightDisplayKey.register((String)"UNUSED_SYMBOL", (String)UNUSED_SYMBOL_DISPLAY_NAME, (String)"UnusedDeclaration") : HighlightDisplayKey.find((String)"UNUSED_SYMBOL"), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
    public static final HighlightInfoType DEPRECATED = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.find((String)"Deprecation") == null ? HighlightDisplayKey.register((String)"Deprecation", (String)DEPRECATION_DISPLAY_NAME, (String)"deprecation") : HighlightDisplayKey.find((String)"Deprecation"), CodeInsightColors.DEPRECATED_ATTRIBUTES);
    public static final HighlightInfoType LOCAL_VARIABLE = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.LOCAL_VARIABLE_ATTRIBUTES);
    public static final HighlightInfoType INSTANCE_FIELD = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.INSTANCE_FIELD_ATTRIBUTES);
    public static final HighlightInfoType STATIC_FIELD = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.STATIC_FIELD_ATTRIBUTES);
    public static final HighlightInfoType PARAMETER = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.PARAMETER_ATTRIBUTES);
    public static final HighlightInfoType TODO = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, null);
    public static final HighlightInfoType METHOD_CALL = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.METHOD_CALL_ATTRIBUTES);
    public static final HighlightInfoType METHOD_DECLARATION = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.METHOD_DECLARATION_ATTRIBUTES);
    public static final HighlightInfoType CONSTRUCTOR_CALL = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.CONSTRUCTOR_CALL_ATTRIBUTES);
    public static final HighlightInfoType CONSTRUCTOR_DECLARATION = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.CONSTRUCTOR_DECLARATION_ATTRIBUTES);
    public static final HighlightInfoType STATIC_METHOD = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.STATIC_METHOD_ATTRIBUTES);
    public static final HighlightInfoType CLASS_NAME = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.CLASS_NAME_ATTRIBUTES);
    public static final HighlightInfoType INTERFACE_NAME = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.INTERFACE_NAME_ATTRIBUTES);
    public static final HighlightInfoType TYPE_PARAMETER_NAME = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.TYPE_PARAMETER_NAME_ATTRIBUTES);
    public static final HighlightInfoType ABSTRACT_CLASS_NAME = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.ABSTRACT_CLASS_NAME_ATTRIBUTES);
    public static final HighlightInfoType ANNOTATION_NAME = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.ANNOTATION_NAME_ATTRIBUTES);
    public static final HighlightInfoType ANNOTATION_ATTRIBUTE_NAME = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.ANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES);
    public static final HighlightInfoType REASSIGNED_LOCAL_VARIABLE = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.REASSIGNED_LOCAL_VARIABLE_ATTRIBUTES);
    public static final HighlightInfoType REASSIGNED_PARAMETER = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.REASSIGNED_PARAMETER_ATTRIBUTES);
    public static final HighlightInfoType IMPLICIT_ANONYMOUS_CLASS_PARAMETER = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.IMPLICIT_ANONYMOUS_CLASS_PARAMETER_ATTRIBUTES);
    public static final HighlightInfoType WARNING = new HighlightInfoTypeImpl(HighlightSeverity.WARNING, CodeInsightColors.WARNINGS_ATTRIBUTES);
    public static final HighlightInfoType INFO = new HighlightInfoTypeImpl(HighlightSeverity.INFO, CodeInsightColors.INFO_ATTRIBUTES);
    public static final HighlightInfoType INFORMATION = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightSeverity INJECTED_FRAGMENT_SEVERITY = new HighlightSeverity("INJECTED_FRAGMENT_SEVERITY", HighlightSeverity.INFORMATION.myVal - 1);
    public static final HighlightInfoType INJECTED_LANGUAGE_FRAGMENT = new HighlightInfoTypeImpl(INJECTED_FRAGMENT_SEVERITY, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType UNHANDLED_EXCEPTION = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES);
    public static final HighlightInfoType JAVA_KEYWORD = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, SyntaxHighlighterColors.KEYWORD);

    public HighlightSeverity getSeverity(PsiElement var1);

    public TextAttributesKey getAttributesKey();

    public static class HighlightInfoTypeSeverityByKeyAttrBySeverity
    implements HighlightInfoType {
        static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.HighlightInfoType.HighlightInfoTypeSeverityByKeyAttrBySeverity");
        private final HighlightDisplayKey mySeverityKey;

        public HighlightInfoTypeSeverityByKeyAttrBySeverity(HighlightDisplayKey severityKey) {
            this.mySeverityKey = severityKey;
        }

        @Override
        public HighlightSeverity getSeverity(PsiElement psiElement) {
            HighlightDisplayLevel level = psiElement != null ? InspectionProjectProfileManager.getInstance(psiElement.getProject()).getInspectionProfile().getErrorLevel(this.mySeverityKey, psiElement) : ((InspectionProfile)InspectionProfileManager.getInstance().getRootProfile()).getErrorLevel(this.mySeverityKey, psiElement);
            LOG.assertTrue(level != HighlightDisplayLevel.DO_NOT_SHOW);
            return level.getSeverity();
        }

        @Override
        public TextAttributesKey getAttributesKey() {
            HighlightSeverity severity = this.getSeverity(null);
            HighlightInfoTypeImpl infoType = SeverityRegistrar.getInstance().getHighlightInfoTypeBySeverity(severity);
            return infoType != null ? infoType.getAttributesKey() : (severity == HighlightSeverity.ERROR ? CodeInsightColors.ERRORS_ATTRIBUTES : (severity == HighlightSeverity.WARNING ? CodeInsightColors.WARNINGS_ATTRIBUTES : CodeInsightColors.INFO_ATTRIBUTES));
        }

        public String toString() {
            return "HighlightInfoTypeSeverityByKeyAttrBySeverity[severity=" + this.mySeverityKey + "]";
        }
    }

    public static class HighlightInfoTypeSeverityByKey
    implements HighlightInfoType {
        static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.HighlightInfoType.HighlightInfoTypeSeverityByKey");
        private final TextAttributesKey myAttributesKey;
        private final HighlightDisplayKey myToolKey;

        public HighlightInfoTypeSeverityByKey(HighlightDisplayKey severityKey, TextAttributesKey attributesKey) {
            this.myToolKey = severityKey;
            this.myAttributesKey = attributesKey;
        }

        @Override
        public HighlightSeverity getSeverity(PsiElement psiElement) {
            InspectionProfile profile = psiElement == null ? (InspectionProfile)InspectionProfileManager.getInstance().getRootProfile() : InspectionProjectProfileManager.getInstance(psiElement.getProject()).getInspectionProfile();
            HighlightDisplayLevel level = profile.getErrorLevel(this.myToolKey, psiElement);
            LOG.assertTrue(level != HighlightDisplayLevel.DO_NOT_SHOW);
            return level.getSeverity();
        }

        @Override
        public TextAttributesKey getAttributesKey() {
            return this.myAttributesKey;
        }

        public String toString() {
            return "HighlightInfoTypeSeverityByKey[severity=" + this.myToolKey + ", key=" + this.myAttributesKey + "]";
        }

        public HighlightDisplayKey getSeverityKey() {
            return this.myToolKey;
        }
    }

    public static class HighlightInfoTypeImpl
    implements HighlightInfoType,
    JDOMExternalizable {
        private final HighlightSeverity mySeverity;
        private final TextAttributesKey myAttributesKey;

        public HighlightInfoTypeImpl() {
            this.mySeverity = new HighlightSeverity();
            this.myAttributesKey = new TextAttributesKey();
        }

        public HighlightInfoTypeImpl(@NotNull HighlightSeverity severity, TextAttributesKey attributesKey) {
            if (severity == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl.<init> must not be null");
            }
            this.mySeverity = severity;
            this.myAttributesKey = attributesKey;
        }

        @Override
        public HighlightSeverity getSeverity(PsiElement psiElement) {
            return this.mySeverity;
        }

        @Override
        public TextAttributesKey getAttributesKey() {
            return this.myAttributesKey;
        }

        public String toString() {
            return "HighlightInfoTypeImpl[severity=" + this.mySeverity + ", key=" + this.myAttributesKey + "]";
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.mySeverity.readExternal(element);
            this.myAttributesKey.readExternal(element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.mySeverity.writeExternal(element);
            this.myAttributesKey.writeExternal(element);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HighlightInfoTypeImpl that = (HighlightInfoTypeImpl)o;
            if (!Comparing.equal((Object)this.myAttributesKey, (Object)that.myAttributesKey)) {
                return false;
            }
            return this.mySeverity.equals((Object)that.mySeverity);
        }

        public int hashCode() {
            int result = this.mySeverity.hashCode();
            result = 29 * result + this.myAttributesKey.hashCode();
            return result;
        }
    }
}

