/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.ShowErrorDescriptionAction;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    private final Project myProject;

    public DaemonTooltipRendererProvider(Project project) {
        this.myProject = project;
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<RangeHighlighter> highlighters) {
        if (highlighters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider.calcTooltipRenderer must not be null");
        }
        MyRenderer bigRenderer = null;
        SmartList infos = new SmartList();
        THashSet tooltips = new THashSet();
        for (RangeHighlighter marker : highlighters) {
            Object tooltipObject = marker.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info = (HighlightInfo)tooltipObject;
                if (info.toolTip == null || !tooltips.add(info.toolTip)) continue;
                infos.add(info);
                continue;
            }
            String text = tooltipObject.toString();
            if (!tooltips.add(text)) continue;
            if (bigRenderer == null) {
                bigRenderer = new MyRenderer(text);
                continue;
            }
            bigRenderer.addBelow(text);
        }
        if (!infos.isEmpty()) {
            Collections.sort(infos, new Comparator<HighlightInfo>(){

                @Override
                public int compare(HighlightInfo o1, HighlightInfo o2) {
                    int i = SeverityRegistrar.getInstance(DaemonTooltipRendererProvider.this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                    if (i != 0) {
                        return i;
                    }
                    return o1.toolTip.compareTo(o2.toolTip);
                }
            });
            HighlightInfoComposite composite = new HighlightInfoComposite((List<HighlightInfo>)infos);
            if (bigRenderer == null) {
                bigRenderer = new MyRenderer(composite.toolTip);
            } else {
                MyRenderer renderer = new MyRenderer(composite.toolTip);
                renderer.addBelow(bigRenderer.getText());
                bigRenderer = renderer;
            }
        }
        return bigRenderer;
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider.calcTooltipRenderer must not be null");
        }
        return new MyRenderer(text);
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull String text, int width) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider.calcTooltipRenderer must not be null");
        }
        return new MyRenderer(text, width);
    }

    private static class MyRenderer
    extends LineTooltipRenderer {
        public MyRenderer(String text) {
            super(text);
        }

        public MyRenderer(String text, int width) {
            super(text, width);
        }

        @Override
        protected String convertTextOnLinkHandled(String text) {
            return text.replace(" " + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]), "").replace("(" + KeymapUtil.getShortcutsText((Shortcut[])KeymapManager.getInstance().getActiveKeymap().getShortcuts("ShowErrorDescription")) + ")", "");
        }

        @Override
        protected void onHide(JComponent contentComponent) {
            ShowErrorDescriptionAction.rememberCurrentWidth(contentComponent.getWidth());
        }

        @Override
        protected boolean dressDescription(Editor editor) {
            String[] problems = MyRenderer.getHtmlBody(this.myText).split("<hr size=1 noshade>");
            String text = "";
            block0: for (String problem : problems) {
                String descriptionPrefix = MyRenderer.getDescriptionPrefix(problem);
                if (descriptionPrefix == null) continue;
                for (TooltipLinkHandlerEP handlerEP : (TooltipLinkHandlerEP[])Extensions.getExtensions(TooltipLinkHandlerEP.EP_NAME)) {
                    String description = handlerEP.getDescription(descriptionPrefix, editor);
                    if (description == null) continue;
                    text = text + MyRenderer.getHtmlBody(problem).replace(DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]), DaemonBundle.message((String)"inspection.collapse.description", (Object[])new Object[0])) + "<hr size=1 noshade>" + MyRenderer.getHtmlBody(description) + "<hr size=1 noshade>";
                    continue block0;
                }
            }
            if (text.length() > 0) {
                this.myText = "<html><body>" + StringUtil.trimEnd((String)text, (String)"<hr size=1 noshade>") + "</body></html>";
                return true;
            }
            return false;
        }

        @Nullable
        private static String getDescriptionPrefix(@NonNls String text) {
            String ref;
            int quatIdx;
            int linkIdx = text.indexOf("<a href=");
            if (linkIdx != -1 && (quatIdx = (ref = text.substring(linkIdx + 9)).indexOf(34)) > 0) {
                return ref.substring(0, quatIdx);
            }
            return null;
        }

        @Override
        protected void stripDescription() {
            String[] problems = MyRenderer.getHtmlBody(this.myText).split("<hr size=1 noshade>");
            this.myText = "<html><body>";
            for (int i = 0; i < problems.length; ++i) {
                String problem = problems[i];
                if (i % 2 != 0) continue;
                this.myText = this.myText + MyRenderer.getHtmlBody(problem).replace(DaemonBundle.message((String)"inspection.collapse.description", (Object[])new Object[0]), DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0])) + "<hr size=1 noshade>";
            }
            this.myText = StringUtil.trimEnd((String)this.myText, (String)"<hr size=1 noshade>") + "</body></html>";
        }

        @Override
        protected LineTooltipRenderer createRenderer(String text, int width) {
            return new MyRenderer(text, width);
        }
    }
}

