/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipUtil;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.codeInsight.daemon.impl.ErrorStripeHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.PsiChangeHandler;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DaemonListeners
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonListeners");
    private final ApplicationListener myApplicationListener = new MyApplicationListener();
    private final EditorColorsListener myEditorColorsListener = new MyEditorColorsListener();
    private final PropertyChangeListener myTodoListener = new MyTodoListener();
    private final EditorFactoryListener myEditorFactoryListener;
    private final Project myProject;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final ModalityStateListener myModalityStateListener;
    private boolean myEscPressed;
    private final ErrorStripeHandler myErrorStripeHandler;
    private volatile boolean cutOperationJustHappened;
    private final EditorTracker myEditorTracker;
    private final EditorTrackerListener myEditorTrackerListener;

    public DaemonListeners(Project project, DaemonCodeAnalyzerImpl daemonCodeAnalyzer, EditorTracker editorTracker) {
        this.myProject = project;
        this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                VirtualFile virtualFile;
                Document document = e.getDocument();
                if (!DaemonListeners.this.worthBothering(document, (virtualFile = FileDocumentManager.getInstance().getFile(document)) == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile))) {
                    return;
                }
                DaemonListeners.this.stopDaemon(true);
                UpdateHighlightersUtil.updateHighlightersByTyping(DaemonListeners.this.myProject, e);
            }
        }, (Disposable)this);
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                Editor editor = e.getEditor();
                if (!DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject())) {
                    return;
                }
                DaemonListeners.this.stopDaemon(true);
                DaemonListeners.this.myDaemonCodeAnalyzer.hideLastIntentionHint();
            }
        }, (Disposable)this);
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)new MyEditorMouseMotionListener(), (Disposable)this);
        eventMulticaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), (Disposable)this);
        this.myEditorTracker = editorTracker;
        this.myEditorTrackerListener = new EditorTrackerListener(){
            private List<Editor> myActiveEditors = Collections.emptyList();

            @Override
            public void activeEditorsChanged(@NotNull List<Editor> editors) {
                if (editors == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonListeners$3.activeEditorsChanged must not be null");
                }
                List<Editor> activeEditors = DaemonListeners.this.myEditorTracker.getActiveEditors();
                if (!((Object)this.myActiveEditors).equals(activeEditors)) {
                    this.myActiveEditors = activeEditors;
                    DaemonListeners.this.stopDaemon(true);
                }
            }
        };
        this.myEditorTracker.addEditorTrackerListener(this.myEditorTrackerListener);
        this.myEditorFactoryListener = new EditorFactoryAdapter(){

            public void editorCreated(EditorFactoryEvent event) {
                Editor editor = event.getEditor();
                Document document = editor.getDocument();
                if (!DaemonListeners.this.worthBothering(document, editor.getProject())) {
                    return;
                }
                DaemonListeners.this.myDaemonCodeAnalyzer.repaintErrorStripeRenderer(editor);
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener(this.myEditorFactoryListener);
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiChangeHandler changeHandler = new PsiChangeHandler(this.myProject, daemonCodeAnalyzer, documentManager, EditorFactory.getInstance(), connection);
        Disposer.register((Disposable)this, (Disposable)changeHandler);
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)changeHandler, (Disposable)changeHandler);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                final FileEditor[] editors = FileEditorManager.getInstance((Project)DaemonListeners.this.myProject).getSelectedEditors();
                if (editors.length == 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DaemonListeners.this.myProject.isDisposed()) {
                            return;
                        }
                        for (FileEditor fileEditor : editors) {
                            if (!(fileEditor instanceof TextEditor)) continue;
                            DaemonListeners.this.myDaemonCodeAnalyzer.repaintErrorStripeRenderer(((TextEditor)fileEditor).getEditor());
                        }
                    }
                }, ModalityState.stateForComponent((Component)editors[0].getComponent()));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                DaemonListeners.this.stopDaemon(true);
            }

            public void exitDumbMode() {
                DaemonListeners.this.stopDaemon(true);
            }
        });
        CommandProcessor.getInstance().addCommandListener((CommandListener)new MyCommandListener(), (Disposable)this);
        ApplicationManager.getApplication().addApplicationListener(this.myApplicationListener);
        EditorColorsManager.getInstance().addEditorColorsListener(this.myEditorColorsListener);
        InspectionProfileManager.getInstance().addProfileChangeListener(new MyProfileChangeListener(), this);
        TodoConfiguration.getInstance().addPropertyChangeListener(this.myTodoListener);
        ActionManagerEx.getInstanceEx().addAnActionListener(new MyAnActionListener(), this);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void propertyChanged(VirtualFilePropertyEvent event) {
                if ("name".equals(event.getPropertyName())) {
                    Document document;
                    DaemonListeners.this.myDaemonCodeAnalyzer.restart();
                    PsiFile psiFile = PsiManager.getInstance((Project)DaemonListeners.this.myProject).findFile(event.getFile());
                    if (psiFile != null && !DaemonListeners.this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile) && (document = FileDocumentManager.getInstance().getCachedDocument(event.getFile())) != null) {
                        UpdateHighlightersUtil.setHighlightersToEditor(DaemonListeners.this.myProject, document, 0, document.getTextLength(), Collections.<HighlightInfo>emptyList(), 4);
                    }
                }
            }
        }, (Disposable)this);
        this.myErrorStripeHandler = new ErrorStripeHandler(this.myProject);
        ((EditorEventMulticasterEx)eventMulticaster).addErrorStripeListener(this.myErrorStripeHandler);
        NamedScopesHolder[] holders = NamedScopesHolder.getAllNamedScopeHolders((Project)project);
        NamedScopesHolder.ScopeListener scopeListener = new NamedScopesHolder.ScopeListener(){

            public void scopesChanged() {
                DaemonListeners.this.myDaemonCodeAnalyzer.reloadScopes();
            }
        };
        for (NamedScopesHolder holder : holders) {
            holder.addScopeListener(scopeListener);
        }
        this.myModalityStateListener = new ModalityStateListener(){

            public void beforeModalityStateChanged(boolean entering) {
                DaemonListeners.this.stopDaemon(LaterInvocator.isInModalContext());
            }
        };
        LaterInvocator.addModalityStateListener(this.myModalityStateListener);
    }

    private boolean worthBothering(Document document, Project project) {
        if (document == null) {
            return true;
        }
        if (project != null && project != this.myProject) {
            return false;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)(project == null ? this.myProject : project)).getPsiFile(document);
        return psiFile != null;
    }

    public void dispose() {
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        EditorFactory.getInstance().removeEditorFactoryListener(this.myEditorFactoryListener);
        ApplicationManager.getApplication().removeApplicationListener(this.myApplicationListener);
        EditorColorsManager.getInstance().removeEditorColorsListener(this.myEditorColorsListener);
        TodoConfiguration.getInstance().removePropertyChangeListener(this.myTodoListener);
        ((EditorEventMulticasterEx)eventMulticaster).removeErrorStripeListener(this.myErrorStripeHandler);
        this.myEditorTracker.removeEditorTrackerListener(this.myEditorTrackerListener);
        LaterInvocator.removeModalityStateListener(this.myModalityStateListener);
    }

    boolean canChangeFileSilently(PsiFileSystemItem file) {
        if (this.cutOperationJustHappened) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file instanceof PsiCodeFragment) {
            return true;
        }
        Project project = file.getProject();
        if (!ModuleUtil.projectContainsFile((Project)project, (VirtualFile)virtualFile, (boolean)false)) {
            return false;
        }
        Result vcs = this.vcsThinksItChanged(virtualFile, project);
        if (vcs == Result.CHANGED) {
            return true;
        }
        if (vcs == Result.UNCHANGED) {
            return false;
        }
        return this.canUndo(virtualFile);
    }

    private boolean canUndo(VirtualFile virtualFile) {
        for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getEditors(virtualFile)) {
            if (!UndoManagerImpl.getInstance((Project)this.myProject).isUndoAvailable(editor)) continue;
            return true;
        }
        return false;
    }

    private Result vcsThinksItChanged(VirtualFile virtualFile, Project project) {
        boolean vcsIsThinking;
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(virtualFile);
        if (activeVcs == null) {
            return Result.NOT_SURE;
        }
        FilePathImpl path = new FilePathImpl(virtualFile);
        boolean bl = vcsIsThinking = !VcsDirtyScopeManager.getInstance((Project)this.myProject).whatFilesDirty(Arrays.asList(path)).isEmpty();
        if (vcsIsThinking) {
            return Result.UNCHANGED;
        }
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
        return status == FileStatus.MODIFIED || status == FileStatus.ADDED ? Result.CHANGED : Result.UNCHANGED;
    }

    private void stopDaemon(boolean toRestartAlarm) {
        this.myDaemonCodeAnalyzer.stopProcess(toRestartAlarm);
    }

    Collection<FileEditor> getSelectedEditors() {
        FileEditor[] tabEditors;
        List<Editor> editors = this.myEditorTracker.getActiveEditors();
        THashSet activeFileEditors = new THashSet(editors.size());
        for (Editor editor : editors) {
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
            activeFileEditors.add(textEditor);
        }
        if (ApplicationManager.getApplication().getCurrentModalityState() != ModalityState.NON_MODAL) {
            return activeFileEditors;
        }
        THashSet result = new THashSet();
        THashSet documents = new THashSet(activeFileEditors.size());
        for (FileEditor tabEditor : tabEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
            if (tabEditor instanceof TextEditor) {
                documents.add(((TextEditor)tabEditor).getEditor().getDocument());
            }
            result.add(tabEditor);
        }
        for (FileEditor fileEditor : activeFileEditors) {
            if (fileEditor instanceof TextEditor && documents.contains(((TextEditor)fileEditor).getEditor().getDocument())) continue;
            result.add(fileEditor);
        }
        return result;
    }

    private class MyEditorMouseMotionListener
    implements EditorMouseMotionListener {
        private MyEditorMouseMotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(EditorMouseEvent e) {
            Editor editor = e.getEditor();
            if (DaemonListeners.this.myProject != editor.getProject()) {
                return;
            }
            boolean shown = false;
            try {
                LogicalPosition pos = editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
                if (e.getArea() == EditorMouseEventArea.EDITING_AREA) {
                    int offset = editor.logicalPositionToOffset(pos);
                    if (editor.offsetToLogicalPosition((int)offset).column != pos.column) {
                        return;
                    }
                    HighlightInfo info = DaemonListeners.this.myDaemonCodeAnalyzer.findHighlightByOffset(editor.getDocument(), offset, false);
                    if (info == null || info.description == null) {
                        return;
                    }
                    DaemonTooltipUtil.showInfoTooltip(info, editor, offset);
                    shown = true;
                }
            }
            finally {
                if (!shown && !TooltipController.getInstance().shouldSurvive(e.getMouseEvent())) {
                    DaemonTooltipUtil.cancelTooltips();
                }
            }
        }

        public void mouseDragged(EditorMouseEvent e) {
            TooltipController.getInstance().cancelTooltips();
        }
    }

    private static class MyEditorMouseListener
    extends EditorMouseAdapter {
        private MyEditorMouseListener() {
        }

        public void mouseExited(EditorMouseEvent e) {
            if (!TooltipController.getInstance().shouldSurvive(e.getMouseEvent())) {
                DaemonTooltipUtil.cancelTooltips();
            }
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private final AnAction escapeAction = ActionManager.getInstance().getAction("EditorEscape");

        private MyAnActionListener() {
        }

        @Override
        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            DaemonListeners.this.myEscPressed = action == this.escapeAction;
        }

        @Override
        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        @Override
        public void beforeEditorTyping(char c, DataContext dataContext) {
            Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
            if (editor != null && !DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject())) {
                return;
            }
            DaemonListeners.this.stopDaemon(true);
        }
    }

    private class MyProfileChangeListener
    extends ProfileChangeAdapter {
        private MyProfileChangeListener() {
        }

        public void profileChanged(Profile profile) {
            DaemonListeners.this.myDaemonCodeAnalyzer.restart();
        }

        public void profileActivated(Profile oldProfile, Profile profile) {
            DaemonListeners.this.myDaemonCodeAnalyzer.restart();
        }
    }

    private class MyTodoListener
    implements PropertyChangeListener {
        private MyTodoListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("todoPatterns".equals(evt.getPropertyName())) {
                DaemonListeners.this.myDaemonCodeAnalyzer.restart();
            }
        }
    }

    private class MyEditorColorsListener
    implements EditorColorsListener {
        private MyEditorColorsListener() {
        }

        public void globalSchemeChange(EditorColorsScheme scheme) {
            DaemonListeners.this.myDaemonCodeAnalyzer.restart();
        }
    }

    private class MyCommandListener
    extends CommandAdapter {
        private final Object myCutActionName = ActionManager.getInstance().getAction("EditorCut").getTemplatePresentation().getText();

        private MyCommandListener() {
        }

        public void commandStarted(CommandEvent event) {
            Document affectedDocument = this.extractDocumentFromCommand(event);
            if (!DaemonListeners.this.worthBothering(affectedDocument, event.getProject())) {
                return;
            }
            DaemonListeners.this.cutOperationJustHappened = this.myCutActionName.equals(event.getCommandName());
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelling code highlighting by command:" + event.getCommand());
            }
            DaemonListeners.this.stopDaemon(false);
        }

        private Document extractDocumentFromCommand(CommandEvent event) {
            Document affectedDocument = event.getDocument();
            if (affectedDocument != null) {
                return affectedDocument;
            }
            Object id = event.getCommandGroupId();
            if (id instanceof Document) {
                affectedDocument = (Document)id;
            } else if (id instanceof DocCommandGroupId) {
                affectedDocument = ((DocCommandGroupId)id).getDocument();
            }
            return affectedDocument;
        }

        public void commandFinished(CommandEvent event) {
            Document affectedDocument = this.extractDocumentFromCommand(event);
            if (!DaemonListeners.this.worthBothering(affectedDocument, event.getProject())) {
                return;
            }
            if (DaemonListeners.this.myEscPressed) {
                DaemonListeners.this.myEscPressed = false;
                if (affectedDocument != null && !DaemonListeners.this.myDaemonCodeAnalyzer.getFileStatusMap().allDirtyScopesAreNull(affectedDocument)) {
                    DaemonListeners.this.stopDaemon(true);
                }
            } else if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                DaemonListeners.this.stopDaemon(true);
            }
        }
    }

    private class MyApplicationListener
    extends ApplicationAdapter {
        private MyApplicationListener() {
        }

        public void beforeWriteActionStart(Object action) {
            Document document;
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelling code highlighting by write action:" + action);
            }
            if (action instanceof DocumentRunnable && !DaemonListeners.this.worthBothering(document = ((DocumentRunnable)action).getDocument(), ((DocumentRunnable)action).getProject())) {
                return;
            }
            DaemonListeners.this.stopDaemon(false);
        }

        public void writeActionFinished(Object action) {
            Document document;
            if (DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            if (action instanceof DocumentRunnable && !DaemonListeners.this.worthBothering(document = ((DocumentRunnable)action).getDocument(), ((DocumentRunnable)action).getProject())) {
                return;
            }
            DaemonListeners.this.stopDaemon(true);
        }
    }

    private static enum Result {
        CHANGED,
        UNCHANGED,
        NOT_SURE;

    }
}

