/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.simple;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodInsertHandler
implements InsertHandler<LookupItem<PsiMethod>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.simple.PsiMethodInsertHandler");
    private final PsiMethod myMethod;

    public PsiMethodInsertHandler(PsiMethod method) {
        this.myMethod = method;
    }

    public void handleInsert(InsertionContext context, LookupItem<PsiMethod> item) {
        Editor editor = context.getEditor();
        char completionChar = context.getCompletionChar();
        TailType tailType = PsiMethodInsertHandler.getTailType(item, context);
        Document document = editor.getDocument();
        PsiFile file = context.getFile();
        int offset = editor.getCaretModel().getOffset();
        context.setAddCompletionChar(false);
        LookupElement[] allItems = context.getElements();
        boolean overloadsMatter = allItems.length == 1 && item.getUserData(LookupItem.FORCE_SHOW_SIGNATURE_ATTR) == null;
        boolean hasParams = MethodParenthesesHandler.hasParams(item, (LookupElement[])allItems, (boolean)overloadsMatter, (PsiMethod)this.myMethod);
        boolean needLeftParenth = PsiMethodInsertHandler.isToInsertParenth(file.findElementAt(context.getStartOffset()));
        boolean needRightParenth = this.shouldInsertRParenth(completionChar, tailType, hasParams);
        if (needLeftParenth) {
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
            new MethodParenthesesHandler(this.myMethod, overloadsMatter, styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES && hasParams, needRightParenth).handleInsert(context, item);
        }
        PsiMethodInsertHandler.insertExplicitTypeParams(item, document, offset, file);
        PsiType type = this.myMethod.getReturnType();
        if (completionChar == '!' && type != null && PsiType.BOOLEAN.isAssignableFrom(type)) {
            PsiDocumentManager.getInstance((Project)this.myMethod.getProject()).commitDocument(document);
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiMethodCallExpression.class, (boolean)false);
            if (methodCall != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
                document.insertString(methodCall.getTextRange().getStartOffset(), (CharSequence)"!");
            }
        }
        if (needLeftParenth && hasParams) {
            AutoPopupController.getInstance(this.myMethod.getProject()).autoPopupParameterInfo(editor, (PsiElement)(overloadsMatter ? null : this.myMethod));
        }
        if (tailType == TailType.SMART_COMPLETION || needLeftParenth && needRightParenth) {
            tailType.processTail(editor, context.getTailOffset());
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private boolean shouldInsertRParenth(char completionChar, TailType tailType, boolean hasParams) {
        if (tailType == TailType.SMART_COMPLETION) {
            return false;
        }
        if (completionChar == '(' && !hasParams) {
            return CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static TailType getTailType(LookupItem item, InsertionContext context) {
        TailType tailType;
        char completionChar = context.getCompletionChar();
        if (completionChar == '!') {
            tailType = item.getTailType();
            if (tailType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/simple/PsiMethodInsertHandler.getTailType must not return null");
            return tailType;
        }
        if (completionChar == '(') {
            PsiMethod psiMethod = (PsiMethod)item.getObject();
            tailType = psiMethod.getParameterList().getParameters().length > 0 || psiMethod.getReturnType() != PsiType.VOID ? TailType.NONE : TailType.SEMICOLON;
            if (tailType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/simple/PsiMethodInsertHandler.getTailType must not return null");
            return tailType;
        }
        if (completionChar == '\r') {
            tailType = TailType.SMART_COMPLETION;
            if (tailType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/simple/PsiMethodInsertHandler.getTailType must not return null");
            return tailType;
        }
        if (!context.shouldAddCompletionChar()) {
            tailType = TailType.NONE;
            if (tailType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/simple/PsiMethodInsertHandler.getTailType must not return null");
            return tailType;
        }
        tailType = LookupItem.handleCompletionChar(context.getEditor(), (LookupElement)item, completionChar);
        if (tailType != null) return tailType;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/simple/PsiMethodInsertHandler.getTailType must not return null");
    }

    private static boolean isToInsertParenth(PsiElement place) {
        if (place == null) {
            return true;
        }
        return !(place.getParent() instanceof PsiImportStaticReferenceElement);
    }

    private static void insertExplicitTypeParams(LookupItem<PsiMethod> item, Document document, int offset, PsiFile file) {
        PsiMethod method = item.getObject();
        if (!SmartCompletionDecorator.hasUnboundTypeParams(method)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        PsiExpression expression = (PsiExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset - 1), PsiExpression.class, (boolean)false);
        if (expression == null) {
            return;
        }
        Project project = file.getProject();
        ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getInstance(project).getExpectedTypes(expression, true, false);
        if (expectedTypes == null) {
            return;
        }
        for (ExpectedTypeInfo type : expectedTypes) {
            if (!type.isInsertExplicitTypeParams()) continue;
            OffsetMap map = new OffsetMap(document);
            OffsetKey refOffsetKey = OffsetKey.create((String)"refOffset");
            map.addOffset(refOffsetKey, offset - 1);
            String typeParams = PsiMethodInsertHandler.getTypeParamsText(method, type.getType());
            if (typeParams == null) {
                return;
            }
            String qualifierText = PsiMethodInsertHandler.getQualifierText(file, method, offset - 1);
            document.insertString(offset - method.getName().length(), (CharSequence)(qualifierText + typeParams));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiReference reference = file.findReferenceAt(map.getOffset(refOffsetKey));
            if (reference instanceof PsiJavaCodeReferenceElement) {
                try {
                    CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)reference));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return;
        }
    }

    private static String getQualifierText(PsiFile file, PsiMethod method, int refOffset) {
        PsiReference reference = file.findReferenceAt(refOffset);
        if (reference instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)reference).isQualified()) {
            return "";
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return "";
        }
        if (method.hasModifierProperty("static")) {
            return containingClass.getQualifiedName() + ".";
        }
        if (containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)refOffset, PsiClass.class, (boolean)false))) {
            return "this.";
        }
        return containingClass.getQualifiedName() + ".this.";
    }

    @Nullable
    private static String getTypeParamsText(PsiMethod method, PsiType expectedType) {
        PsiSubstitutor substitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, expectedType);
        assert (substitutor != null);
        PsiTypeParameter[] parameters = method.getTypeParameters();
        assert (parameters.length > 0);
        StringBuilder builder = new StringBuilder("<");
        boolean first = true;
        for (PsiTypeParameter parameter : parameters) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            PsiType type = substitutor.substitute(parameter);
            if (type == null || type instanceof PsiWildcardType || type instanceof PsiCapturedWildcardType) {
                return null;
            }
            String text = type.getCanonicalText();
            if (text.indexOf(63) >= 0) {
                return null;
            }
            builder.append(text);
        }
        return builder.append(">").toString();
    }
}

