/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor");
    protected final Project myProject;
    private final Module myModule;
    private PsiDirectory myDirectory;
    private PsiFile myFile;
    private PsiFile[] myFiles;
    private boolean myIncludeSubdirs;
    private final String myProgressText;
    private final String myCommandName;
    private final Runnable myPostRunnable;

    protected AbstractLayoutCodeProcessor(Project project, String commandName, String progressText) {
        this.myProject = project;
        this.myModule = null;
        this.myDirectory = null;
        this.myIncludeSubdirs = true;
        this.myCommandName = commandName;
        this.myProgressText = progressText;
        this.myPostRunnable = null;
    }

    protected AbstractLayoutCodeProcessor(Project project, Module module, String commandName, String progressText) {
        this.myProject = project;
        this.myModule = module;
        this.myDirectory = null;
        this.myIncludeSubdirs = true;
        this.myCommandName = commandName;
        this.myProgressText = progressText;
        this.myPostRunnable = null;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, String progressText, String commandName) {
        this.myProject = project;
        this.myModule = null;
        this.myDirectory = directory;
        this.myIncludeSubdirs = includeSubdirs;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiFile file, String progressText, String commandName) {
        this.myProject = project;
        this.myModule = null;
        this.myFile = file;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
    }

    protected AbstractLayoutCodeProcessor(Project project, PsiFile[] files, String progressText, String commandName, Runnable postRunnable) {
        this.myProject = project;
        this.myModule = null;
        this.myFiles = AbstractLayoutCodeProcessor.filterFiles(files);
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = postRunnable;
    }

    private static PsiFile[] filterFiles(PsiFile[] files) {
        ArrayList<PsiFile> list = new ArrayList<PsiFile>();
        for (PsiFile file : files) {
            if (!AbstractLayoutCodeProcessor.isFormatable(file)) continue;
            list.add(file);
        }
        return list.toArray(new PsiFile[list.size()]);
    }

    @NotNull
    protected abstract Runnable preprocessFile(PsiFile var1) throws IncorrectOperationException;

    public void run() {
        if (this.myDirectory != null) {
            this.runProcessDirectory(this.myDirectory, this.myIncludeSubdirs);
        } else if (this.myFiles != null) {
            this.runProcessFiles(this.myFiles);
        } else if (this.myFile != null) {
            this.runProcessFile(this.myFile);
        } else if (this.myModule != null) {
            this.runProcessOnModule(this.myModule);
        } else if (this.myProject != null) {
            this.runProcessOnProject(this.myProject);
        }
    }

    private void runProcessFile(final PsiFile file) {
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document == null) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(document, this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)PsiBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{file.getName()}), (String)CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        final Runnable[] resultRunnable = new Runnable[1];
        Runnable readAction = new Runnable(){

            @Override
            public void run() {
                if (!AbstractLayoutCodeProcessor.this.checkFileWritable(file)) {
                    return;
                }
                try {
                    resultRunnable[0] = AbstractLayoutCodeProcessor.this.preprocessFile(file);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        Runnable writeAction = new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        };
        this.runLayoutCodeProcess(readAction, writeAction);
    }

    private boolean checkFileWritable(PsiFile file) {
        if (!file.isWritable()) {
            ((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(this.myProject, file.getVirtualFile()).setTitle(CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]))).showLater();
            return false;
        }
        return true;
    }

    @Nullable
    private Runnable preprocessFiles(List<PsiFile> files) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        String oldText = null;
        double oldFraction = 0.0;
        if (progress != null) {
            oldText = progress.getText();
            oldFraction = progress.getFraction();
            progress.setText(this.myProgressText);
        }
        final Runnable[] runnables = new Runnable[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            PsiFile file = files.get(i);
            if (progress != null) {
                if (progress.isCanceled()) {
                    return null;
                }
                progress.setFraction((double)i / (double)files.size());
            }
            if (file.isWritable()) {
                try {
                    runnables[i] = this.preprocessFile(file);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            files.set(i, null);
        }
        if (progress != null) {
            progress.setText(oldText);
            progress.setFraction(oldFraction);
        }
        return new Runnable(){

            @Override
            public void run() {
                for (Runnable runnable : runnables) {
                    if (runnable == null) continue;
                    runnable.run();
                }
            }
        };
    }

    private void runProcessFiles(final PsiFile[] files) {
        final Runnable[] resultRunnable = new Runnable[1];
        this.runLayoutCodeProcess(new Runnable(){

            @Override
            public void run() {
                resultRunnable[0] = AbstractLayoutCodeProcessor.this.preprocessFiles(new ArrayList<PsiFile>(Arrays.asList(files)));
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        });
    }

    private void runProcessDirectory(PsiDirectory directory, boolean recursive) {
        ArrayList<PsiFile> array = new ArrayList<PsiFile>();
        AbstractLayoutCodeProcessor.collectFilesToProcess(array, directory, recursive);
        String where = CodeInsightBundle.message((String)"process.scope.directory", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl()});
        this.runProcessOnFiles(where, array);
    }

    private void runProcessOnProject(Project project) {
        ArrayList<PsiFile> array = new ArrayList<PsiFile>();
        this.collectFilesInProject(project, array);
        String where = CodeInsightBundle.message((String)"process.scope.project", (Object[])new Object[]{project.getPresentableUrl()});
        this.runProcessOnFiles(where, array);
    }

    private void runProcessOnModule(Module module) {
        ArrayList<PsiFile> array = new ArrayList<PsiFile>();
        this.collectFilesInModule(module, array);
        String where = CodeInsightBundle.message((String)"process.scope.module", (Object[])new Object[]{module.getModuleFilePath()});
        this.runProcessOnFiles(where, array);
    }

    private void collectFilesInProject(Project project, ArrayList<PsiFile> array) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            this.collectFilesInModule(module, array);
        }
    }

    private void collectFilesInModule(Module module, ArrayList<PsiFile> array) {
        VirtualFile[] contentRoots;
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PsiDirectory dir = PsiManager.getInstance((Project)this.myProject).findDirectory(root);
            if (dir == null) continue;
            AbstractLayoutCodeProcessor.collectFilesToProcess(array, dir, true);
        }
    }

    private void runProcessOnFiles(String where, final List<PsiFile> array) {
        boolean success = CodeInsightUtilBase.preparePsiElementsForWrite(array);
        if (!success) {
            ArrayList<PsiFile> writeables = new ArrayList<PsiFile>();
            for (PsiFile file : array) {
                if (!file.isWritable()) continue;
                writeables.add(file);
            }
            if (writeables.isEmpty()) {
                return;
            }
            int res = Messages.showOkCancelDialog((Project)this.myProject, (String)CodeInsightBundle.message((String)"error.dialog.readonly.files.message", (Object[])new Object[]{where}), (String)CodeInsightBundle.message((String)"error.dialog.readonly.files.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (res != 0) {
                return;
            }
            array.clear();
            array.addAll(writeables);
        }
        final Runnable[] resultRunnable = new Runnable[1];
        this.runLayoutCodeProcess(new Runnable(){

            @Override
            public void run() {
                resultRunnable[0] = AbstractLayoutCodeProcessor.this.preprocessFiles(array);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (resultRunnable[0] != null) {
                    resultRunnable[0].run();
                }
            }
        });
    }

    private static boolean isFormatable(PsiFile file) {
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file) != null;
    }

    private static void collectFilesToProcess(ArrayList<PsiFile> array, PsiDirectory dir, boolean recursive) {
        PsiFile[] files;
        for (PsiFile file : files = dir.getFiles()) {
            if (!AbstractLayoutCodeProcessor.isFormatable(file)) continue;
            array.add(file);
        }
        if (recursive) {
            PsiDirectory[] subdirs;
            for (PsiDirectory subdir : subdirs = dir.getSubdirectories()) {
                AbstractLayoutCodeProcessor.collectFilesToProcess(array, subdir, recursive);
            }
        }
    }

    private void runLayoutCodeProcess(final Runnable readAction, final Runnable writeAction) {
        final ProgressWindow progressWindow = new ProgressWindow(true, this.myProject);
        progressWindow.setTitle(this.myCommandName);
        progressWindow.setText(this.myProgressText);
        final ModalityState modalityState = ModalityState.current();
        final Runnable process = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(readAction);
            }
        };
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().runProcess(process, (ProgressIndicator)progressWindow);
                }
                catch (ProcessCanceledException e) {
                    return;
                }
                Runnable writeRunnable = new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(AbstractLayoutCodeProcessor.this.myProject, new Runnable(){

                            @Override
                            public void run() {
                                CommandProcessor.getInstance().markCurrentCommandAsGlobal(AbstractLayoutCodeProcessor.this.myProject);
                                ApplicationManager.getApplication().runWriteAction(writeAction);
                                if (AbstractLayoutCodeProcessor.this.myPostRunnable != null) {
                                    ApplicationManager.getApplication().invokeLater(AbstractLayoutCodeProcessor.this.myPostRunnable);
                                }
                            }
                        }, AbstractLayoutCodeProcessor.this.myCommandName, null);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    writeRunnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(writeRunnable, modalityState, AbstractLayoutCodeProcessor.this.myProject.getDisposed());
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }
    }

    public void runWithoutProgress() throws IncorrectOperationException {
        Runnable runnable = this.preprocessFile(this.myFile);
        runnable.run();
    }
}

