/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.PrintManager;
import com.intellij.codeEditor.printing.TextPainter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;

class MultiFilePainter
implements Printable {
    private final ArrayList myFilesList;
    private int myFileIndex = 0;
    private int myStartPageIndex = 0;
    private Printable myTextPainter = null;
    private final Project myProject;
    private ProgressIndicator myProgress;

    public MultiFilePainter(ArrayList filesList, Project project) {
        this.myFilesList = filesList;
        this.myProject = project;
    }

    public void setProgress(ProgressIndicator progress) {
        this.myProgress = progress;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.myProgress.isCanceled()) {
            return 1;
        }
        while (this.myFileIndex < this.myFilesList.size()) {
            if (this.myTextPainter == null) {
                this.myTextPainter = PrintManager.initTextPainter((PsiFile)this.myFilesList.get(this.myFileIndex), this.myProject);
            }
            if (this.myTextPainter != null) {
                ((TextPainter)this.myTextPainter).setProgress(this.myProgress);
                int ret = this.myTextPainter.print(g, pageFormat, pageIndex - this.myStartPageIndex);
                if (this.myProgress.isCanceled()) {
                    return 1;
                }
                if (ret == 0) {
                    return 0;
                }
                this.myTextPainter = null;
                this.myStartPageIndex = pageIndex;
            }
            ++this.myFileIndex;
        }
        return 1;
    }
}

