/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.SelectFontDialog;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.TailPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FontOptions
extends JPanel
implements OptionsPanel {
    private final ColorAndFontOptions myOptions;
    private JTextField myEditorFontSizeField;
    private JTextField myLineSpacingField;
    private JTextField myFontNameField;
    private static ArrayList<String> myFontNamesVector;
    private static HashMap<String, Boolean> myFontNameToIsMonospaced;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myIsInSchemeChange = false;

    public FontOptions(ColorAndFontOptions options) {
        super(new BorderLayout());
        this.myOptions = options;
        JPanel schemesGroup = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createFontPanel(), "North");
        schemesGroup.add((Component)panel, "Center");
        this.add((Component)schemesGroup, "Center");
    }

    @Override
    public void updateOptionsList() {
        this.myIsInSchemeChange = true;
        this.myLineSpacingField.setText(Float.toString(this.getCurrentScheme().getLineSpacing()));
        this.myEditorFontSizeField.setText(Integer.toString(this.getCurrentScheme().getEditorFontSize()));
        this.myFontNameField.setText(this.getCurrentScheme().getEditorFontName());
        if (ColorAndFontOptions.isReadOnly(this.myOptions.getSelectedScheme())) {
            this.myLineSpacingField.setEnabled(false);
            this.myEditorFontSizeField.setEditable(false);
            this.myFontNameField.setEnabled(false);
        } else {
            this.myLineSpacingField.setEnabled(true);
            this.myEditorFontSizeField.setEditable(true);
            this.myFontNameField.setEnabled(true);
        }
        this.myIsInSchemeChange = false;
    }

    @Override
    public Runnable showOption(String option) {
        return null;
    }

    @Override
    public void applyChangesToScheme() {
    }

    @Override
    public void selectOption(String typeToSelect) {
    }

    private EditorColorsScheme getCurrentScheme() {
        return this.myOptions.getSelectedScheme();
    }

    private JPanel createFontPanel() {
        JPanel editorFontPanel = new JPanel();
        editorFontPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"group.editor.font", (Object[])new Object[0])));
        editorFontPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        gbConstraints.gridwidth = 1;
        editorFontPanel.add((Component)new JLabel(ApplicationBundle.message((String)"label.font.name", (Object[])new Object[0])), gbConstraints);
        this.myFontNameField = new MyTextField(20);
        this.myFontNameField.setEditable(false);
        this.myFontNameField.setFocusable(false);
        gbConstraints.gridx = 1;
        gbConstraints.insets = new Insets(0, 0, 0, 2);
        editorFontPanel.add((Component)this.myFontNameField, gbConstraints);
        FixedSizeButton myFontNameButton = new FixedSizeButton((JComponent)this.myFontNameField);
        gbConstraints.gridx = 2;
        gbConstraints.insets = new Insets(0, 0, 0, 8);
        editorFontPanel.add((Component)myFontNameButton, gbConstraints);
        gbConstraints.gridx = 3;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        editorFontPanel.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.font.size", (Object[])new Object[0])), gbConstraints);
        gbConstraints.gridx = 4;
        gbConstraints.insets = new Insets(0, 0, 0, 8);
        this.myEditorFontSizeField = new MyTextField(4);
        gbConstraints.gridx = 5;
        editorFontPanel.add((Component)this.myEditorFontSizeField, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        gbConstraints.gridx = 6;
        editorFontPanel.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.line.spacing", (Object[])new Object[0])), gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        gbConstraints.gridx = 7;
        this.myLineSpacingField = new MyTextField(4);
        editorFontPanel.add((Component)this.myLineSpacingField, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 8;
        editorFontPanel.add((Component)new TailPanel(), gbConstraints);
        myFontNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorColorsScheme current = FontOptions.this.getCurrentScheme();
                if (ColorAndFontOptions.isReadOnly(current) || ColorSettingsUtil.isSharedScheme(current)) {
                    FontOptions.showReadOnlyMessage(FontOptions.this, ColorSettingsUtil.isSharedScheme(current));
                    return;
                }
                FontOptions.this.selectFont();
            }
        });
        this.myEditorFontSizeField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void textChanged(DocumentEvent event) {
                if (FontOptions.this.myIsInSchemeChange) {
                    return;
                }
                int fontSize = 12;
                try {
                    fontSize = Integer.parseInt(FontOptions.this.myEditorFontSizeField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                }
                finally {
                    if (fontSize < 1) {
                        fontSize = 1;
                    }
                    if (fontSize > 30) {
                        fontSize = 30;
                    }
                    FontOptions.this.getCurrentScheme().setEditorFontSize(fontSize);
                    FontOptions.this.updateDescription(true);
                }
            }
        });
        this.myLineSpacingField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void textChanged(DocumentEvent event) {
                if (FontOptions.this.myIsInSchemeChange) {
                    return;
                }
                float lineSpacing = 1.0f;
                try {
                    lineSpacing = Float.parseFloat(FontOptions.this.myLineSpacingField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                }
                finally {
                    if (lineSpacing <= 0.0f) {
                        lineSpacing = 1.0f;
                    }
                    if (lineSpacing > 30.0f) {
                        lineSpacing = 30.0f;
                    }
                    if (FontOptions.this.getCurrentScheme().getLineSpacing() != lineSpacing) {
                        FontOptions.this.getCurrentScheme().setLineSpacing(lineSpacing);
                    }
                    FontOptions.this.updateDescription(true);
                }
            }
        });
        return editorFontPanel;
    }

    private void selectFont() {
        this.initFontTables();
        List fontNamesVector = (List)myFontNamesVector.clone();
        HashMap fontNameToIsMonospaced = (HashMap)myFontNameToIsMonospaced.clone();
        String initialFontName = this.myFontNameField.getText();
        if (!fontNamesVector.contains("Courier")) {
            fontNamesVector.add(0, "Courier");
        }
        if (!fontNamesVector.contains(initialFontName)) {
            fontNamesVector.add(0, initialFontName);
        }
        SelectFontDialog selectFontDialog = new SelectFontDialog(this, fontNamesVector, initialFontName, fontNameToIsMonospaced);
        selectFontDialog.show();
        if (!selectFontDialog.isOK()) {
            return;
        }
        String fontName = selectFontDialog.getFontName();
        if (fontName != null) {
            this.myFontNameField.setText(fontName);
            this.getCurrentScheme().setEditorFontName(fontName);
            this.updateDescription(true);
        }
    }

    private void initFontTables() {
        if (myFontNamesVector == null) {
            myFontNamesVector = new ArrayList();
            myFontNameToIsMonospaced = new HashMap();
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)new InitFontsRunnable(), ApplicationBundle.message((String)"progress.analyzing.fonts", (Object[])new Object[0]), false, null);
        }
    }

    public boolean updateDescription(boolean modified) {
        EditorColorsScheme scheme = this.myOptions.getSelectedScheme();
        if (modified && (ColorAndFontOptions.isReadOnly(scheme) || ColorSettingsUtil.isSharedScheme(scheme))) {
            FontOptions.showReadOnlyMessage(this, ColorSettingsUtil.isSharedScheme(scheme));
            return false;
        }
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).fontChanged();
        return true;
    }

    public static void showReadOnlyMessage(JComponent parent, boolean sharedScheme) {
        if (!sharedScheme) {
            Messages.showMessageDialog((Component)parent, (String)ApplicationBundle.message((String)"error.readonly.scheme.cannot.be.modified", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"title.cannot.modify.readonly.scheme", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        } else {
            Messages.showMessageDialog((Component)parent, (String)ApplicationBundle.message((String)"error.shared.scheme.cannot.be.modified", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"title.cannot.modify.readonly.scheme", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        }
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Set<String> processListOptions() {
        return new HashSet<String>();
    }

    private static class MyTextField
    extends JTextField {
        private MyTextField(int size) {
            super(size);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private class InitFontsRunnable
    implements Runnable {
        private InitFontsRunnable() {
        }

        @Override
        public void run() {
            String[] fontNames;
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (String fontName : fontNames = graphicsEnvironment.getAvailableFontFamilyNames()) {
                if (fontName.endsWith(".bold") || fontName.endsWith(".italic")) continue;
                try {
                    Font plainFont = new Font(fontName, 0, 12);
                    if (!plainFont.canDisplay('W')) continue;
                    Font boldFont = plainFont.deriveFont(1);
                    if (progress != null) {
                        progress.setText(ApplicationBundle.message((String)"progress.analysing.font", (Object[])new Object[]{fontName}));
                    }
                    FontMetrics plainMetrics = FontOptions.this.getFontMetrics(plainFont);
                    FontMetrics boldMetrics = FontOptions.this.getFontMetrics(boldFont);
                    myFontNamesVector.add(fontName);
                    int plainL = plainMetrics.charWidth('l');
                    int boldL = boldMetrics.charWidth('l');
                    int plainW = plainMetrics.charWidth('W');
                    int boldW = boldMetrics.charWidth('W');
                    int plainSpace = plainMetrics.charWidth(' ');
                    int boldSpace = boldMetrics.charWidth(' ');
                    boolean isMonospaced = plainL == plainW && plainL == boldL && plainW == boldW && plainSpace == boldSpace;
                    myFontNameToIsMonospaced.put((Object)fontName, (Object)isMonospaced);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
    }
}

