/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.OptionGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CodeStyleIndentAndBracesPanel
extends MultilanguageCodeStyleAbstractPanel {
    private static final String[] BRACE_PLACEMENT_OPTIONS = new String[]{ApplicationBundle.message((String)"combobox.brace.placement.end.of.line", (Object[])new Object[0]), ApplicationBundle.message((String)"combobox.brace.placement.next.line.if.wrapped", (Object[])new Object[0]), ApplicationBundle.message((String)"combobox.brace.placement.next.line", (Object[])new Object[0]), ApplicationBundle.message((String)"combobox.brace.placement.next.line.shifted", (Object[])new Object[0]), ApplicationBundle.message((String)"combobox.brace.placement.next.line.shifted2", (Object[])new Object[0])};
    private static final int[] BRACE_PLACEMENT_VALUES = new int[]{1, 5, 2, 3, 4};
    private static final String[] BRACE_FORCE_OPTIONS = new String[]{ApplicationBundle.message((String)"combobox.force.braces.do.not.force", (Object[])new Object[0]), ApplicationBundle.message((String)"combobox.force.braces.when.multiline", (Object[])new Object[0]), ApplicationBundle.message((String)"combobox.force.braces.always", (Object[])new Object[0])};
    private static final int[] BRACE_FORCE_VALUES = new int[]{0, 1, 3};
    private JComboBox myClassDeclarationCombo = new JComboBox();
    private JComboBox myMethodDeclarationCombo = new JComboBox();
    private JComboBox myOtherCombo = new JComboBox();
    private JCheckBox myCbElseOnNewline;
    private JCheckBox myCbWhileOnNewline;
    private JCheckBox myCbCatchOnNewline;
    private JCheckBox myCbFinallyOnNewline;
    private JCheckBox myCbSpecialElseIfTreatment;
    private JCheckBox myCbIndentCaseFromSwitch;
    private JComboBox myIfForceCombo;
    private JComboBox myForForceCombo;
    private JComboBox myWhileForceCombo;
    private JComboBox myDoWhileForceCombo;
    private JCheckBox myAlignDeclarationParameters;
    private JCheckBox myAlignCallParameters;
    private JCheckBox myAlignExtendsList;
    private JCheckBox myAlignForStatement;
    private JCheckBox myAlignThrowsList;
    private JCheckBox myAlignParenthesizedExpression;
    private JCheckBox myAlignBinaryExpression;
    private JCheckBox myAlignTernaryExpression;
    private JCheckBox myAlignAssignment;
    private JCheckBox myAlignArrayInitializerExpression;
    private JCheckBox myKeepLineBreaks;
    private JCheckBox myKeepCommentAtFirstColumn;
    private JCheckBox myKeepMethodsInOneLine;
    private JCheckBox myKeepSimpleBlocksInOneLine;
    private JCheckBox myKeepControlStatementInOneLine;
    private final JPanel myPanel = new JPanel(new GridBagLayout());

    public CodeStyleIndentAndBracesPanel(CodeStyleSettings settings) {
        super(settings);
        this.myPanel.add(this.createKeepWhenReformatingPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 4, 0, 4), 0, 0));
        this.myPanel.add((Component)this.createBracesPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 4, 0, 4), 0, 0));
        this.myPanel.add((Component)this.createAlignmentsPanel(), new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(0, 4, 0, 4), 0, 0));
        this.myPanel.add((Component)this.createPlaceOnNewLinePanel(), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 4, 0, 4), 0, 0));
        this.myPanel.add((Component)this.createForceBracesPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 4, 0, 4), 0, 0));
        this.myPanel.add((Component)new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(1, 1);
            }
        }, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel previewPanel = CodeStyleIndentAndBracesPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(2, 0, 1, 4, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
    }

    @Override
    protected LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.INDENT_AND_BRACES_SETTINGS;
    }

    private Component createKeepWhenReformatingPanel() {
        OptionGroup optionGroup = new OptionGroup(ApplicationBundle.message((String)"title.keep.when.reformatting", (Object[])new Object[0]));
        this.myKeepLineBreaks = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.keep.when.reformatting.line.breaks", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myKeepLineBreaks);
        this.myKeepCommentAtFirstColumn = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.keep.when.reformatting.comment.at.first.column", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myKeepCommentAtFirstColumn);
        this.myKeepMethodsInOneLine = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.keep.when.reformatting.simple.methods.in.one.line", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myKeepMethodsInOneLine);
        this.myKeepSimpleBlocksInOneLine = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.keep.when.reformatting.simple.blocks.in.one.line", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myKeepSimpleBlocksInOneLine);
        this.myKeepControlStatementInOneLine = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.keep.when.reformatting.control.statement.in.one.line", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myKeepControlStatementInOneLine);
        return optionGroup.createPanel();
    }

    private JPanel createBracesPanel() {
        OptionGroup optionGroup = new OptionGroup(ApplicationBundle.message((String)"title.braces.placement", (Object[])new Object[0]));
        this.myClassDeclarationCombo = CodeStyleIndentAndBracesPanel.createBraceStyleCombo();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"combobox.brace.placement.class.declaration", (Object[])new Object[0])), (JComponent)this.myClassDeclarationCombo);
        this.myMethodDeclarationCombo = CodeStyleIndentAndBracesPanel.createBraceStyleCombo();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"combobox.brace.placement.method.declaration", (Object[])new Object[0])), (JComponent)this.myMethodDeclarationCombo);
        this.myOtherCombo = CodeStyleIndentAndBracesPanel.createBraceStyleCombo();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"combobox.brace.placement.other", (Object[])new Object[0])), (JComponent)this.myOtherCombo);
        this.myCbSpecialElseIfTreatment = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.brace.special.else.if.treatment", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbSpecialElseIfTreatment);
        this.myCbIndentCaseFromSwitch = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.brace.indent.case.from.switch", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbIndentCaseFromSwitch);
        return optionGroup.createPanel();
    }

    private JPanel createForceBracesPanel() {
        OptionGroup optionGroup = new OptionGroup(ApplicationBundle.message((String)"title.force.braces", (Object[])new Object[0]));
        this.myIfForceCombo = CodeStyleIndentAndBracesPanel.createForceBracesCombo();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"combobox.force.braces.if", (Object[])new Object[0])), (JComponent)this.myIfForceCombo);
        this.myForForceCombo = CodeStyleIndentAndBracesPanel.createForceBracesCombo();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"combobox.force.braces.for", (Object[])new Object[0])), (JComponent)this.myForForceCombo);
        this.myWhileForceCombo = CodeStyleIndentAndBracesPanel.createForceBracesCombo();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"combobox.force.braces.while", (Object[])new Object[0])), (JComponent)this.myWhileForceCombo);
        this.myDoWhileForceCombo = CodeStyleIndentAndBracesPanel.createForceBracesCombo();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"combobox.force.braces.do.while", (Object[])new Object[0])), (JComponent)this.myDoWhileForceCombo);
        return optionGroup.createPanel();
    }

    private JPanel createAlignmentsPanel() {
        OptionGroup optionGroup = new OptionGroup(ApplicationBundle.message((String)"title.align.when.multiline", (Object[])new Object[0]));
        this.myAlignDeclarationParameters = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.method.parameters", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignDeclarationParameters);
        this.myAlignCallParameters = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.call.arguments", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignCallParameters);
        this.myAlignExtendsList = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.extends.list", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignExtendsList);
        this.myAlignThrowsList = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.throws.list", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignThrowsList);
        this.myAlignParenthesizedExpression = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.parenthesized.expression", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignParenthesizedExpression);
        this.myAlignBinaryExpression = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.binary.operation", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignBinaryExpression);
        this.myAlignTernaryExpression = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.ternary.operation", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignTernaryExpression);
        this.myAlignAssignment = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.assignments", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignAssignment);
        this.myAlignForStatement = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.for.statement", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignForStatement);
        this.myAlignArrayInitializerExpression = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.align.multiline.array.initializer", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myAlignArrayInitializerExpression);
        return optionGroup.createPanel();
    }

    private JPanel createPlaceOnNewLinePanel() {
        OptionGroup optionGroup = new OptionGroup(ApplicationBundle.message((String)"title.place.on.new.line", (Object[])new Object[0]));
        this.myCbElseOnNewline = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.place.else.on.new.line", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbElseOnNewline);
        this.myCbWhileOnNewline = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.place.while.on.new.line", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbWhileOnNewline);
        this.myCbCatchOnNewline = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.place.catch.on.new.line", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbCatchOnNewline);
        this.myCbFinallyOnNewline = CodeStyleIndentAndBracesPanel.createCheckBox(ApplicationBundle.message((String)"checkbox.place.finally.on.new.line", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbFinallyOnNewline);
        return optionGroup.createPanel();
    }

    private static JCheckBox createCheckBox(String text) {
        return new JCheckBox(text);
    }

    private static JComboBox createForceBracesCombo() {
        return new JComboBox<String>(BRACE_FORCE_OPTIONS);
    }

    private static void setForceBracesComboValue(JComboBox comboBox, int value) {
        for (int i = 0; i < BRACE_FORCE_VALUES.length; ++i) {
            int forceValue = BRACE_FORCE_VALUES[i];
            if (forceValue != value) continue;
            comboBox.setSelectedItem(BRACE_FORCE_OPTIONS[i]);
        }
    }

    private static int getForceBracesValue(JComboBox comboBox) {
        String selected = (String)comboBox.getSelectedItem();
        for (int i = 0; i < BRACE_FORCE_OPTIONS.length; ++i) {
            String s = BRACE_FORCE_OPTIONS[i];
            if (!s.equals(selected)) continue;
            return BRACE_FORCE_VALUES[i];
        }
        return 0;
    }

    private static JComboBox createBraceStyleCombo() {
        return new JComboBox<String>(BRACE_PLACEMENT_OPTIONS);
    }

    private static void setBraceStyleComboValue(JComboBox comboBox, int value) {
        for (int i = 0; i < BRACE_PLACEMENT_OPTIONS.length; ++i) {
            if (BRACE_PLACEMENT_VALUES[i] != value) continue;
            comboBox.setSelectedItem(BRACE_PLACEMENT_OPTIONS[i]);
            return;
        }
    }

    private static int getBraceComboValue(JComboBox comboBox) {
        Object item = comboBox.getSelectedItem();
        for (int i = 1; i < BRACE_PLACEMENT_OPTIONS.length; ++i) {
            if (!BRACE_PLACEMENT_OPTIONS[i].equals(item)) continue;
            return BRACE_PLACEMENT_VALUES[i];
        }
        return BRACE_PLACEMENT_VALUES[0];
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        boolean isModified = CodeStyleIndentAndBracesPanel.isModified(this.myCbElseOnNewline, settings.ELSE_ON_NEW_LINE);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myCbWhileOnNewline, settings.WHILE_ON_NEW_LINE);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myCbCatchOnNewline, settings.CATCH_ON_NEW_LINE);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myCbFinallyOnNewline, settings.FINALLY_ON_NEW_LINE);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myCbSpecialElseIfTreatment, settings.SPECIAL_ELSE_IF_TREATMENT);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myCbIndentCaseFromSwitch, settings.INDENT_CASE_FROM_SWITCH);
        isModified |= settings.BRACE_STYLE != CodeStyleIndentAndBracesPanel.getBraceComboValue(this.myOtherCombo);
        isModified |= settings.CLASS_BRACE_STYLE != CodeStyleIndentAndBracesPanel.getBraceComboValue(this.myClassDeclarationCombo);
        isModified |= settings.METHOD_BRACE_STYLE != CodeStyleIndentAndBracesPanel.getBraceComboValue(this.myMethodDeclarationCombo);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignAssignment, settings.ALIGN_MULTILINE_ASSIGNMENT);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignBinaryExpression, settings.ALIGN_MULTILINE_BINARY_OPERATION);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignCallParameters, settings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignDeclarationParameters, settings.ALIGN_MULTILINE_PARAMETERS);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignExtendsList, settings.ALIGN_MULTILINE_EXTENDS_LIST);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignForStatement, settings.ALIGN_MULTILINE_FOR);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignParenthesizedExpression, settings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignTernaryExpression, settings.ALIGN_MULTILINE_TERNARY_OPERATION);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignThrowsList, settings.ALIGN_MULTILINE_THROWS_LIST);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myAlignArrayInitializerExpression, settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION);
        isModified |= settings.FOR_BRACE_FORCE != CodeStyleIndentAndBracesPanel.getForceBracesValue(this.myForForceCombo);
        isModified |= settings.IF_BRACE_FORCE != CodeStyleIndentAndBracesPanel.getForceBracesValue(this.myIfForceCombo);
        isModified |= settings.WHILE_BRACE_FORCE != CodeStyleIndentAndBracesPanel.getForceBracesValue(this.myWhileForceCombo);
        isModified |= settings.DOWHILE_BRACE_FORCE != CodeStyleIndentAndBracesPanel.getForceBracesValue(this.myDoWhileForceCombo);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myKeepLineBreaks, settings.KEEP_LINE_BREAKS);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myKeepCommentAtFirstColumn, settings.KEEP_FIRST_COLUMN_COMMENT);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myKeepControlStatementInOneLine, settings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE);
        isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myKeepSimpleBlocksInOneLine, settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        return isModified |= CodeStyleIndentAndBracesPanel.isModified(this.myKeepMethodsInOneLine, settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE);
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.myCbElseOnNewline.setSelected(settings.ELSE_ON_NEW_LINE);
        this.myCbWhileOnNewline.setSelected(settings.WHILE_ON_NEW_LINE);
        this.myCbCatchOnNewline.setSelected(settings.CATCH_ON_NEW_LINE);
        this.myCbFinallyOnNewline.setSelected(settings.FINALLY_ON_NEW_LINE);
        this.myCbSpecialElseIfTreatment.setSelected(settings.SPECIAL_ELSE_IF_TREATMENT);
        this.myCbIndentCaseFromSwitch.setSelected(settings.INDENT_CASE_FROM_SWITCH);
        CodeStyleIndentAndBracesPanel.setBraceStyleComboValue(this.myOtherCombo, settings.BRACE_STYLE);
        CodeStyleIndentAndBracesPanel.setBraceStyleComboValue(this.myClassDeclarationCombo, settings.CLASS_BRACE_STYLE);
        CodeStyleIndentAndBracesPanel.setBraceStyleComboValue(this.myMethodDeclarationCombo, settings.METHOD_BRACE_STYLE);
        this.myAlignAssignment.setSelected(settings.ALIGN_MULTILINE_ASSIGNMENT);
        this.myAlignBinaryExpression.setSelected(settings.ALIGN_MULTILINE_BINARY_OPERATION);
        this.myAlignCallParameters.setSelected(settings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS);
        this.myAlignDeclarationParameters.setSelected(settings.ALIGN_MULTILINE_PARAMETERS);
        this.myAlignExtendsList.setSelected(settings.ALIGN_MULTILINE_EXTENDS_LIST);
        this.myAlignForStatement.setSelected(settings.ALIGN_MULTILINE_FOR);
        this.myAlignParenthesizedExpression.setSelected(settings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION);
        this.myAlignTernaryExpression.setSelected(settings.ALIGN_MULTILINE_TERNARY_OPERATION);
        this.myAlignThrowsList.setSelected(settings.ALIGN_MULTILINE_THROWS_LIST);
        this.myAlignArrayInitializerExpression.setSelected(settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION);
        CodeStyleIndentAndBracesPanel.setForceBracesComboValue(this.myForForceCombo, settings.FOR_BRACE_FORCE);
        CodeStyleIndentAndBracesPanel.setForceBracesComboValue(this.myIfForceCombo, settings.IF_BRACE_FORCE);
        CodeStyleIndentAndBracesPanel.setForceBracesComboValue(this.myWhileForceCombo, settings.WHILE_BRACE_FORCE);
        CodeStyleIndentAndBracesPanel.setForceBracesComboValue(this.myDoWhileForceCombo, settings.DOWHILE_BRACE_FORCE);
        this.myKeepLineBreaks.setSelected(settings.KEEP_LINE_BREAKS);
        this.myKeepCommentAtFirstColumn.setSelected(settings.KEEP_FIRST_COLUMN_COMMENT);
        this.myKeepControlStatementInOneLine.setSelected(settings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE);
        this.myKeepSimpleBlocksInOneLine.setSelected(settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
        this.myKeepMethodsInOneLine.setSelected(settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE);
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        settings.ELSE_ON_NEW_LINE = this.myCbElseOnNewline.isSelected();
        settings.WHILE_ON_NEW_LINE = this.myCbWhileOnNewline.isSelected();
        settings.CATCH_ON_NEW_LINE = this.myCbCatchOnNewline.isSelected();
        settings.FINALLY_ON_NEW_LINE = this.myCbFinallyOnNewline.isSelected();
        settings.SPECIAL_ELSE_IF_TREATMENT = this.myCbSpecialElseIfTreatment.isSelected();
        settings.INDENT_CASE_FROM_SWITCH = this.myCbIndentCaseFromSwitch.isSelected();
        settings.BRACE_STYLE = CodeStyleIndentAndBracesPanel.getBraceComboValue(this.myOtherCombo);
        settings.CLASS_BRACE_STYLE = CodeStyleIndentAndBracesPanel.getBraceComboValue(this.myClassDeclarationCombo);
        settings.METHOD_BRACE_STYLE = CodeStyleIndentAndBracesPanel.getBraceComboValue(this.myMethodDeclarationCombo);
        settings.ALIGN_MULTILINE_ASSIGNMENT = this.myAlignAssignment.isSelected();
        settings.ALIGN_MULTILINE_BINARY_OPERATION = this.myAlignBinaryExpression.isSelected();
        settings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = this.myAlignCallParameters.isSelected();
        settings.ALIGN_MULTILINE_PARAMETERS = this.myAlignDeclarationParameters.isSelected();
        settings.ALIGN_MULTILINE_EXTENDS_LIST = this.myAlignExtendsList.isSelected();
        settings.ALIGN_MULTILINE_FOR = this.myAlignForStatement.isSelected();
        settings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION = this.myAlignParenthesizedExpression.isSelected();
        settings.ALIGN_MULTILINE_TERNARY_OPERATION = this.myAlignTernaryExpression.isSelected();
        settings.ALIGN_MULTILINE_THROWS_LIST = this.myAlignThrowsList.isSelected();
        settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = this.myAlignArrayInitializerExpression.isSelected();
        settings.FOR_BRACE_FORCE = CodeStyleIndentAndBracesPanel.getForceBracesValue(this.myForForceCombo);
        settings.IF_BRACE_FORCE = CodeStyleIndentAndBracesPanel.getForceBracesValue(this.myIfForceCombo);
        settings.WHILE_BRACE_FORCE = CodeStyleIndentAndBracesPanel.getForceBracesValue(this.myWhileForceCombo);
        settings.DOWHILE_BRACE_FORCE = CodeStyleIndentAndBracesPanel.getForceBracesValue(this.myDoWhileForceCombo);
        settings.KEEP_LINE_BREAKS = this.myKeepLineBreaks.isSelected();
        settings.KEEP_FIRST_COLUMN_COMMENT = this.myKeepCommentAtFirstColumn.isSelected();
        settings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = this.myKeepControlStatementInOneLine.isSelected();
        settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = this.myKeepSimpleBlocksInOneLine.isSelected();
        settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = this.myKeepMethodsInOneLine.isSelected();
    }

    @Override
    protected int getRightMargin() {
        return -1;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
    }
}

