/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.OptionGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CodeStyleBlankLinesPanel
extends MultilanguageCodeStyleAbstractPanel {
    private JTextField myKeepBlankLinesInDeclarations;
    private JTextField myKeepBlankLinesInCode;
    private JTextField myBlankLinesBeforePackage;
    private JTextField myBlankLinesAfterPackage;
    private JTextField myBlankLinesBeforeImports;
    private JTextField myBlankLinesAfterImports;
    private JTextField myBlankLinesAroundClass;
    private JTextField myBlankLinesAroundField;
    private JTextField myBlankLinesAroundMethod;
    private JTextField myBlankLinesAroundFieldI;
    private JTextField myBlankLinesAroundMethodI;
    private JTextField myBlankLinesAfterClassHeader;
    private JTextField myKeepBlankLinesBeforeRBrace;
    private final JPanel myPanel = new JPanel(new GridBagLayout());

    public CodeStyleBlankLinesPanel(CodeStyleSettings settings) {
        super(settings);
        this.myPanel.add((Component)this.createKeepBlankLinesPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 4, 0, 4), 0, 0));
        this.myPanel.add((Component)this.createBlankLinesPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 4, 0, 4), 0, 0));
        JPanel previewPanel = CodeStyleBlankLinesPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
    }

    @Override
    protected LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINE_SETTINGS;
    }

    private JPanel createBlankLinesPanel() {
        OptionGroup optionGroup = new OptionGroup(ApplicationBundle.message((String)"title.blank.lines", (Object[])new Object[0]));
        this.myBlankLinesBeforePackage = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.blanklines.before.package.statement", (Object[])new Object[0])), (JComponent)this.myBlankLinesBeforePackage);
        this.myBlankLinesAfterPackage = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.blanklines.after.package.statement", (Object[])new Object[0])), (JComponent)this.myBlankLinesAfterPackage);
        this.myBlankLinesBeforeImports = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.blanklines.before.imports", (Object[])new Object[0])), (JComponent)this.myBlankLinesBeforeImports);
        this.myBlankLinesAfterImports = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.blanklines.after.imports", (Object[])new Object[0])), (JComponent)this.myBlankLinesAfterImports);
        this.myBlankLinesAroundClass = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.blanklines.around.class", (Object[])new Object[0])), (JComponent)this.myBlankLinesAroundClass);
        this.myBlankLinesAroundField = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.blanklines.around.field", (Object[])new Object[0])), (JComponent)this.myBlankLinesAroundField);
        this.myBlankLinesAroundMethod = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.blanklines.around.method", (Object[])new Object[0])), (JComponent)this.myBlankLinesAroundMethod);
        this.myBlankLinesAroundFieldI = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel("Around field in interface:"), (JComponent)this.myBlankLinesAroundFieldI);
        this.myBlankLinesAroundMethodI = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel("Around method in interface:"), (JComponent)this.myBlankLinesAroundMethodI);
        this.myBlankLinesAfterClassHeader = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.blanklines.after.class.header", (Object[])new Object[0])), (JComponent)this.myBlankLinesAfterClassHeader);
        return optionGroup.createPanel();
    }

    private JPanel createKeepBlankLinesPanel() {
        OptionGroup optionGroup = new OptionGroup(ApplicationBundle.message((String)"title.keep.blank.lines", (Object[])new Object[0]));
        this.myKeepBlankLinesInDeclarations = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.keep.blanklines.in.declarations", (Object[])new Object[0])), (JComponent)this.myKeepBlankLinesInDeclarations);
        this.myKeepBlankLinesInCode = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.keep.blanklines.in.code", (Object[])new Object[0])), (JComponent)this.myKeepBlankLinesInCode);
        this.myKeepBlankLinesBeforeRBrace = CodeStyleBlankLinesPanel.createTextField();
        optionGroup.add((JComponent)new JLabel(ApplicationBundle.message((String)"editbox.keep.blanklines.before.rbrace", (Object[])new Object[0])), (JComponent)this.myKeepBlankLinesBeforeRBrace);
        return optionGroup.createPanel();
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.myKeepBlankLinesInDeclarations.setText(String.valueOf(settings.KEEP_BLANK_LINES_IN_DECLARATIONS));
        this.myKeepBlankLinesInCode.setText(String.valueOf(settings.KEEP_BLANK_LINES_IN_CODE));
        this.myKeepBlankLinesBeforeRBrace.setText(String.valueOf(settings.KEEP_BLANK_LINES_BEFORE_RBRACE));
        this.myBlankLinesBeforePackage.setText(String.valueOf(settings.BLANK_LINES_BEFORE_PACKAGE));
        this.myBlankLinesAfterPackage.setText(String.valueOf(settings.BLANK_LINES_AFTER_PACKAGE));
        this.myBlankLinesBeforeImports.setText(String.valueOf(settings.BLANK_LINES_BEFORE_IMPORTS));
        this.myBlankLinesAfterImports.setText(String.valueOf(settings.BLANK_LINES_AFTER_IMPORTS));
        this.myBlankLinesAroundClass.setText(String.valueOf(settings.BLANK_LINES_AROUND_CLASS));
        this.myBlankLinesAroundField.setText(String.valueOf(settings.BLANK_LINES_AROUND_FIELD));
        this.myBlankLinesAroundMethod.setText(String.valueOf(settings.BLANK_LINES_AROUND_METHOD));
        this.myBlankLinesAroundFieldI.setText(String.valueOf(settings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE));
        this.myBlankLinesAroundMethodI.setText(String.valueOf(settings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE));
        this.myBlankLinesAfterClassHeader.setText(String.valueOf(settings.BLANK_LINES_AFTER_CLASS_HEADER));
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        settings.KEEP_BLANK_LINES_IN_DECLARATIONS = CodeStyleBlankLinesPanel.getValue(this.myKeepBlankLinesInDeclarations);
        settings.KEEP_BLANK_LINES_IN_CODE = CodeStyleBlankLinesPanel.getValue(this.myKeepBlankLinesInCode);
        settings.KEEP_BLANK_LINES_BEFORE_RBRACE = CodeStyleBlankLinesPanel.getValue(this.myKeepBlankLinesBeforeRBrace);
        settings.BLANK_LINES_BEFORE_PACKAGE = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesBeforePackage);
        settings.BLANK_LINES_AFTER_PACKAGE = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAfterPackage);
        settings.BLANK_LINES_BEFORE_IMPORTS = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesBeforeImports);
        settings.BLANK_LINES_AFTER_IMPORTS = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAfterImports);
        settings.BLANK_LINES_AROUND_CLASS = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundClass);
        settings.BLANK_LINES_AROUND_FIELD = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundField);
        settings.BLANK_LINES_AROUND_METHOD = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundMethod);
        settings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundFieldI);
        settings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundMethodI);
        settings.BLANK_LINES_AFTER_CLASS_HEADER = CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAfterClassHeader);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        boolean isModified = settings.KEEP_BLANK_LINES_IN_DECLARATIONS != CodeStyleBlankLinesPanel.getValue(this.myKeepBlankLinesInDeclarations);
        isModified |= settings.KEEP_BLANK_LINES_IN_CODE != CodeStyleBlankLinesPanel.getValue(this.myKeepBlankLinesInCode);
        isModified |= settings.KEEP_BLANK_LINES_BEFORE_RBRACE != CodeStyleBlankLinesPanel.getValue(this.myKeepBlankLinesBeforeRBrace);
        isModified |= settings.BLANK_LINES_BEFORE_PACKAGE != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesBeforePackage);
        isModified |= settings.BLANK_LINES_AFTER_PACKAGE != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAfterPackage);
        isModified |= settings.BLANK_LINES_BEFORE_IMPORTS != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesBeforeImports);
        isModified |= settings.BLANK_LINES_AFTER_IMPORTS != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAfterImports);
        isModified |= settings.BLANK_LINES_AROUND_CLASS != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundClass);
        isModified |= settings.BLANK_LINES_AROUND_FIELD != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundField);
        isModified |= settings.BLANK_LINES_AROUND_METHOD != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundMethod);
        isModified |= settings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundFieldI);
        isModified |= settings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAroundMethodI);
        return isModified |= settings.BLANK_LINES_AFTER_CLASS_HEADER != CodeStyleBlankLinesPanel.getValue(this.myBlankLinesAfterClassHeader);
    }

    private static int getValue(JTextField textField) {
        int ret = 0;
        try {
            ret = Integer.parseInt(textField.getText());
            if (ret < 0) {
                ret = 0;
            }
            if (ret > 10) {
                ret = 10;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    private static JTextField createTextField() {
        JTextField field = new JTextField(6);
        field.setMinimumSize(new Dimension(30, field.getMinimumSize().height));
        return field;
    }

    @Override
    protected int getRightMargin() {
        return 37;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
    }
}

