/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Icons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TagListDialog
extends DialogWrapper {
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JList myList = new JList(new DefaultListModel());
    private ArrayList<String> myData;

    public TagListDialog(String title) {
        super(true);
        this.myPanel.add((Component)this.createToolbal(), "North");
        this.myPanel.add((Component)this.createList(), "Center");
        this.setTitle(title);
        this.init();
    }

    public void setData(ArrayList<String> data) {
        this.myData = data;
        this.updateData();
        if (!this.myData.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
    }

    private void updateData() {
        DefaultListModel model = (DefaultListModel)this.myList.getModel();
        model.clear();
        for (String data : this.myData) {
            model.addElement(data);
        }
    }

    public ArrayList<String> getData() {
        return this.myData;
    }

    private JComponent createList() {
        return new JScrollPane(this.myList);
    }

    private JComponent createToolbal() {
        return ActionManager.getInstance().createActionToolbar("unknown", this.createActionGroup(), true).getComponent();
    }

    private ActionGroup createActionGroup() {
        DefaultActionGroup result = new DefaultActionGroup();
        AnAction addAction = this.createAddAction();
        addAction.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)this.myList);
        result.add(addAction);
        AnAction deleteAction = this.createDeleteAction();
        deleteAction.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)this.myList);
        result.add(deleteAction);
        return result;
    }

    private AnAction createDeleteAction() {
        return new IconWithTextAction(ApplicationBundle.message((String)"action.remove", (Object[])new Object[0]), null, Icons.DELETE_ICON){

            public void update(AnActionEvent e) {
                int selectedIndex = TagListDialog.this.myList.getSelectedIndex();
                if (selectedIndex >= 0) {
                    e.getPresentation().setEnabled(true);
                } else {
                    e.getPresentation().setEnabled(false);
                }
            }

            public void actionPerformed(AnActionEvent e) {
                int selectedIndex = TagListDialog.this.myList.getSelectedIndex();
                if (selectedIndex >= 0) {
                    TagListDialog.this.myData.remove(selectedIndex);
                    TagListDialog.this.updateData();
                    if (selectedIndex >= TagListDialog.this.myData.size()) {
                        --selectedIndex;
                    }
                    if (selectedIndex >= 0) {
                        TagListDialog.this.myList.setSelectedIndex(selectedIndex);
                    }
                }
            }
        };
    }

    private AnAction createAddAction() {
        return new IconWithTextAction(ApplicationBundle.message((String)"action.add", (Object[])new Object[0]), null, Icons.ADD_ICON){

            public void actionPerformed(AnActionEvent e) {
                String tagName = Messages.showInputDialog((String)ApplicationBundle.message((String)"editbox.enter.tag.name", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"title.tag.name", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (tagName != null) {
                    while (TagListDialog.this.myData.contains(tagName)) {
                        TagListDialog.this.myData.remove(tagName);
                    }
                    TagListDialog.this.myData.add(tagName);
                    TagListDialog.this.updateData();
                    TagListDialog.this.myList.setSelectedIndex(TagListDialog.this.myData.size() - 1);
                }
            }
        };
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }
}

