/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnalysisAction
extends AnAction {
    private final String myTitle;
    private final String myAnalysisNoon;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.analysis.BaseAnalysisAction");

    protected BaseAnalysisAction(String title, String analysisNoon) {
        this.myTitle = title;
        this.myAnalysisNoon = analysisNoon;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(BaseAnalysisAction.getInspectionScope(event.getDataContext()) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (project == null) {
            return;
        }
        AnalysisScope scope = BaseAnalysisAction.getInspectionScope(dataContext);
        LOG.assertTrue(scope != null);
        boolean rememberScope = e.getPlace().equals("MainMenu");
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project);
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{this.myTitle}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{this.myAnalysisNoon}), project, scope, module != null && scope.getScopeType() != 4 ? ModuleUtil.getModuleNameInReadAction((Module)module) : null, rememberScope, AnalysisUIOptions.getInstance(project), element){

            @Override
            @Nullable
            protected JComponent getAdditionalActionSettings(Project project) {
                return BaseAnalysisAction.this.getAdditionalActionSettings(project, this);
            }

            protected void doHelpAction() {
                HelpManager.getInstance().invokeHelp(BaseAnalysisAction.this.getHelpTopic());
            }

            protected Action[] createActions() {
                return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
            }
        };
        dlg.show();
        if (!dlg.isOK()) {
            this.canceled();
            return;
        }
        int oldScopeType = uiOptions.SCOPE_TYPE;
        scope = dlg.getScope(uiOptions, scope, project, module);
        if (!rememberScope) {
            uiOptions.SCOPE_TYPE = oldScopeType;
        }
        uiOptions.ANALYZE_TEST_SOURCES = dlg.isInspectTestSources();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.analyze(project, scope);
    }

    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.analyzeDependencies.scope";
    }

    protected void canceled() {
    }

    protected abstract void analyze(@NotNull Project var1, AnalysisScope var2);

    @Nullable
    private static AnalysisScope getInspectionScope(DataContext dataContext) {
        if (PlatformDataKeys.PROJECT.getData(dataContext) == null) {
            return null;
        }
        AnalysisScope scope = BaseAnalysisAction.getInspectionScopeImpl(dataContext);
        return scope != null && scope.getScopeType() != 6 ? scope : null;
    }

    @Nullable
    private static AnalysisScope getInspectionScopeImpl(DataContext dataContext) {
        Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
        if (projectContext != null) {
            return new AnalysisScope(projectContext);
        }
        AnalysisScope analysisScope = (AnalysisScope)AnalysisScope.KEY.getData(dataContext);
        if (analysisScope != null) {
            return analysisScope;
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (moduleContext != null) {
            return new AnalysisScope(moduleContext);
        }
        Module[] modulesArray = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modulesArray != null) {
            return new AnalysisScope(modulesArray);
        }
        PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null && psiFile.getManager().isInProject((PsiElement)psiFile)) {
            return new AnalysisScope(psiFile);
        }
        PsiElement psiTarget = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiTarget instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)psiTarget;
            if (!psiDirectory.getManager().isInProject((PsiElement)psiDirectory)) {
                return null;
            }
            return new AnalysisScope(psiDirectory);
        }
        if (psiTarget != null) {
            return null;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles != null) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (VirtualFile vFile : virtualFiles) {
                if (!fileIndex.isInContent(vFile)) continue;
                if (vFile instanceof VirtualFileWindow) {
                    files.add(vFile);
                    vFile = ((VirtualFileWindow)vFile).getDelegate();
                }
                BaseAnalysisAction.traverseDirectory(vFile, files);
            }
            return new AnalysisScope(project, files);
        }
        return BaseAnalysisAction.getProjectScope(dataContext);
    }

    private static AnalysisScope getProjectScope(DataContext dataContext) {
        return new AnalysisScope((Project)PlatformDataKeys.PROJECT.getData(dataContext));
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        return null;
    }

    private static void traverseDirectory(VirtualFile vFile, Set<VirtualFile> files) {
        if (vFile.isDirectory()) {
            VirtualFile[] virtualFiles;
            for (VirtualFile virtualFile : virtualFiles = vFile.getChildren()) {
                BaseAnalysisAction.traverseDirectory(virtualFile, files);
            }
        } else {
            files.add(vFile);
        }
    }
}

