/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.benchmark;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TLinkableAdaptor;
import gnu.trove.TLinkedList;
import gnu.trove.TObjectProcedure;
import gnu.trove.benchmark.Operation;
import gnu.trove.benchmark.Repeater;
import gnu.trove.benchmark.TextReporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Main {
    static final int SET_SIZE = 100000;
    static final List dataset = new ArrayList(100000);

    public static Operation getSetOperation() {
        return new Operation(){

            public void theirs() {
                HashSet s = new HashSet(100000);
                Iterator i = dataset.iterator();
                while (i.hasNext()) {
                    s.add(i.next());
                }
            }

            public void ours() {
                THashSet s = new THashSet(100000);
                Iterator i = dataset.iterator();
                while (i.hasNext()) {
                    s.add(i.next());
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " Set.add() operations";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    public static Operation getLinkedListAddOp() {
        final ArrayList<TLinkableAdaptor> data = new ArrayList<TLinkableAdaptor>(100000);
        for (int i = 0; i < 100000; ++i) {
            data.add(new TLinkableAdaptor());
        }
        return new Operation(){

            public void theirs() {
                LinkedList l = new LinkedList();
                Iterator i = data.iterator();
                while (i.hasNext()) {
                    l.add(i.next());
                }
            }

            public void ours() {
                TLinkedList l = new TLinkedList();
                Iterator i = data.iterator();
                while (i.hasNext()) {
                    l.add(i.next());
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " LinkedList.add() operations";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getContainsOp() {
        final HashSet theirs = new HashSet(dataset.size());
        theirs.addAll(dataset);
        final THashSet ours = new THashSet(dataset.size());
        ours.addAll(dataset);
        return new Operation(){

            public void theirs() {
                for (int i = 0; i < dataset.size(); i += 5) {
                    theirs.contains(dataset.get(i));
                }
            }

            public void ours() {
                for (int i = 0; i < dataset.size(); i += 5) {
                    ours.contains(dataset.get(i));
                }
            }

            public String toString() {
                return "compares " + dataset.size() / 5 + " Set.contains() operations";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getRandomSetContainsOp() {
        final HashSet<Integer> theirs = new HashSet<Integer>(100000);
        final THashSet<Integer> ours = new THashSet<Integer>(100000);
        Random rand = new Random(9999L);
        for (int i = 0; i < 100000; ++i) {
            Integer x = new Integer(rand.nextInt());
            theirs.add(x);
            ours.add(x);
        }
        Random rand2 = new Random(9998L);
        final ArrayList<Integer> query = new ArrayList<Integer>(100000);
        int match = 0;
        for (int i = 0; i < 100000; ++i) {
            Integer x = new Integer(rand.nextInt());
            query.add(x);
            if (!theirs.contains(x)) continue;
            ++match;
        }
        final int success = match;
        return new Operation(){

            public void theirs() {
                Iterator i = query.iterator();
                while (i.hasNext()) {
                    theirs.contains(i.next());
                }
            }

            public void ours() {
                Iterator i = query.iterator();
                while (i.hasNext()) {
                    ours.contains(i.next());
                }
            }

            public String toString() {
                return "compares 100000 Set.contains() operations. " + success + " are actually present in set";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getMapPutOp() {
        return new Operation(){

            public void theirs() {
                HashMap theirs = new HashMap(dataset.size());
                for (Object o : dataset) {
                    theirs.put(o, o);
                }
            }

            public void ours() {
                THashMap ours = new THashMap(dataset.size());
                for (Object o : dataset) {
                    ours.put(o, o);
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " Map.put() operations";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIterationOp() {
        final HashMap theirMap = new HashMap(dataset.size());
        final THashMap ourMap = new THashMap(dataset.size());
        for (Object o : dataset) {
            theirMap.put(o, o);
            ourMap.put(o, o);
        }
        return new Operation(){

            public void theirs() {
                Map m = theirMap;
                Iterator i = m.keySet().iterator();
                int size = m.size();
                while (size-- > 0) {
                    Object o = i.next();
                }
            }

            public void ours() {
                Map m = ourMap;
                Iterator i = m.keySet().iterator();
                int size = m.size();
                while (size-- > 0) {
                    Object o = i.next();
                }
            }

            public String toString() {
                return "compares Iterator.next() over " + dataset.size() + " map keys";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIterationWithHasNextOp() {
        final HashMap theirMap = new HashMap(dataset.size());
        final THashMap ourMap = new THashMap(dataset.size());
        for (Object o : dataset) {
            theirMap.put(o, o);
            ourMap.put(o, o);
        }
        return new Operation(){

            public void theirs() {
                Map m = theirMap;
                for (Object k : m.keySet()) {
                }
            }

            public void ours() {
                Map m = ourMap;
                for (Object k : m.keySet()) {
                }
            }

            public String toString() {
                return "compares Iterator.hasNext()/ Iterator.next() over " + theirMap.size() + " keys";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIntMapPut() {
        return new Operation(){

            public void theirs() {
            }

            public void ours() {
                TIntIntHashMap ours = new TIntIntHashMap(100000);
                int i = dataset.size();
                while (i-- > 0) {
                    ours.put(i, i);
                }
            }

            public String toString() {
                return dataset.size() + " entry primitive int map.put timing run; no basis for comparison";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getSumSetOperation() {
        final HashSet theirSet = new HashSet(dataset.size());
        final THashSet ourSet = new THashSet(dataset.size());
        theirSet.addAll(dataset);
        ourSet.addAll(dataset);
        final TObjectProcedure proc = new TObjectProcedure(){
            int sum = 0;

            public boolean execute(Object o) {
                this.sum += ((Integer)o).intValue();
                return true;
            }
        };
        return new Operation(){

            public void theirs() {
                int sum = 0;
                Iterator i = theirSet.iterator();
                while (i.hasNext()) {
                    sum += ((Integer)i.next()).intValue();
                }
            }

            public void ours() {
                ourSet.forEach(proc);
            }

            public String toString() {
                return "sums a " + theirSet.size() + " element Set of Integer objects.  Their approach uses Iterator.hasNext()/next(); ours uses THashSet.forEach(TObjectProcedure)";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    public static void main(String[] args) {
        TextReporter reporter = new TextReporter();
        reporter.start();
        Operation op = Main.getRandomSetContainsOp();
        Repeater t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getSumSetOperation();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getIterationWithHasNextOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getIterationOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getLinkedListAddOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getIntMapPut();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getMapPutOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getContainsOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getSetOperation();
        t = new Repeater(op);
        reporter.report(t.run());
        reporter.finish();
    }

    static {
        for (int i = 0; i < 100000; ++i) {
            dataset.add(new Integer(i));
        }
    }
}

