/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.ui.DebuggerIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XLineBreakpointType<P extends XBreakpointProperties>
extends XBreakpointType<XLineBreakpoint<P>, P> {
    protected XLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XLineBreakpointType.<init> must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XLineBreakpointType.<init> must not be null");
        }
        super(id, title);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XLineBreakpointType.canPutAt must not be null");
        }
        return false;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XLineBreakpointType.canPutAt must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XLineBreakpointType.canPutAt must not be null");
        }
        return this.canPutAt(file, line);
    }

    public abstract P createBreakpointProperties(@NotNull VirtualFile var1, int var2);

    @Override
    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        return XDebuggerBundle.message("xbreakpoint.default.display.text", breakpoint.getLine() + 1, breakpoint.getPresentableFilePath());
    }

    @NotNull
    public Icon getDisabledDependentIcon() {
        Icon icon = DebuggerIcons.DISABLED_DEPENDENT_BREAKPOINT_ICON;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/breakpoints/XLineBreakpointType.getDisabledDependentIcon must not return null");
        }
        return icon;
    }

    @Override
    @NotNull
    public Comparator<XLineBreakpoint<P>> getBreakpointComparator() {
        Comparator comparator = XDebuggerUtil.getInstance().getDefaultLineBreakpointComparator();
        if (comparator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/breakpoints/XLineBreakpointType.getBreakpointComparator must not return null");
        }
        return comparator;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<P> breakpoint, @Nullable XDebugSession currentSession) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XLineBreakpointType.getAdditionalPopupMenuActions must not be null");
        }
        return Collections.emptyList();
    }
}

